/*
 * Decompiled with CFR 0.152.
 */
package dr.xml.unittest;

import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeastUnitTest
implements Reportable {
    private final String message;
    private final String actual;
    private final String expected;
    private Boolean pass;
    private final AssertType assertType;
    private static final String CHECK = "assertEqual";
    private static final String MESSAGE = "message";
    private static final String EXPECTED = "expected";
    private static final String ACTUAL = "actual";
    private static final String REGEX = "regex";
    private static final String TOLERANCE_STRING = "tolerance";
    private static final String VERBOSE = "verbose";
    private static final String STRIP_CHARACTERS = "charactersToStrip";
    private static final String TOLERANCE_TYPE = "toleranceType";
    private static final String ABSOLUTE = "absolute";
    private static final String RELATIVE = "relative";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AssertType assertType;
            String string = null;
            if (xMLObject.hasChildNamed(BeastUnitTest.MESSAGE)) {
                string = xMLObject.getChild(BeastUnitTest.MESSAGE).getStringChild(0);
            }
            String string2 = this.parseValue(xMLObject.getChild(BeastUnitTest.EXPECTED));
            String string3 = this.parseValue(xMLObject.getChild(BeastUnitTest.ACTUAL));
            String string4 = xMLObject.getAttribute(BeastUnitTest.STRIP_CHARACTERS, ",");
            if (xMLObject.hasAttribute(BeastUnitTest.TOLERANCE_STRING)) {
                AssertType.DoubleAssert.ToleranceType toleranceType;
                double d = xMLObject.getDoubleAttribute(BeastUnitTest.TOLERANCE_STRING);
                String string5 = xMLObject.getAttribute(BeastUnitTest.TOLERANCE_TYPE, BeastUnitTest.ABSOLUTE);
                if (string5.equalsIgnoreCase(BeastUnitTest.ABSOLUTE)) {
                    toleranceType = AssertType.DoubleAssert.ToleranceType.ABSOLUTE;
                } else if (string5.equalsIgnoreCase(BeastUnitTest.RELATIVE)) {
                    toleranceType = AssertType.DoubleAssert.ToleranceType.RELATIVE;
                } else {
                    throw new XMLParseException("The optional attribute toleranceType must be either \"relative\" or \"absolute\"");
                }
                assertType = new AssertType.DoubleAssert(d, toleranceType, string4);
            } else {
                assertType = new AssertType.StringAssert();
            }
            BeastUnitTest beastUnitTest = new BeastUnitTest(string, string3, string2, assertType);
            beastUnitTest.execute();
            if (xMLObject.getAttribute(BeastUnitTest.VERBOSE, false).booleanValue()) {
                Logger.getLogger("dr.xml.unittest").info(beastUnitTest.getReport());
            }
            return beastUnitTest;
        }

        private String parseValue(XMLObject xMLObject) throws XMLParseException {
            Matcher matcher;
            String string;
            Object object;
            if (xMLObject.getChild(0) instanceof Reportable) {
                object = (Reportable)xMLObject.getChild(0);
                string = object.getReport();
            } else {
                string = xMLObject.getStringChild(0);
            }
            if (xMLObject.hasAttribute(BeastUnitTest.REGEX) && (matcher = ((Pattern)(object = Pattern.compile(xMLObject.getStringAttribute(BeastUnitTest.REGEX)))).matcher(string)).find()) {
                string = matcher.group(1);
            }
            return string;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return BeastUnitTest.class;
        }

        @Override
        public String getParserName() {
            return BeastUnitTest.CHECK;
        }
    };
    private static final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("expected", new XMLSyntaxRule[]{new XORRule(new ElementRule(Reportable.class), new ElementRule(String.class)), AttributeRule.newStringRule("regex", true)}), new ElementRule("actual", new XMLSyntaxRule[]{new XORRule(new ElementRule(Reportable.class), new ElementRule(String.class)), AttributeRule.newStringRule("regex", true)}), new ElementRule("message", new XMLSyntaxRule[]{new ElementRule(String.class)}, true), AttributeRule.newDoubleRule("tolerance", true), AttributeRule.newBooleanRule("verbose", true), AttributeRule.newStringRule("toleranceType", true)};

    public BeastUnitTest(String string, String string2, String string3, AssertType assertType) {
        this.message = string;
        this.actual = string2;
        this.expected = string3;
        this.assertType = assertType;
    }

    public void execute() {
        if (!this.assertType.equivalent(this.actual, this.expected)) {
            this.failCheck();
        }
        this.pass = true;
    }

    private void failCheck() {
        String string = this.formatName() + ": '" + this.actual + "' != '" + this.expected + "'";
        System.err.println(string);
        System.exit(-1);
    }

    private String formatName() {
        return "assert" + (this.message != null ? " " + this.message : "");
    }

    private String getPass() {
        return this.pass != null ? (this.pass.booleanValue() ? "passed" : "fail") : "not executed";
    }

    @Override
    public String getReport() {
        return this.formatName() + ": " + this.getPass();
    }

    static interface AssertType {
        public boolean equivalent(String var1, String var2);

        public static class DoubleAssert
        implements AssertType {
            private final double tolerance;
            private final String stripChars;
            private final ToleranceType toleranceType;

            DoubleAssert(double d, ToleranceType toleranceType, String string) {
                this.tolerance = d;
                this.stripChars = string;
                this.toleranceType = toleranceType;
            }

            @Override
            public boolean equivalent(String string, String string2) {
                double[] dArray;
                double[] dArray2 = this.parseArray(string);
                if (dArray2.length != (dArray = this.parseArray(string2)).length) {
                    System.err.println("The dimensions of the \"actual\" and \"expected\" values are not the same.");
                    return false;
                }
                for (int i = 0; i < dArray2.length; ++i) {
                    if (this.toleranceType.close(dArray2[i], dArray[i], this.tolerance)) continue;
                    System.err.println("Dimension " + (i + 1) + " of \"actual\" does not match \" expected\". (" + dArray2[i] + " != " + dArray[i] + ")");
                    return false;
                }
                return true;
            }

            private double[] parseArray(String string) {
                string = string.replaceAll(",", " ");
                string = string.replaceAll("[" + this.stripChars + "]", " ");
                string = string.trim();
                String[] stringArray = string.split("\\s+");
                double[] dArray = new double[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    dArray[i] = Double.valueOf(stringArray[i]);
                }
                return dArray;
            }

            static enum ToleranceType {
                RELATIVE{

                    @Override
                    boolean close(double d, double d2, double d3) {
                        double d4 = Math.abs(d3 * d2);
                        return ABSOLUTE.close(d, d2, d4);
                    }
                }
                ,
                ABSOLUTE{

                    @Override
                    boolean close(double d, double d2, double d3) {
                        return Math.abs(d - d2) < d3;
                    }
                };


                abstract boolean close(double var1, double var3, double var5);
            }
        }

        public static class StringAssert
        implements AssertType {
            @Override
            public boolean equivalent(String string, String string2) {
                return string.compareTo(string2) == 0;
            }
        }
    }
}

