/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.List;
import jebl.evolution.sequences.AminoAcidState;
import jebl.evolution.sequences.AminoAcids;
import jebl.evolution.sequences.CodonState;
import jebl.evolution.sequences.Codons;
import jebl.evolution.sequences.NucleotideState;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SequenceType {
    public static final SequenceType NUCLEOTIDE = new SequenceType(){

        @Override
        public int getStateCount() {
            return Nucleotides.getStateCount();
        }

        public List<State> getStates() {
            return Nucleotides.getStates();
        }

        @Override
        public int getCanonicalStateCount() {
            return Nucleotides.getCanonicalStateCount();
        }

        public List<NucleotideState> getCanonicalStates() {
            return Nucleotides.getCanonicalStates();
        }

        @Override
        public State getState(String code) {
            return Nucleotides.getState(code);
        }

        @Override
        public State getState(char code) {
            return Nucleotides.getState(code);
        }

        @Override
        public int getCodeLength() {
            return 1;
        }

        @Override
        public State getState(int index) {
            return Nucleotides.getState(index);
        }

        @Override
        public State getUnknownState() {
            return Nucleotides.getUnknownState();
        }

        @Override
        public State getGapState() {
            return Nucleotides.getGapState();
        }

        @Override
        public boolean isUnknown(State state) {
            return Nucleotides.isUnknown((NucleotideState)state);
        }

        @Override
        public boolean isGap(State state) {
            return Nucleotides.isGap((NucleotideState)state);
        }

        @Override
        public String getName() {
            return "nucleotide";
        }

        @Override
        public String getNexusDataType() {
            return "dna";
        }

        @Override
        public State[] toStateArray(String sequenceString) {
            return Nucleotides.toStateArray(sequenceString);
        }

        @Override
        public State[] toStateArray(byte[] indexArray) {
            return Nucleotides.toStateArray(indexArray);
        }

        public String toString() {
            return this.getName();
        }
    };
    public static final SequenceType AMINO_ACID = new SequenceType(){

        @Override
        public int getStateCount() {
            return AminoAcids.getStateCount();
        }

        public List<AminoAcidState> getStates() {
            return AminoAcids.getStates();
        }

        @Override
        public int getCanonicalStateCount() {
            return AminoAcids.getCanonicalStateCount();
        }

        public List<State> getCanonicalStates() {
            return AminoAcids.getCanonicalStates();
        }

        @Override
        public State getState(String code) {
            return AminoAcids.getState(code);
        }

        @Override
        public State getState(char code) {
            return AminoAcids.getState(code);
        }

        @Override
        public int getCodeLength() {
            return 1;
        }

        @Override
        public State getState(int index) {
            return AminoAcids.getState(index);
        }

        @Override
        public State getUnknownState() {
            return AminoAcids.getUnknownState();
        }

        @Override
        public State getGapState() {
            return AminoAcids.getGapState();
        }

        @Override
        public boolean isUnknown(State state) {
            return AminoAcids.isUnknown((AminoAcidState)state);
        }

        @Override
        public boolean isGap(State state) {
            return AminoAcids.isGap((AminoAcidState)state);
        }

        @Override
        public String getName() {
            return "amino acid";
        }

        @Override
        public String getNexusDataType() {
            return "protein";
        }

        @Override
        public State[] toStateArray(String sequenceString) {
            return AminoAcids.toStateArray(sequenceString);
        }

        @Override
        public State[] toStateArray(byte[] indexArray) {
            return AminoAcids.toStateArray(indexArray);
        }

        public String toString() {
            return this.getName();
        }
    };
    public static final SequenceType CODON = new SequenceType(){

        @Override
        public int getStateCount() {
            return Codons.getStateCount();
        }

        public List<State> getStates() {
            return Codons.getStates();
        }

        @Override
        public int getCanonicalStateCount() {
            return Codons.getCanonicalStateCount();
        }

        public List<State> getCanonicalStates() {
            return Codons.getCanonicalStates();
        }

        @Override
        public State getState(String code) {
            return Codons.getState(code);
        }

        @Override
        public State getState(char code) {
            return null;
        }

        @Override
        public int getCodeLength() {
            return 3;
        }

        @Override
        public State getState(int index) {
            return Codons.getState(index);
        }

        @Override
        public State getUnknownState() {
            return Codons.getUnknownState();
        }

        @Override
        public State getGapState() {
            return Codons.getGapState();
        }

        @Override
        public boolean isUnknown(State state) {
            return Codons.isUnknown((CodonState)state);
        }

        @Override
        public boolean isGap(State state) {
            return Codons.isGap((CodonState)state);
        }

        @Override
        public String getName() {
            return "codon";
        }

        @Override
        public String getNexusDataType() {
            return "dna";
        }

        @Override
        public State[] toStateArray(String sequenceString) {
            return Codons.toStateArray(sequenceString);
        }

        @Override
        public State[] toStateArray(byte[] indexArray) {
            return Codons.toStateArray(indexArray);
        }

        public String toString() {
            return this.getName();
        }
    };

    public int getStateCount();

    public List<? extends State> getStates();

    public int getCanonicalStateCount();

    public List<? extends State> getCanonicalStates();

    public State getState(String var1);

    public State getState(char var1);

    public int getCodeLength();

    public State getState(int var1);

    public State getUnknownState();

    public State getGapState();

    public boolean isUnknown(State var1);

    public boolean isGap(State var1);

    public String getName();

    public String getNexusDataType();

    public State[] toStateArray(String var1);

    public State[] toStateArray(byte[] var1);

    public static class Utils {
        private Utils() {
        }

        public static String getAlphabet(SequenceType sequenceType) {
            StringBuilder buffer = new StringBuilder();
            for (State state : sequenceType.getCanonicalStates()) {
                buffer.append(state.getCode());
            }
            return buffer.toString();
        }
    }
}

