/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.List;

public interface DataModel {
    public Likelihood getLikelihood();

    public Parameter getCompoundParameter();

    public List<Parameter> getIndividualParameters();

    public static abstract class Base
    implements DataModel {
        private final List<Parameter> thetaList = new ArrayList<Parameter>();
        private EmpiricalDistributionLikelihood likelihood = null;
        private Parameter theta = null;
        private List<EmpiricalDistributionData> dataList = new ArrayList<EmpiricalDistributionData>();

        public void addLikelihoodParameters(double[] x, double[] ll) {
            this.dataList.add(new EmpiricalDistributionData(x, ll, true));
            this.thetaList.add((Parameter)new Parameter.Default("theta" + (this.thetaList.size() + 1), 0.1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        }

        public void finish() {
            this.likelihood = this.makeFunctionalForm(this.dataList);
            this.theta = new CompoundParameter("theta", this.thetaList.toArray(new Parameter[0]));
            this.likelihood.addData((Attribute)this.theta);
        }

        abstract EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> var1);

        @Override
        public Likelihood getLikelihood() {
            return this.likelihood;
        }

        @Override
        public Parameter getCompoundParameter() {
            return this.theta;
        }

        @Override
        public List<Parameter> getIndividualParameters() {
            return this.thetaList;
        }
    }
}

