/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.debug;

import java.io.PrintWriter;
import org.openfast.ByteUtil;
import org.openfast.FieldValue;
import org.openfast.debug.Trace;
import org.openfast.template.Field;
import org.openfast.template.Group;

public class BasicDecodeTrace
implements Trace {
    private String indent = "";
    private PrintWriter out = new PrintWriter(System.out);

    public void groupStart(Group group) {
        this.print(group);
        this.moveDown();
    }

    private void moveDown() {
        this.indent = String.valueOf(this.indent) + "  ";
    }

    private void moveUp() {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    private void print(Object object) {
        this.out.print(this.indent);
        this.out.println(object);
        this.out.flush();
    }

    public void groupEnd() {
        this.moveUp();
    }

    public void field(Field field, FieldValue value, FieldValue decodedValue, byte[] encoding, int pmapIndex) {
        StringBuilder scalarDecode = new StringBuilder();
        scalarDecode.append(field.getName()).append(": ");
        scalarDecode.append(ByteUtil.convertByteArrayToHexString(encoding));
        scalarDecode.append(" -> ").append(value).append('(').append(decodedValue).append(')');
        this.print(scalarDecode);
    }

    public void pmap(byte[] bytes) {
        this.print("PMAP: " + ByteUtil.convertByteArrayToHexString(bytes));
    }

    public void setWriter(PrintWriter traceWriter) {
        this.out = traceWriter;
    }
}

