/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.error;

import java.util.HashMap;
import java.util.Map;
import org.openfast.Message;
import org.openfast.error.ErrorType;
import org.openfast.error.FastAlertSeverity;
import org.openfast.error.FastException;

public class ErrorCode {
    private static final Map ALERT_CODES = new HashMap();
    private final int code;
    private final String shortName;
    private final String description;
    private final FastAlertSeverity severity;
    private final ErrorType type;

    public ErrorCode(ErrorType type, int code, String shortName, String description, FastAlertSeverity severity) {
        ALERT_CODES.put(new Integer(code), this);
        this.type = type;
        this.code = code;
        this.shortName = shortName;
        this.description = description;
        this.severity = severity;
    }

    public void throwException(String message) {
        throw new FastException(message, this);
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortName() {
        return this.shortName;
    }

    public FastAlertSeverity getSeverity() {
        return this.severity;
    }

    public static ErrorCode getAlertCode(Message alertMsg) {
        return (ErrorCode)ALERT_CODES.get(new Integer(alertMsg.getInt(2)));
    }

    public ErrorType getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.shortName) + ": " + this.description;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ErrorCode)) {
            return false;
        }
        ErrorCode other = (ErrorCode)obj;
        return other.code == this.code && other.getType().equals(this.getType());
    }
}

