/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.interpret;

import java.io.OutputStream;
import java.io.PrintStream;
import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.Message;
import org.openfast.SequenceValue;
import org.openfast.examples.util.FastMessageConsumer;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Sequence;

public class FastMessageInterpreter
implements FastMessageConsumer {
    private final PrintStream outputStream;
    private final String tab = "  ";
    private String indent = "";
    private long recordCount = 0L;

    public FastMessageInterpreter(OutputStream outputStream) {
        this.outputStream = new PrintStream(outputStream);
    }

    public void accept(Message message) {
        ++this.recordCount;
        StringBuffer line = new StringBuffer(String.valueOf(this.indent) + "Record#" + this.recordCount + " ");
        this.formatMessage(message, line);
        this.outputStream.println(line);
    }

    public void annotate(String message) {
        this.outputStream.println(message);
    }

    private void formatMessage(Message message, StringBuffer line) {
        MessageTemplate template = message.getTemplate();
        line.append("Message template: ").append(template.getName()).append("->");
        boolean needNewLine = false;
        int count = message.getFieldCount();
        int i = 0;
        while (i < count) {
            if (message.isDefined(i)) {
                Field field = template.getField(i);
                if (field instanceof Sequence) {
                    this.formatSequence(field, message.getSequence(i), line);
                    needNewLine = true;
                } else {
                    String fieldName = field.getName();
                    String fieldId = field.getId();
                    String fieldValue = message.getValue(i).toString();
                    if (needNewLine) {
                        line.append("\n").append(this.indent);
                        needNewLine = false;
                    }
                    line.append(fieldName).append('{').append(fieldId).append("}=").append(fieldValue);
                }
            }
            ++i;
        }
    }

    private void formatSequence(Field sequenceField, SequenceValue sequenceValue, StringBuffer line) {
        Sequence sequence = sequenceValue.getSequence();
        Group group = sequence.getGroup();
        int fieldCount = group.getFieldCount();
        String sequenceName = sequence.getName();
        GroupValue[] entries = sequenceValue.getValues();
        String oldIndent = this.indent;
        this.indent = String.valueOf(this.indent) + "  ";
        line.append("\n").append(this.indent).append(sequenceName).append('{').append(sequenceField.getId()).append("} Sequence[").append(entries.length).append("]:");
        this.indent = String.valueOf(this.indent) + "  ";
        boolean needNewLine = false;
        int i = 0;
        while (i < entries.length) {
            GroupValue entry = entries[i];
            line.append("\n").append(this.indent);
            int nField = 0;
            while (nField < fieldCount) {
                if (entry.isDefined(nField)) {
                    Field field = sequence.getField(nField);
                    if (field instanceof Sequence) {
                        this.formatSequence(field, entry.getSequence(nField), line);
                        needNewLine = true;
                    } else {
                        if (needNewLine) {
                            line.append("\n").append(this.indent);
                        }
                        String fieldName = field.getName();
                        String fieldId = field.getId();
                        FieldValue fieldValue = entry.getValue(nField);
                        line.append(fieldName).append('{').append(fieldId).append("}=").append(fieldValue.toString()).append("|");
                    }
                }
                ++nField;
            }
            ++i;
        }
        this.indent = oldIndent;
    }
}

