/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openfast.QName;
import org.openfast.template.AbstractTemplateRegistry;
import org.openfast.template.MessageTemplate;
import org.openfast.template.TemplateRegistry;
import org.openfast.util.IntegerMap;
import org.openfast.util.SimpleIntegerMap;

public class BasicTemplateRegistry
extends AbstractTemplateRegistry {
    private final Map nameMap = new HashMap();
    private final IntegerMap idMap = new SimpleIntegerMap();
    private final Map templateMap = new HashMap();
    private final List templates = new ArrayList();

    public void register(int id, MessageTemplate template) {
        this.define(template);
        Integer tid = new Integer(id);
        this.idMap.put(id, template);
        this.templateMap.put(template, tid);
        this.notifyTemplateRegistered(template, id);
    }

    public void register(int id, QName name) {
        if (!this.nameMap.containsKey(name)) {
            throw new IllegalArgumentException("The template named " + name + " is not defined.");
        }
        Integer tid = new Integer(id);
        MessageTemplate template = (MessageTemplate)this.nameMap.get(name);
        this.templateMap.put(template, tid);
        this.idMap.put(id, template);
        this.notifyTemplateRegistered(template, id);
    }

    public void define(MessageTemplate template) {
        if (!this.templates.contains(template)) {
            this.nameMap.put(template.getQName(), template);
            this.templates.add(template);
        }
    }

    public int getId(QName name) {
        Object template = this.nameMap.get(name);
        if (template == null || !this.templateMap.containsKey(template)) {
            return -1;
        }
        return (Integer)this.templateMap.get(template);
    }

    public MessageTemplate get(int templateId) {
        return (MessageTemplate)this.idMap.get(templateId);
    }

    public MessageTemplate get(QName name) {
        return (MessageTemplate)this.nameMap.get(name);
    }

    public int getId(MessageTemplate template) {
        if (!this.isRegistered(template)) {
            return -1;
        }
        return (Integer)this.templateMap.get(template);
    }

    public boolean isRegistered(QName name) {
        return this.nameMap.containsKey(name);
    }

    public boolean isRegistered(int templateId) {
        return this.idMap.containsKey(templateId);
    }

    public boolean isRegistered(MessageTemplate template) {
        return this.templateMap.containsKey(template);
    }

    public boolean isDefined(QName name) {
        return this.nameMap.containsKey(name);
    }

    public MessageTemplate[] getTemplates() {
        return this.templates.toArray(new MessageTemplate[this.templates.size()]);
    }

    public void remove(QName name) {
        MessageTemplate template = (MessageTemplate)this.nameMap.remove(name);
        Object id = this.templateMap.remove(template);
        this.idMap.remove((Integer)id);
        this.templates.remove(template);
    }

    public void remove(MessageTemplate template) {
        Object id = this.templateMap.remove(template);
        this.nameMap.remove(template.getName());
        this.idMap.remove((Integer)id);
    }

    public void remove(int id) {
        MessageTemplate template = (MessageTemplate)this.idMap.remove(id);
        this.templateMap.remove(template);
        this.nameMap.remove(template.getName());
    }

    public void registerAll(TemplateRegistry registry) {
        if (registry == null) {
            return;
        }
        MessageTemplate[] templates = registry.getTemplates();
        if (templates == null) {
            return;
        }
        int i = 0;
        while (i < templates.length) {
            this.register(registry.getId(templates[i]), templates[i]);
            ++i;
        }
    }

    public Iterator nameIterator() {
        return this.nameMap.keySet().iterator();
    }

    public Iterator iterator() {
        return this.templates.iterator();
    }
}

