/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template;

import java.io.InputStream;
import org.openfast.BitVectorBuilder;
import org.openfast.BitVectorReader;
import org.openfast.Context;
import org.openfast.FieldValue;
import org.openfast.Global;
import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.error.FastException;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.operator.Operator;
import org.openfast.template.operator.OperatorCodec;
import org.openfast.template.type.Type;
import org.openfast.template.type.codec.TypeCodec;
import org.openfast.util.RecordingInputStream;

public class Scalar
extends Field {
    private static final long serialVersionUID = 1L;
    private final Operator operator;
    private final OperatorCodec operatorCodec;
    private final Type type;
    private final TypeCodec typeCodec;
    private String dictionary;
    private ScalarValue defaultValue = ScalarValue.UNDEFINED;
    private final ScalarValue initialValue;

    public Scalar(String name, Type type, Operator operator, ScalarValue defaultValue, boolean optional) {
        this(new QName(name), type, operator, defaultValue, optional);
    }

    public Scalar(QName name, Type type, Operator operator, ScalarValue defaultValue, boolean optional) {
        super(name, optional);
        this.operator = operator;
        this.operatorCodec = operator.getCodec(type);
        this.dictionary = "global";
        this.defaultValue = defaultValue == null ? ScalarValue.UNDEFINED : defaultValue;
        this.type = type;
        this.typeCodec = type.getCodec(operator, optional);
        this.initialValue = defaultValue == null || defaultValue.isUndefined() ? this.type.getDefaultValue() : defaultValue;
        operator.validate(this);
    }

    public Scalar(QName name, Type type, OperatorCodec operatorCodec, ScalarValue defaultValue, boolean optional) {
        super(name, optional);
        this.operator = operatorCodec.getOperator();
        this.operatorCodec = operatorCodec;
        this.dictionary = "global";
        this.defaultValue = defaultValue == null ? ScalarValue.UNDEFINED : defaultValue;
        this.type = type;
        this.typeCodec = type.getCodec(this.operator, optional);
        this.initialValue = defaultValue == null || defaultValue.isUndefined() ? this.type.getDefaultValue() : defaultValue;
        this.operator.validate(this);
    }

    public Type getType() {
        return this.type;
    }

    public OperatorCodec getOperatorCodec() {
        return this.operatorCodec;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public byte[] encode(FieldValue fieldValue, Group template, Context context, BitVectorBuilder presenceMapBuilder) {
        ScalarValue priorValue = context.lookup(this.getDictionary(), template, this.getKey());
        ScalarValue value = (ScalarValue)fieldValue;
        if (!this.operatorCodec.canEncode(value, this)) {
            Global.handleError(FastConstants.D3_CANT_ENCODE_VALUE, "The scalar " + this + " cannot encode the value " + value);
        }
        ScalarValue valueToEncode = this.operatorCodec.getValueToEncode(value, priorValue, this, presenceMapBuilder);
        if (this.operator.shouldStoreValue(value)) {
            context.store(this.getDictionary(), template, this.getKey(), value);
        }
        if (valueToEncode == null) {
            return new byte[0];
        }
        byte[] encoding = this.typeCodec.encode(valueToEncode);
        if (context.isTraceEnabled() && encoding.length > 0) {
            context.getEncodeTrace().field(this, fieldValue, valueToEncode, encoding, presenceMapBuilder.getIndex());
        }
        return encoding;
    }

    public String getDictionary() {
        return this.dictionary;
    }

    public ScalarValue decodeValue(ScalarValue newValue, ScalarValue previousValue) {
        return this.operatorCodec.decodeValue(newValue, previousValue, this);
    }

    public ScalarValue getDefaultValue() {
        return this.defaultValue;
    }

    public ScalarValue decode(ScalarValue previousValue) {
        return this.operatorCodec.decodeEmptyValue(previousValue, this);
    }

    public boolean usesPresenceMapBit() {
        return this.operatorCodec.usesPresenceMapBit(this.optional);
    }

    public boolean isPresenceMapBitSet(byte[] encoding, FieldValue fieldValue) {
        return this.operatorCodec.isPresenceMapBitSet(encoding, fieldValue);
    }

    public FieldValue decode(InputStream in, Group template, Context context, BitVectorReader presenceMapReader) {
        try {
            ScalarValue value;
            ScalarValue previousValue = null;
            if (this.operator.usesDictionary()) {
                previousValue = context.lookup(this.getDictionary(), template, this.getKey());
                this.validateDictionaryTypeAgainstFieldType(previousValue, this.type);
            }
            int pmapIndex = presenceMapReader.getIndex();
            if (this.isPresent(presenceMapReader)) {
                if (context.isTraceEnabled()) {
                    in = new RecordingInputStream(in);
                }
                if (!this.operatorCodec.shouldDecodeType()) {
                    return this.operatorCodec.decodeValue(null, null, this);
                }
                ScalarValue decodedValue = this.typeCodec.decode(in);
                value = this.decodeValue(decodedValue, previousValue);
                if (context.isTraceEnabled()) {
                    context.getDecodeTrace().field(this, value, decodedValue, ((RecordingInputStream)in).getBuffer(), pmapIndex);
                }
            } else {
                value = this.decode(previousValue);
            }
            this.validateDecodedValueIsCorrectForType(value, this.type);
            if (this.getOperator() != Operator.DELTA || value != null) {
                context.store(this.getDictionary(), template, this.getKey(), value);
            }
            return value;
        }
        catch (FastException e) {
            throw new FastException("Error occurred while decoding " + this, e.getCode(), e);
        }
    }

    private void validateDecodedValueIsCorrectForType(ScalarValue value, Type type) {
        if (value == null) {
            return;
        }
        type.validateValue(value);
    }

    private void validateDictionaryTypeAgainstFieldType(ScalarValue previousValue, Type type) {
        if (previousValue == null || previousValue.isUndefined()) {
            return;
        }
        if (!type.isValueOf(previousValue)) {
            Global.handleError(FastConstants.D4_INVALID_TYPE, "The value \"" + previousValue + "\" is not valid for the type " + type);
        }
    }

    public void setDictionary(String dictionary) {
        if (dictionary == null) {
            throw new NullPointerException();
        }
        this.dictionary = dictionary;
    }

    public String toString() {
        return "Scalar [name=" + this.name.getName() + ", operator=" + this.operator + ", type=" + this.type + ", dictionary=" + this.dictionary + "]";
    }

    public Class getValueType() {
        return ScalarValue.class;
    }

    public FieldValue createValue(String value) {
        return this.type.getValue(value);
    }

    public String getTypeName() {
        return "scalar";
    }

    public ScalarValue getBaseValue() {
        return this.initialValue;
    }

    public TypeCodec getTypeCodec() {
        return this.typeCodec;
    }

    public String serialize(ScalarValue value) {
        return this.type.serialize(value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof Scalar)) {
            return false;
        }
        return this.equals((Scalar)other);
    }

    private boolean equals(Scalar other) {
        boolean equals = this.equals(this.name, other.name);
        equals = equals && this.equals(this.type, other.type);
        equals = equals && this.equals(this.typeCodec, other.typeCodec);
        equals = equals && this.equals(this.operator, other.operator);
        equals = equals && this.equals(this.operatorCodec, other.operatorCodec);
        equals = equals && this.equals(this.initialValue, other.initialValue);
        equals = equals && this.equals(this.dictionary, other.dictionary);
        equals = equals && this.equals(this.id, other.id);
        return equals;
    }

    private boolean equals(Object o, Object o2) {
        if (o == null) {
            return o2 == null;
        }
        return o.equals(o2);
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode() + this.typeCodec.hashCode() + this.operator.hashCode() + this.operatorCodec.hashCode() + this.initialValue.hashCode() + this.dictionary.hashCode();
    }
}

