/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.serializer;

import org.openfast.template.Field;
import org.openfast.template.Scalar;
import org.openfast.template.operator.Operator;
import org.openfast.template.serializer.AbstractFieldSerializer;
import org.openfast.template.serializer.FieldSerializer;
import org.openfast.template.serializer.SerializingContext;
import org.openfast.template.type.StringType;
import org.openfast.util.XmlWriter;

public class ScalarSerializer
extends AbstractFieldSerializer
implements FieldSerializer {
    public boolean canSerialize(Field field) {
        return field instanceof Scalar;
    }

    public void serialize(XmlWriter writer, Field field, SerializingContext context) {
        Scalar scalar = this.writeStart(writer, field, context);
        this.writeEnd(writer, context, scalar);
    }

    protected void writeEnd(XmlWriter writer, SerializingContext context, Scalar scalar) {
        if (!Operator.NONE.equals((Object)scalar.getOperator())) {
            ScalarSerializer.writeOperator(writer, scalar, context);
        }
        writer.end();
    }

    protected Scalar writeStart(XmlWriter writer, Field field, SerializingContext context) {
        Scalar scalar = (Scalar)field;
        String nodeName = this.getNodeName(scalar);
        writer.start(nodeName);
        ScalarSerializer.writeCommonAttributes(writer, field, context);
        return scalar;
    }

    private String getNodeName(Scalar scalar) {
        String nodeName = scalar.getType().getName();
        if (scalar.getType() instanceof StringType) {
            nodeName = "string";
        }
        return nodeName;
    }
}

