/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import com.portfolioeffect.quant.client.api.Metric;
import com.portfolioeffect.quant.client.result.LazyMetric;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;

public class MetricCallable
implements Callable<String> {
    private final LazyMetric metric;
    private final Runnable callBack;
    private final boolean isMultiplexConnection;
    private volatile LinkedBlockingDeque<MetricCallable> chanel;

    public MetricCallable(Metric m, boolean isMultiplexConnection, LinkedBlockingDeque<MetricCallable> chanel) {
        this.metric = m.getMetric();
        this.callBack = null;
        this.isMultiplexConnection = isMultiplexConnection;
        this.chanel = chanel;
    }

    public MetricCallable(Metric m, Runnable callBack, boolean isMultiplexConnection, LinkedBlockingDeque<MetricCallable> chanel) {
        this.metric = m.getMetric();
        this.callBack = callBack;
        this.isMultiplexConnection = isMultiplexConnection;
        this.chanel = chanel;
    }

    public MetricCallable(LazyMetric m, boolean isMultiplexConnection, LinkedBlockingDeque<MetricCallable> chanel) {
        this.metric = m;
        this.callBack = null;
        this.isMultiplexConnection = isMultiplexConnection;
        this.chanel = chanel;
    }

    public MetricCallable(LazyMetric m, Runnable callBack, boolean isMultiplexConnection, LinkedBlockingDeque<MetricCallable> chanel) {
        this.metric = m;
        this.callBack = callBack;
        this.isMultiplexConnection = isMultiplexConnection;
        this.chanel = chanel;
    }

    @Override
    public String call() throws Exception {
        try {
            this.metric.setMultiplexConnection(this.isMultiplexConnection);
            this.metric.computeAsync();
            this.chanel.offer(this);
            if (this.metric.isComputed() && this.callBack != null) {
                this.callBack.run();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public LazyMetric getMetric() {
        return this.metric;
    }
}

