/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.Utilities;
import ec.tstoolkit.timeseries.simplets.ITsDataTransformation;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class LengthOfPeriodTransformation
implements ITsDataTransformation {
    private boolean m_back;
    public final LengthOfPeriodType type;

    public LengthOfPeriodTransformation(LengthOfPeriodType ltype) {
        this.type = ltype;
    }

    @Override
    public ITsDataTransformation converse() {
        LengthOfPeriodTransformation transform = new LengthOfPeriodTransformation(this.type);
        transform.m_back = !this.m_back;
        return transform;
    }

    @Override
    public boolean transform(TsData data, ITsDataTransformation.LogJacobian ljacobian) {
        Utilities.transform(this.type, data, this.m_back);
        if (ljacobian != null) {
            TsDomain domain = data.getDomain().drop(ljacobian.start, data.getLength() - ljacobian.end);
            ljacobian.value += Utilities.logJacobian(this.type, domain, this.m_back);
        }
        return true;
    }
}

