/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsDataTable;
import ec.tstoolkit.timeseries.simplets.TsDataTableInfo;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class TsMatrix
implements Cloneable {
    private TsPeriod start_;
    private Matrix matrix_;

    public TsMatrix(TsPeriod start, int nperiods, int ncolumns) {
        this.start_ = start.clone();
        this.matrix_ = new Matrix(nperiods, ncolumns);
    }

    public TsMatrix(TsPeriod start, Matrix m, boolean clone) {
        this.start_ = start.clone();
        this.matrix_ = clone ? m.clone() : m;
    }

    public TsMatrix(TsData ... s) {
        TsDataTable tmp = new TsDataTable();
        for (int i = 0; i < s.length; ++i) {
            tmp.insert(-1, s[i]);
        }
        TsDomain domain = tmp.getDomain();
        this.start_ = domain.getStart();
        this.matrix_ = new Matrix(domain.getLength(), s.length);
        this.matrix_.set(Double.NaN);
        for (int i = 0; i < domain.getLength(); ++i) {
            for (int j = 0; j < s.length; ++j) {
                TsDataTableInfo dataInfo = tmp.getDataInfo(i, j);
                if (dataInfo != TsDataTableInfo.Valid) continue;
                this.matrix_.set(i, j, tmp.getData(i, j));
            }
        }
    }

    public TsDomain getDomain() {
        return new TsDomain(this.start_, this.matrix_.getRowsCount());
    }

    public Matrix getMatrix() {
        return this.matrix_;
    }

    public int getColumnsCount() {
        return this.matrix_.getColumnsCount();
    }

    public TsData series(int pos) {
        return new TsData(this.start_, this.matrix_.column(pos)).cleanExtremities();
    }

    public DataBlock data(int pos) {
        return this.matrix_.row(pos);
    }

    public static DataBlock shrink(DataBlock data) {
        int beg;
        double[] x = data.getData();
        int end = data.getEndPosition();
        int inc = data.getIncrement();
        for (beg = data.getStartPosition(); beg != end && !Double.isFinite(x[beg]); beg += inc) {
        }
        if (beg == end) {
            return new DataBlock(0);
        }
        while (beg != end && !Double.isFinite(x[end - inc])) {
            end -= inc;
        }
        return new DataBlock(x, beg, end, inc);
    }

    public DataBlock data(TsPeriod pos) {
        int row = pos.minus(this.start_);
        if (row < 0 || row >= this.matrix_.getRowsCount()) {
            return null;
        }
        return this.matrix_.row(row);
    }

    public DataBlock data(Day pos) {
        int row = this.getDomain().search(pos);
        if (row < 0 || row >= this.matrix_.getRowsCount()) {
            return null;
        }
        return this.matrix_.row(row);
    }

    public TsDataBlock series(TsPeriodSelector selector, int col) {
        TsDomain domain = this.getDomain();
        TsDomain sdomain = domain.select(selector);
        if (sdomain.isEmpty()) {
            return null;
        }
        int nbeg = sdomain.getStart().minus(this.start_);
        int nend = domain.getLength() - sdomain.getLength() - nbeg;
        return new TsDataBlock(sdomain.getStart(), this.matrix_.column(col).drop(nbeg, nend));
    }

    public TsMatrix expand(int nperiods, int ncolumns) {
        Matrix m = new Matrix(this.matrix_.getRowsCount() + nperiods, this.matrix_.getColumnsCount() + ncolumns);
        m.set(Double.NaN);
        m.subMatrix(0, this.matrix_.getRowsCount(), 0, this.matrix_.getColumnsCount()).copy(this.matrix_.all());
        return new TsMatrix(this.start_, m, false);
    }

    public TsMatrix select(TsPeriodSelector selector) {
        TsDomain domain = this.getDomain();
        TsDomain sdomain = domain.select(selector);
        if (sdomain.isEmpty()) {
            return null;
        }
        Matrix m = new Matrix(sdomain.getLength(), this.matrix_.getColumnsCount());
        int r0 = sdomain.getStart().minus(this.start_);
        m.all().copy(this.matrix_.subMatrix(r0, r0 + this.matrix_.getRowsCount(), 0, this.matrix_.getColumnsCount()));
        return new TsMatrix(this.start_, m, false);
    }

    public TsMatrix clone() {
        try {
            TsMatrix m = (TsMatrix)super.clone();
            m.matrix_ = this.matrix_.clone();
            return m;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }
}

