/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima.estimation;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.FastArimaForecasts;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.AbstractLinearSystemSolver;
import ec.tstoolkit.maths.matrices.CroutDoolittle;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;
import java.util.Arrays;

public class BurmanEstimatesC {
    private double[] m_data;
    private int m_nf;
    private WienerKolmogorovEstimators m_wk;
    private Polynomial m_ar;
    private Polynomial m_ma;
    private AbstractLinearSystemSolver m_solver;
    private Polynomial[] m_g;
    private double m_ser = 1.0;
    private double m_mean;
    private int m_nparams;
    private double[][] m_e;
    private double[][] m_f;
    private double[] m_xb;
    private double[] m_xf;
    private boolean m_bmean;

    private void calc(int cmp) {
        int i;
        int j;
        double s;
        int i2;
        int i3;
        if (this.m_e[cmp] != null || this.m_data == null) {
            return;
        }
        this.extendSeries();
        int n = this.m_data.length;
        if (cmp == 0 && this.isTrendConstant()) {
            double[] e = new double[n];
            double m = this.correctedMean();
            Arrays.fill(e, m);
            this.m_e[cmp] = e;
            double[] f = new double[this.m_nf];
            Arrays.fill(f, m);
            this.m_f[cmp] = f;
            return;
        }
        if (this.m_g[cmp] == null) {
            return;
        }
        int nf = this.m_xf.length;
        double[] ma = this.m_ma.getCoefficients();
        double[] ar = this.m_ar.getCoefficients();
        int qstar = ma.length - 1;
        int pstar = ar.length - 1;
        if (this.useD1()) {
            ++qstar;
        }
        double[] z = new double[n + 2 * nf];
        for (int i4 = 0; i4 < n; ++i4) {
            z[i4 + nf] = this.m_data[i4];
        }
        int ntmp = nf + n;
        for (i3 = 0; i3 < nf; ++i3) {
            z[ntmp + i3] = this.m_xf[i3];
        }
        ntmp = nf - 1;
        for (i3 = 0; i3 < nf; ++i3) {
            z[ntmp - i3] = this.m_xb[i3];
        }
        if (this.useMean()) {
            double m = this.correctedMean();
            int i5 = 0;
            while (i5 < z.length) {
                int n2 = i5++;
                z[n2] = z[n2] - m;
            }
        }
        Polynomial g = this.m_g[cmp];
        int gstar = g.getDegree();
        double[] w1 = new double[n + qstar];
        for (int i6 = 0; i6 < n + qstar; ++i6) {
            double s2 = g.get(0) * z[nf + i6];
            for (int j2 = 1; j2 <= gstar; ++j2) {
                s2 += g.get(j2) * z[nf + i6 + j2];
            }
            w1[i6] = s2;
        }
        double[] w2 = new double[n + nf + qstar];
        for (int i7 = 0; i7 < n + nf + qstar; ++i7) {
            double s3 = g.get(0) * z[nf - qstar + i7];
            for (int j3 = 1; j3 <= gstar; ++j3) {
                s3 += g.get(j3) * z[nf - qstar + i7 - j3];
            }
            w2[i7] = s3;
        }
        double[] ww = new double[pstar + qstar];
        ntmp = n + qstar - pstar;
        for (int i8 = 0; i8 < pstar; ++i8) {
            ww[i8] = w1[ntmp + i8];
        }
        double[] mx = ww.length == 0 ? new double[]{} : this.m_solver.solve(ww);
        int nx1 = n + Math.max(2 * qstar, nf);
        double[] x1 = new double[nx1];
        for (i2 = 0; i2 < pstar + qstar; ++i2) {
            x1[ntmp + i2] = mx[i2];
        }
        for (i2 = ntmp - 1; i2 >= 0; --i2) {
            s = w1[i2];
            for (j = 1; j < ma.length; ++j) {
                s -= x1[i2 + j] * ma[j];
            }
            x1[i2] = s;
        }
        for (i2 = ntmp + pstar + qstar; i2 < nx1; ++i2) {
            s = 0.0;
            for (j = 1; j <= pstar; ++j) {
                s -= ar[j] * x1[i2 - j];
            }
            x1[i2] = s;
        }
        for (i2 = 0; i2 < pstar; ++i2) {
            ww[i2] = w2[pstar - i2 - 1];
        }
        mx = ww.length == 0 ? new double[]{} : this.m_solver.solve(ww);
        int nx2 = n + 2 * qstar + Math.max(nf, 2 * qstar);
        double[] x2 = new double[nx2];
        for (i = 0; i < pstar + qstar; ++i) {
            x2[pstar + qstar - 1 - i] = mx[i];
        }
        for (i = pstar + qstar; i < nx2; ++i) {
            double s4 = w2[i - qstar];
            for (int j4 = 1; j4 < ma.length; ++j4) {
                s4 -= x2[i - j4] * ma[j4];
            }
            x2[i] = s4;
        }
        double[] rslt = new double[n];
        for (int i9 = 0; i9 < n; ++i9) {
            rslt[i9] = x1[i9] + x2[i9 + 2 * qstar];
        }
        if (cmp == 0 && this.useMean()) {
            double m = this.correctedMean();
            int i10 = 0;
            while (i10 < rslt.length) {
                int n3 = i10++;
                rslt[n3] = rslt[n3] + m;
            }
        }
        this.m_e[cmp] = rslt;
        if (this.m_nf > 0) {
            double[] fcast = new double[this.m_nf];
            for (int i11 = 0; i11 < this.m_nf; ++i11) {
                fcast[i11] = x1[n + i11] + x2[n + i11 + 2 * qstar];
            }
            if (cmp == 0 && this.useMean()) {
                double m = this.correctedMean();
                int i12 = 0;
                while (i12 < fcast.length) {
                    int n4 = i12++;
                    fcast[n4] = fcast[n4] + m;
                }
            }
            this.m_f[cmp] = fcast;
        }
    }

    protected void clearForecasts() {
        this.m_xb = null;
        this.m_xf = null;
        if (this.m_f != null) {
            for (int i = 0; i < this.m_f.length; ++i) {
                this.m_f[i] = null;
            }
        }
    }

    private void clearResults() {
        this.m_ser = 1.0;
        this.m_mean = 0.0;
        if (this.m_e != null) {
            for (int i = 0; i < this.m_e.length; ++i) {
                this.m_e[i] = null;
            }
        }
    }

    public double[] estimates(int cmp, boolean signal) {
        this.calc(cmp);
        if (signal) {
            return this.m_e[cmp];
        }
        double[] e = new double[this.m_data.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = this.m_data[i] - this.m_e[cmp][i];
        }
        return e;
    }

    private void extendSeries() {
        if (this.m_xb != null) {
            return;
        }
        int nf = 0;
        for (int i = 0; i < this.m_g.length; ++i) {
            int nr = 0;
            if (this.m_g[i] != null) {
                nr = this.m_g[i].getDegree();
            }
            if (this.m_ma != null) {
                nr += this.m_ma.getDegree();
            }
            if (this.m_bmean) {
                nr += 2;
            }
            if (nr <= nf) continue;
            nf = nr;
        }
        if (this.m_nf > nf) {
            nf = this.m_nf;
        }
        if (this.m_bmean && nf <= this.m_ar.getDegree()) {
            nf = this.m_ar.getDegree() + 1;
        }
        FastArimaForecasts fcast = new FastArimaForecasts(this.m_wk.getUcarimaModel().getModel(), this.m_bmean);
        this.m_xf = fcast.forecasts(new DataBlock(this.m_data), nf);
        this.m_xb = fcast.forecasts(new DataBlock(this.m_data).reverse(), nf);
        this.m_mean = this.m_bmean ? fcast.getMean() : 0.0;
    }

    private IArimaModel model() {
        return this.m_wk.getUcarimaModel().getModel();
    }

    private double correctedMean() {
        IArimaModel arima = this.model();
        return this.m_mean / arima.getStationaryAR().getPolynomial().evaluateAt(1.0);
    }

    public double[] forecasts(int cmp, boolean signal) {
        this.calc(cmp);
        if (signal) {
            return this.m_f[cmp];
        }
        double[] f = new double[this.m_nf];
        for (int i = 0; i < f.length; ++i) {
            f[i] = this.m_xf[i] - this.m_f[cmp][i];
        }
        return f;
    }

    public double[] getData() {
        return this.m_data;
    }

    public WienerKolmogorovEstimators getEstimators() {
        return this.m_wk;
    }

    public int getForecastsCount() {
        return this.m_nf;
    }

    public int getHyperParametersCount() {
        return this.m_nparams;
    }

    public double getSer() {
        return this.m_ser;
    }

    public void setSer(double ser) {
        this.m_ser = ser;
    }

    public double[] getSeriesBackcasts() {
        this.extendSeries();
        return this.m_xb;
    }

    public double[] getSeriesForecasts() {
        this.extendSeries();
        return this.m_xf;
    }

    public UcarimaModel getUcarimaModel() {
        return this.m_wk.getUcarimaModel();
    }

    private void initModel() {
        UcarimaModel ucm = this.m_wk.getUcarimaModel();
        IArimaModel model = ucm.getModel();
        int ncmps = ucm.getComponentsCount();
        this.m_e = new double[ncmps][];
        this.m_f = new double[ncmps][];
        this.m_g = new Polynomial[ncmps];
        this.m_ma = model.getMA().getPolynomial();
        double v = model.getInnovationVariance();
        if (v != 1.0) {
            this.m_ma = this.m_ma.times(Math.sqrt(v));
        }
        this.m_ar = model.getAR().getPolynomial();
        for (int i = 0; i < ncmps; ++i) {
            ArimaModel cmp = ucm.getComponent(i);
            if (cmp.isNull()) continue;
            SymmetricFilter sma = cmp.sma();
            if (!sma.isNull()) {
                BackFilter scar;
                BackFilter umar = model.getNonStationaryAR();
                BackFilter ucar = cmp.getNonStationaryAR();
                BackFilter nar = umar.divide(ucar);
                BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(true);
                BackFilter smar = model.getStationaryAR();
                if (smp.simplify(smar, scar = cmp.getStationaryAR())) {
                    smar = (BackFilter)smp.getLeft();
                    scar = (BackFilter)smp.getRight();
                }
                BackFilter dar = scar;
                nar = nar.times(smar);
                BackFilter denom = new BackFilter(this.m_ma).times(dar);
                SymmetricFilter c = sma.times(SymmetricFilter.createFromFilter(nar));
                double mvar = model.getInnovationVariance();
                if (mvar != 1.0) {
                    c = c.times(1.0 / mvar);
                }
                BackFilter gf = c.decompose(denom);
                this.m_g[i] = gf.getPolynomial();
                continue;
            }
            this.m_g[i] = Polynomial.ZERO;
        }
        if (this.useD1()) {
            this.m_ar = this.m_ar.times(UnitRoots.D1);
        }
        this.initSolver();
    }

    private boolean useD1() {
        return this.m_bmean && this.model().getNonStationaryARCount() > 0;
    }

    private boolean useMean() {
        return this.m_bmean && this.model().getNonStationaryARCount() == 0;
    }

    private boolean isTrendConstant() {
        return this.m_wk.getUcarimaModel().getComponent(0).isNull();
    }

    private void initSolver() {
        int j;
        int i;
        Polynomial ma = this.m_ma;
        Polynomial ar = this.m_ar;
        int qstar = ma.getDegree();
        int pstar = ar.getDegree();
        if (this.useD1()) {
            ++qstar;
        }
        Matrix m = new Matrix(pstar + qstar, pstar + qstar);
        for (i = 0; i < pstar; ++i) {
            for (j = 0; j <= ma.getDegree(); ++j) {
                m.set(i, i + j, ma.get(j));
            }
        }
        for (i = 0; i < qstar; ++i) {
            for (j = 0; j <= pstar; ++j) {
                m.set(i + pstar, i + j, ar.get(pstar - j));
            }
        }
        this.m_solver = new CroutDoolittle();
        this.m_solver.decompose(m);
    }

    public boolean isMeanCorrection() {
        return this.m_bmean;
    }

    public void setData(IReadDataBlock data) {
        this.m_data = new double[data.getLength()];
        data.copyTo(this.m_data, 0);
        this.clearResults();
        this.clearForecasts();
    }

    public void setEstimators(WienerKolmogorovEstimators value) {
        this.m_wk = value;
        this.initModel();
        this.clearResults();
        this.clearForecasts();
    }

    public void setForecastsCount(int value) {
        this.m_nf = value;
        this.clearForecasts();
    }

    public void setHyperParametersCount(int value) {
        this.m_nparams = value;
    }

    public void setUcarimaModel(UcarimaModel value) {
        this.m_wk = new WienerKolmogorovEstimators(value);
        this.m_bmean = false;
        this.initModel();
        this.clearResults();
        this.clearForecasts();
    }

    public void setUcarimaModelWithMean(UcarimaModel value) {
        this.m_wk = new WienerKolmogorovEstimators(value);
        this.m_bmean = true;
        this.initModel();
        this.clearResults();
        this.clearForecasts();
    }

    public double[] stdevEstimates(int cmp) {
        this.calc(cmp);
        if (this.m_wk.getUcarimaModel().getComponent(cmp).isNull()) {
            return new double[this.m_data.length];
        }
        try {
            int n = (this.m_data.length + 1) / 2;
            double[] err = this.m_wk.totalErrorVariance(cmp, true, 0, n);
            double[] e = new double[this.m_data.length];
            for (int i = 0; i < err.length; ++i) {
                double x;
                e[i] = x = this.m_ser * Math.sqrt(err[i]);
                e[e.length - i - 1] = x;
            }
            return e;
        }
        catch (ArimaException | MatrixException err) {
            return new double[this.m_data.length];
        }
    }

    public double[] stdevForecasts(int cmp, boolean signal) {
        try {
            this.calc(cmp);
            if (this.m_wk.getUcarimaModel().getComponent(cmp).isNull()) {
                if (signal) {
                    return new double[this.m_nf];
                }
                return null;
            }
            double[] e = this.m_wk.totalErrorVariance(cmp, signal, -this.m_nf, this.m_nf);
            double[] err = new double[this.m_nf];
            for (int i = 0; i < this.m_nf; ++i) {
                err[i] = this.m_ser * Math.sqrt(e[this.m_nf - 1 - i]);
            }
            return err;
        }
        catch (ArimaException | MatrixException err) {
            return null;
        }
    }
}

