/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.multiexprtree;

import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractCreator;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.multiexprtree.MultiExprTreeSpecies;

public class MultiExprTreeCreator
extends AbstractCreator {
    private static final long serialVersionUID = 4365866784680115536L;
    protected transient MultiExprTreeSpecies species;
    protected transient ExprTreeSchema[] schema;

    public boolean equals(Object other) {
        return other instanceof MultiExprTreeCreator;
    }

    @Override
    protected void prepareCreation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof MultiExprTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (MultiExprTreeSpecies)spc;
        this.schema = ((MultiExprTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void createNext() {
        int numberOfExpressionTrees = this.schema.length;
        ExprTree[] genotype = new ExprTree[numberOfExpressionTrees];
        int i = 0;
        while (i < numberOfExpressionTrees) {
            int minSize = this.schema[i].getMinTreeSize();
            int maxSize = this.schema[i].getMaxTreeSize();
            int actSize = this.randgen.choose(minSize, maxSize);
            genotype[i] = this.schema[i].createExprTree(actSize, this.randgen);
            ++i;
        }
        this.createdBuffer.add(this.species.createIndividual(genotype));
    }
}

