/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR;

import java.io.IOException;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.Apriori;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.myDataset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.parseParameters;
import org.core.Fichero;
import org.core.Files;
import org.core.Randomize;

public class CFAR {
    myDataset train;
    myDataset val;
    myDataset test;
    String outputTr;
    String outputTst;
    String fileDB;
    String fileRB;
    String fileTime;
    String fileHora;
    String data;
    DataBase dataBase;
    RuleBase ruleBase;
    RuleBase bestRuleBase;
    Apriori apriori;
    long startTime;
    long totalTime;
    int nLabels;
    double minpsup;
    double minpconf;
    double MS;
    private boolean somethingWrong = false;

    public CFAR() {
    }

    public CFAR(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.train = new myDataset();
        this.val = new myDataset();
        this.test = new myDataset();
        try {
            System.out.println("\nReading the training set: " + parameters.getTrainingInputFile());
            this.train.readClassificationSet(parameters.getTrainingInputFile(), true);
            System.out.println("\nReading the validation set: " + parameters.getValidationInputFile());
            this.val.readClassificationSet(parameters.getValidationInputFile(), false);
            System.out.println("\nReading the test set: " + parameters.getTestInputFile());
            this.test.readClassificationSet(parameters.getTestInputFile(), false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.train.hasMissingAttributes();
        this.outputTr = parameters.getTrainingOutputFile();
        this.outputTst = parameters.getTestOutputFile();
        this.fileDB = parameters.getOutputFile(0);
        this.fileRB = parameters.getOutputFile(1);
        this.data = parameters.getTrainingInputFile();
        this.fileTime = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/hora.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.minpsup = Double.parseDouble(parameters.getParameter(1));
        this.minpconf = Double.parseDouble(parameters.getParameter(2));
        this.MS = Double.parseDouble(parameters.getParameter(3));
        this.nLabels = Integer.parseInt(parameters.getParameter(4));
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found, either the data-set has missing values.");
            System.err.println("Please remove the examples with missing data or apply a MV preprocessing.");
            System.err.println("Aborting the program");
        } else {
            this.dataBase = new DataBase(this.nLabels, this.train);
            this.train.transform(this.dataBase);
            this.ruleBase = new RuleBase(this.dataBase, this.train);
            this.apriori = new Apriori(this.minpsup, this.minpconf, this.MS, this.ruleBase);
            System.out.println("Generating rules");
            this.apriori.generate(this.train, this.dataBase.getnLabels());
            System.out.println("Selecting rules");
            System.out.println("Number of rules: " + this.ruleBase.size());
            this.ruleBase.selection();
            System.out.println("Number of rules selected: " + this.ruleBase.size());
            System.out.println("Building classifier");
            this.ruleBase = this.bestRuleBase = this.ruleBase.classifier();
            this.dataBase.saveFile(this.fileDB);
            this.ruleBase.saveFile(this.fileRB);
            this.doOutput(this.val, this.outputTr);
            this.doOutput(this.test, this.outputTst);
            this.totalTime = System.currentTimeMillis() - this.startTime;
            this.writeTime();
            System.out.println("Algorithm Finished");
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.data + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.data + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void doOutput(myDataset dataset, String filename) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.getnData(); ++i) {
            output = output + dataset.getOutputAsString(i) + " " + this.classificationOutput(dataset.getExample(i)) + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private String classificationOutput(double[] example) {
        String output = new String("?");
        int clase = this.ruleBase.FRM(example);
        if (clase >= 0) {
            output = this.train.getOutputValue(clase);
        }
        return output;
    }
}

