/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IPopulation;
import net.sf.jclec.ISelector;
import net.sf.jclec.ISystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelector<I extends IIndividual>
implements ISelector<I> {
    protected IPopulation<I> context;
    protected transient List<I> actsrc;
    protected transient int actsrcsz;

    public AbstractSelector() {
    }

    public AbstractSelector(ISystem<I> context) {
        this.contextualize(context);
    }

    @Override
    public void contextualize(ISystem<I> context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
    }

    @Override
    public List<I> select(List<I> src) {
        return this.select(src, src.size());
    }

    @Override
    public List<I> select(List<I> src, int nofsel) {
        this.actsrc = src;
        this.actsrcsz = src.size();
        this.prepareSelection();
        ArrayList<I> result = new ArrayList<I>();
        int i = 0;
        while (i < nofsel) {
            result.add(this.selectNext());
            ++i;
        }
        return result;
    }

    protected abstract void prepareSelection();

    protected abstract I selectNext();
}

