/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.neural;

import weka.classifiers.functions.neural.NeuralConnection;
import weka.classifiers.functions.neural.NeuralMethod;
import weka.classifiers.functions.neural.NeuralNode;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class SigmoidUnit
implements NeuralMethod,
RevisionHandler {
    private static final long serialVersionUID = -5162958458177475652L;

    @Override
    public double outputValue(NeuralNode node) {
        double[] weights = node.getWeights();
        NeuralConnection[] inputs = node.getInputs();
        double value = weights[0];
        for (int noa = 0; noa < node.getNumInputs(); ++noa) {
            value += inputs[noa].outputValue(true) * weights[noa + 1];
        }
        value = value < -45.0 ? 0.0 : (value > 45.0 ? 1.0 : 1.0 / (1.0 + Math.exp(-value)));
        return value;
    }

    @Override
    public double errorValue(NeuralNode node) {
        NeuralConnection[] outputs = node.getOutputs();
        int[] oNums = node.getOutputNums();
        double error = 0.0;
        for (int noa = 0; noa < node.getNumOutputs(); ++noa) {
            error += outputs[noa].errorValue(true) * outputs[noa].weightValue(oNums[noa]);
        }
        double value = node.outputValue(false);
        return error *= value * (1.0 - value);
    }

    @Override
    public void updateWeights(NeuralNode node, double learn, double momentum) {
        NeuralConnection[] inputs = node.getInputs();
        double[] cWeights = node.getChangeInWeights();
        double[] weights = node.getWeights();
        double learnTimesError = 0.0;
        learnTimesError = learn * node.errorValue(false);
        double c = learnTimesError + momentum * cWeights[0];
        weights[0] = weights[0] + c;
        cWeights[0] = c;
        int stopValue = node.getNumInputs() + 1;
        for (int noa = 1; noa < stopValue; ++noa) {
            c = learnTimesError * inputs[noa - 1].outputValue(false);
            int n = noa;
            weights[n] = weights[n] + (c += momentum * cWeights[noa]);
            cWeights[noa] = c;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

