/*
 * Decompiled with CFR 0.152.
 */
package vu.co.kaiyin;

import java.security.InvalidParameterException;
import vu.co.kaiyin.GenoBytes;

public class ShiftCodes {
    private final byte[][] shiftMatrix = new byte[256][256];

    public ShiftCodes(int[][] collapseMatrix) {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                this.shiftMatrix[i][j] = GenoBytes.genoByte(GenoBytes.collapse((byte)i, (byte)j, collapseMatrix));
            }
        }
    }

    public ShiftCodes() {
        this(GenoBytes.defaultCollapseMatrix);
    }

    public byte lookup(byte b1, byte b2) {
        return this.shiftMatrix[b1 & 0xFF][b2 & 0xFF];
    }

    public byte[] lookup(byte[] bs1, byte[] bs2) {
        if (bs1.length != bs2.length) {
            throw new InvalidParameterException("bs1 and bs2 must be of the same length");
        }
        byte[] res = new byte[bs1.length];
        for (int i = 0; i < bs1.length; ++i) {
            res[i] = this.lookup(bs1[i], bs2[i]);
        }
        return res;
    }

    public static void main(String[] args) {
        ShiftCodes shiftCodes1 = new ShiftCodes();
        ShiftCodes shiftCodes2 = new ShiftCodes(GenoBytes.antiDiagonal);
        System.out.println(shiftCodes1.lookup((byte)3, (byte)1));
    }
}

