/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.SparseVector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestAugmentableFeatureVector
extends TestCase {
    public TestAugmentableFeatureVector(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestAugmentableFeatureVector.class);
    }

    public void testDotProductBinaryToSV() {
        SparseVector v = this.makeSparseVectorToN(5);
        AugmentableFeatureVector afv = this.makeAfv(new int[]{1, 3}, true);
        double dp = afv.dotProduct(v);
        TestAugmentableFeatureVector.assertEquals((double)4.0, (double)dp, (double)1.0E-5);
        new AugmentableFeatureVector(new Alphabet(), true);
    }

    public void testDotProductSparseASVToSV() {
        SparseVector v = this.makeSparseVectorToN(7);
        AugmentableFeatureVector afv = this.makeAfv(new int[]{1, 3}, false);
        double dp = afv.dotProduct(v);
        TestAugmentableFeatureVector.assertEquals((double)4.0, (double)dp, (double)1.0E-5);
        afv = this.makeAfv(new int[]{2, 5}, false);
        dp = afv.dotProduct(v);
        TestAugmentableFeatureVector.assertEquals((double)7.0, (double)dp, (double)1.0E-5);
    }

    private AugmentableFeatureVector makeAfv(int[] ints, boolean binary) {
        AugmentableFeatureVector afv = new AugmentableFeatureVector(new Alphabet(), binary);
        for (int i = 0; i < ints.length; ++i) {
            int idx = ints[i];
            afv.add(idx, 1.0);
        }
        return afv;
    }

    private SparseVector makeSparseVectorToN(int N) {
        double[] vals = new double[N];
        for (int i = 0; i < N; ++i) {
            vals[i] = i;
        }
        return new SparseVector(vals);
    }

    public void testAddWithPrefix() {
        Alphabet dict = new Alphabet();
        dict.lookupIndex("ZERO");
        dict.lookupIndex("ONE");
        dict.lookupIndex("TWO");
        dict.lookupIndex("THREE");
        FeatureVector fv = new FeatureVector(dict, new int[]{1, 3});
        AugmentableFeatureVector afv = new AugmentableFeatureVector(new Alphabet(), true);
        afv.add(fv, "O:");
        TestAugmentableFeatureVector.assertEquals((int)4, (int)dict.size());
        TestAugmentableFeatureVector.assertEquals((int)2, (int)afv.getAlphabet().size());
        TestAugmentableFeatureVector.assertEquals((String)"O:ONE\nO:THREE\n", (String)afv.toString());
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestAugmentableFeatureVector(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestAugmentableFeatureVector.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

