/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.types.InstanceList;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Logger;

public class InstanceListSplitter {
    private static Logger logger = MalletLogger.getLogger(InstanceListSplitter.class.getName());
    static CommandOption.File inputFile = new CommandOption.File(InstanceListSplitter.class, "input", "FILE", true, new File("-"), "Read the instance list from this file; Using - indicates stdin.", null);
    static CommandOption.File trainingFile = new CommandOption.File(InstanceListSplitter.class, "training-file", "FILE", true, new File("training.vectors"), "Write the training set instance list to this file (or use --output if you are only pruning features); Using - indicates stdout.", null);
    static CommandOption.File testFile = new CommandOption.File(InstanceListSplitter.class, "testing-file", "FILE", true, new File("test.vectors"), "Write the test set instance list to this file; Using - indicates stdout.", null);
    static CommandOption.File validationFile = new CommandOption.File(InstanceListSplitter.class, "validation-file", "FILE", true, new File("validation.vectors"), "Write the validation set instance list to this file; Using - indicates stdout.", null);
    static CommandOption.Double trainingProportion = new CommandOption.Double(InstanceListSplitter.class, "training-portion", "DECIMAL", true, 1.0, "The fraction of the instances that should be used for training.", null);
    static CommandOption.Double validationProportion = new CommandOption.Double(InstanceListSplitter.class, "validation-portion", "DECIMAL", true, 0.0, "The fraction of the instances that should be used for validation.", null);
    static CommandOption.Integer randomSeed = new CommandOption.Integer(InstanceListSplitter.class, "random-seed", "INTEGER", true, 0, "The random seed for randomly selecting a proportion of the instance list for training", null);

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CommandOption.setSummary(InstanceListSplitter.class, "A tool for manipulating instance lists of feature vectors.");
        CommandOption.process(InstanceListSplitter.class, args);
        if (args.length == 0) {
            CommandOption.getList(InstanceListSplitter.class).printUsage(false);
            System.exit(-1);
        }
        Random r = randomSeed.wasInvoked() ? new Random(InstanceListSplitter.randomSeed.value) : new Random();
        double t = InstanceListSplitter.trainingProportion.value;
        double v = InstanceListSplitter.validationProportion.value;
        logger.info("Training portion = " + t);
        logger.info("Validation portion = " + v);
        logger.info("Testing portion = " + (1.0 - v - t));
        InstanceList instances = InstanceList.load(InstanceListSplitter.inputFile.value);
        InstanceList[] instanceLists = instances.split(r, new double[]{t, 1.0 - t - v, v});
        if (instanceLists[0].size() > 0) {
            InstanceListSplitter.writeInstanceList(instanceLists[0], trainingFile.value());
        }
        if (instanceLists[1].size() > 0) {
            InstanceListSplitter.writeInstanceList(instanceLists[1], testFile.value());
        }
        if (instanceLists[2].size() > 0) {
            InstanceListSplitter.writeInstanceList(instanceLists[2], validationFile.value());
        }
    }

    private static void writeInstanceList(InstanceList instances, File file) throws FileNotFoundException, IOException {
        logger.info("Writing instance list to " + file);
        instances.save(file);
    }
}

