/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import salvo.jesus.graph.javax.swing.GeneralPathPanelList;
import salvo.jesus.graph.javax.swing.JButtonColorListener;
import salvo.jesus.graph.javax.swing.JColor;
import salvo.jesus.graph.javax.swing.JTabPanel;
import salvo.jesus.graph.visual.VisualGraphComponent;
import salvo.jesus.graph.visual.VisualVertex;

class ShapePanel
extends JTabPanel {
    VisualGraphComponent vgcomponent;
    JPanel shapePanel;
    JComboBox shapeList;
    GeneralPathPanelList pathPanelList;
    JLabel outlineColorButtonLabel;
    JLabel fillColorLabel;
    JColor outlineColorButton;
    JColor fillColor;
    JButton outlineColorButtonbutton;
    JButton fillColorButton;
    JButtonColorListener outlineColorButtonListener;
    JButtonColorListener fillColorlistener;

    ShapePanel(VisualGraphComponent vgcomponent) {
        this.vgcomponent = vgcomponent;
        this.initShapePanel(vgcomponent.getOutlinecolor(), vgcomponent.getFillcolor());
    }

    private void initShapePanel(Color outlineColorButton, Color fillColor) {
        if (this.vgcomponent instanceof VisualVertex) {
            String[] options = new String[]{"Rectangle", "RoundedRectangle", "Ellipse"};
            this.shapeList = new JComboBox<String>(options);
            this.shapePanel = new JPanel();
            this.shapePanel.setLayout(new GridLayout(2, 1));
            this.shapePanel.add(new JLabel("Change Shape To"));
            this.shapePanel.add(this.shapeList);
        }
        this.pathPanelList = new GeneralPathPanelList(this.vgcomponent.getGeneralPath(), this.vgcomponent.getOutlinecolor());
        this.outlineColorButton = new JColor(outlineColorButton);
        this.fillColor = new JColor(fillColor);
        this.outlineColorButtonLabel = new JLabel("Outline Color:");
        this.fillColorLabel = new JLabel("Fill Color:");
        this.outlineColorButtonbutton = new JButton();
        this.fillColorButton = new JButton();
        this.outlineColorButtonListener = new JButtonColorListener(this, this.outlineColorButton, this.outlineColorButtonbutton);
        this.fillColorlistener = new JButtonColorListener(this, this.fillColor, this.fillColorButton);
        this.outlineColorButton.addActionListener(this.outlineColorButtonListener);
        this.fillColor.addActionListener(this.fillColorlistener);
        this.outlineColorButtonbutton.addActionListener(this.outlineColorButtonListener);
        this.fillColorButton.addActionListener(this.fillColorlistener);
        this.outlineColorButton.setColor(this.outlineColorButton.getColor());
        this.fillColor.setColor(this.fillColor.getColor());
        JPanel colorspanel = new JPanel();
        colorspanel.setLayout(new GridLayout(0, 2));
        colorspanel.add(this.outlineColorButtonLabel);
        colorspanel.add(this.outlineColorButtonbutton);
        colorspanel.add(this.fillColorLabel);
        colorspanel.add(this.fillColorButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pathPanelList, "Center");
        if (this.vgcomponent instanceof VisualVertex) {
            this.add((Component)this.shapePanel, "North");
            this.add((Component)colorspanel, "South");
        } else {
            this.add((Component)colorspanel, "North");
        }
    }

    public void apply() {
        if (this.vgcomponent instanceof VisualVertex) {
            String selectedShape = (String)this.shapeList.getSelectedItem();
            Rectangle2D bounds = this.vgcomponent.getGeneralPath().getBounds2D();
            if (selectedShape.equals("Rectangle")) {
                Rectangle2D.Double rect = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                this.vgcomponent.setGeneralPath(rect.getPathIterator(null));
            } else if (selectedShape.equals("RoundedRectangle")) {
                RoundRectangle2D.Double rect = new RoundRectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight(), 10.0, 10.0);
                this.vgcomponent.setGeneralPath(rect.getPathIterator(null));
            } else if (selectedShape.equals("Ellipse")) {
                Ellipse2D.Double ellipse = new Ellipse2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                this.vgcomponent.setGeneralPath(ellipse.getPathIterator(null));
            }
        }
        this.vgcomponent.setFillcolor(this.fillColor.getColor());
        this.vgcomponent.setOutlinecolor(this.outlineColorButton.getColor());
        this.pathPanelList.setGeneralPath(this.vgcomponent.getGeneralPath());
        this.pathPanelList.setOutlineColor(this.vgcomponent.getOutlinecolor());
    }

    public void ok() {
        this.apply();
    }
}

