/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.tree.TreeSConstraint;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.reified.leaves.ConstraintLeaf;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintManager;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.tree.TreeNodeObject;
import choco.kernel.model.variables.tree.TreeParametersObject;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.INode;
import java.util.List;

public final class TreeManager
extends ConstraintManager<Variable> {
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof TreeParametersObject) {
            TreeParametersObject tpo = (TreeParametersObject)parameters;
            int nbNodes = tpo.getNbNodes();
            TreeNodeObject[] tnodes = tpo.getNodes();
            Node[] nodes = new Node[tnodes.length];
            TreeParameters params = null;
            for (int i = 0; i < tnodes.length; ++i) {
                TreeNodeObject tn = tnodes[i];
                nodes[i] = new Node(solver, nbNodes, tn.getIdx(), solver.getVar(tn.getSuccessors()), solver.getVar(tn.getInDegree()), solver.getVar(tn.getTimeWindow()), tpo.getGraphs());
            }
            params = new TreeParameters(solver, nbNodes, solver.getVar(tpo.getNTree()), solver.getVar(tpo.getNproper()), solver.getVar(tpo.getObjective()), nodes, tpo.getTravel());
            return new TreeSConstraint(params.getAllVars(), params);
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }

    @Override
    public int[] getFavoriteDomains(List<String> options) {
        return TreeManager.getACFavoriteIntDomains();
    }

    @Override
    public INode makeNode(Solver solver, Constraint[] cstrs, Variable[] vars) {
        return new ConstraintLeaf(((CPSolver)solver).makeSConstraint(cstrs[0]), null);
    }

    public SConstraint[] makeConstraintAndOpposite(Solver solver, Variable[] variables, Object parameters, List<String> options) {
        throw new UnsupportedOperationException();
    }
}

