/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.objects;

import java.lang.reflect.Array;

public class CircularQueue<E> {
    protected transient int modCount = 0;
    private E[] elementData;
    private int head = 0;
    private int tail = 0;
    private int size = 0;

    public CircularQueue() {
        this(10);
    }

    public CircularQueue(int size) {
        this.elementData = new Object[size];
    }

    private int convert(int index) {
        return (index + this.head) % this.elementData.length;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] newData = new Object[newCapacity];
            this.toArray(newData);
            this.tail = this.size;
            this.head = 0;
            this.elementData = newData;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[this.convert(i)] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!elem.equals(this.elementData[this.convert(i)])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        if (elem == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[this.convert(i)] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!elem.equals(this.elementData[this.convert(i)])) continue;
                return i;
            }
        }
        return -1;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        if (this.head < this.tail) {
            System.arraycopy(this.elementData, this.head, a, 0, this.tail - this.head);
        } else {
            System.arraycopy(this.elementData, this.head, a, 0, this.elementData.length - this.head);
            System.arraycopy(this.elementData, 0, a, this.elementData.length - this.head, this.tail);
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    public E get(int index) {
        this.rangeCheck(index);
        return this.elementData[this.convert(index)];
    }

    public boolean add(E e) {
        ++this.modCount;
        this.ensureCapacity(this.size + 1 + 1);
        this.elementData[this.tail] = e;
        this.tail = (this.tail + 1) % this.elementData.length;
        ++this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E pop() {
        ++this.modCount;
        this.rangeCheck(0);
        int pos = this.convert(0);
        try {
            E e = this.elementData[pos];
            return e;
        }
        finally {
            this.elementData[pos] = null;
            if (pos == this.head) {
                this.head = (this.head + 1) % this.elementData.length;
            }
            --this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll() {
        ++this.modCount;
        this.rangeCheck(0);
        int pos = this.convert(0);
        try {
            E e = this.elementData[pos];
            return e;
        }
        finally {
            this.elementData[pos] = null;
            if (pos == this.head) {
                this.head = (this.head + 1) % this.elementData.length;
            } else if (pos == this.tail) {
                this.tail = (this.tail - 1 + this.elementData.length) % this.elementData.length;
            } else if (pos > this.head && pos > this.tail) {
                System.arraycopy(this.elementData, this.head, this.elementData, this.head + 1, pos - this.head);
                this.head = (this.head + 1) % this.elementData.length;
            } else {
                System.arraycopy(this.elementData, pos + 1, this.elementData, pos, this.tail - pos - 1);
                this.tail = (this.tail - 1 + this.elementData.length) % this.elementData.length;
            }
            --this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove(int index) {
        ++this.modCount;
        this.rangeCheck(index);
        int pos = this.convert(index);
        try {
            E e = this.elementData[pos];
            return e;
        }
        finally {
            this.elementData[pos] = null;
            if (pos == this.head) {
                this.head = (this.head + 1) % this.elementData.length;
            } else if (pos == this.tail) {
                this.tail = (this.tail - 1 + this.elementData.length) % this.elementData.length;
            } else if (pos > this.head && pos > this.tail) {
                System.arraycopy(this.elementData, this.head, this.elementData, this.head + 1, pos - this.head);
                this.head = (this.head + 1) % this.elementData.length;
            } else {
                System.arraycopy(this.elementData, pos + 1, this.elementData, pos, this.tail - pos - 1);
                this.tail = (this.tail - 1 + this.elementData.length) % this.elementData.length;
            }
            --this.size;
        }
    }

    public void remove(E elt) {
        this.remove(this.indexOf(elt));
    }

    public void clear() {
        ++this.modCount;
        int i = this.head;
        while (i != this.tail) {
            this.elementData[i] = null;
            i = (i + 1) % this.elementData.length;
        }
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }
}

