/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.propagation;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.search.IObjectiveManager;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class ShavingTools {
    public final Solver solver;
    public final IntDomainVar[] vars;
    public boolean shaveLowerBound = false;
    public boolean detectLuckySolution = false;
    private int nbRemovals;

    public ShavingTools(Solver solver, IntDomainVar[] vars) {
        this.solver = solver;
        this.vars = ShavingTools.checkAbsentVar(vars, solver.getObjective());
    }

    public final boolean isShavingLowerBound() {
        return this.shaveLowerBound;
    }

    public final void setShavingLowerBound(boolean b) {
        this.shaveLowerBound = b;
    }

    public final boolean isDetectingLuckySolution() {
        return this.detectLuckySolution;
    }

    public final void setDetectLuckySolution(boolean detectLuckySolution) {
        this.detectLuckySolution = detectLuckySolution;
    }

    private static IntDomainVar[] checkAbsentVar(IntDomainVar[] vars, Var var) {
        if (var != null && var instanceof IntDomainVar) {
            int idx = -1;
            for (int i = 0; i < vars.length; ++i) {
                if (vars[i] != var) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                IntDomainVar[] newVars = new IntDomainVar[vars.length - 1];
                System.arraycopy(vars, 0, newVars, 0, idx);
                System.arraycopy(vars, idx + 1, newVars, idx, vars.length - idx - 1);
                return vars;
            }
        }
        return vars;
    }

    public final Solver getSolver() {
        return this.solver;
    }

    public final IntDomainVar[] getVars() {
        return this.vars;
    }

    public final int getNbRemovals() {
        return this.nbRemovals;
    }

    protected final void shaveVars() throws ContradictionException, LuckySolutionException {
        this.nbRemovals = 0;
        for (IntDomainVar var : this.vars) {
            if (var.isInstantiated()) continue;
            if (var.hasEnumeratedDomain()) {
                this.shaveEnumVar(var);
                continue;
            }
            this.shaveBoundVar(var);
        }
    }

    public final void shaving() throws ContradictionException {
        try {
            this.shaveVars();
        }
        catch (LuckySolutionException luckySolutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shaveEnumVar(IntDomainVar var) throws LuckySolutionException, ContradictionException {
        DisposableIntIterator iter = var.getDomain().getIterator();
        try {
            while (iter.hasNext()) {
                this.shaving(var, iter.next());
            }
        }
        finally {
            iter.dispose();
        }
    }

    protected void shaveBoundVar(IntDomainVar var) throws LuckySolutionException, ContradictionException {
        int oldNbR;
        do {
            oldNbR = this.nbRemovals;
            this.shaving(var, var.getInf());
        } while (this.nbRemovals > oldNbR);
        do {
            oldNbR = this.nbRemovals;
            this.shaving(var, var.getSup());
        } while (this.nbRemovals > oldNbR);
    }

    protected void shaving(IntDomainVar var, int val) throws LuckySolutionException, ContradictionException {
        this.solver.worldPush();
        try {
            var.instantiate(val, null, true);
            this.solver.propagate();
            if (this.detectLuckySolution) {
                this.detectLuckySolution();
            }
            this.solver.worldPop();
        }
        catch (ContradictionException e) {
            this.solver.worldPop();
            ++this.nbRemovals;
            var.removeVal(val, null, true);
            this.solver.propagate();
        }
    }

    public final void destructiveLowerBound(IObjectiveManager objM) throws ContradictionException {
        boolean mem;
        block6: {
            mem = this.detectLuckySolution;
            this.detectLuckySolution = true;
            objM.initBounds();
            try {
                while (this.shaveObjective(objM)) {
                    objM.incrementFloorBound();
                }
                assert (!objM.isTargetInfeasible());
                if (objM.getObjectiveValue().equals(objM.getObjectiveFloor())) break block6;
                try {
                    objM.postFloorBound();
                }
                catch (ContradictionException e) {
                    throw new SolverException("Destructive Lower Bound: Invalid bounds");
                }
                this.solver.propagate();
            }
            catch (LuckySolutionException luckySolutionException) {
                // empty catch block
            }
        }
        this.detectLuckySolution = mem;
    }

    protected final boolean shaveObjective(IObjectiveManager objM) throws ContradictionException, LuckySolutionException {
        boolean shave = false;
        this.solver.worldPush();
        objM.postIncFloorBound();
        try {
            this.solver.propagate();
            this.detectLuckySolution();
            if (this.isShavingLowerBound()) {
                this.shaveVars();
            }
        }
        catch (ContradictionException e) {
            shave = true;
        }
        this.solver.worldPop();
        return shave;
    }

    public Boolean nextBottomUp(IObjectiveManager objM) {
        try {
            objM.postIncFloorBound();
        }
        catch (ContradictionException e) {
            throw new SolverException("Destructive Lower Bound: Invalid bounds : " + objM.getObjectiveFloor());
        }
        try {
            this.solver.propagate();
            if (this.isShavingLowerBound()) {
                this.shaving();
            }
        }
        catch (ContradictionException e) {
            return Boolean.FALSE;
        }
        this.solver.worldPush();
        return this.solver.getSearchStrategy().nextSolution();
    }

    protected final void detectLuckySolution() throws LuckySolutionException {
        int i;
        int n = this.solver.getNbIntVars();
        for (i = 0; i < n; ++i) {
            if (this.solver.getIntVarQuick(i).isInstantiated()) continue;
            return;
        }
        n = this.solver.getNbSetVars();
        for (i = 0; i < n; ++i) {
            if (this.solver.getSetVarQuick(i).isInstantiated()) continue;
            return;
        }
        if (this.solver.getNbRealVars() > 0) {
            return;
        }
        throw LuckySolutionException.SINGLOTON;
    }

    static final class LuckySolutionException
    extends Exception {
        private static final long serialVersionUID = -1476316199858738423L;
        public static final LuckySolutionException SINGLOTON = new LuckySolutionException();

        private LuckySolutionException() {
            super("Shaving lead to a solution");
        }
    }
}

