/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import opennlp.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import opennlp.tools.cmdline.sentdetect.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.SDCrossValidator;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SentenceDetectorCrossValidatorTool
extends AbstractCrossValidatorTool<SentenceSample, CVToolParams> {
    public SentenceDetectorCrossValidatorTool() {
        super(SentenceSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable sentence detector";
    }

    @Override
    public void run(String format, String[] args) {
        SDCrossValidator validator;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        SentenceEvaluationErrorListener errorListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            errorListener = new SentenceEvaluationErrorListener();
        }
        char[] eos = null;
        if (((CVToolParams)this.params).getEosChars() != null) {
            eos = ((CVToolParams)this.params).getEosChars().toCharArray();
        }
        try {
            Dictionary abbreviations = SentenceDetectorTrainerTool.loadDict(((CVToolParams)this.params).getAbbDict());
            SentenceDetectorFactory sdFactory = SentenceDetectorFactory.create(((CVToolParams)this.params).getFactory(), ((CVToolParams)this.params).getLang(), true, abbreviations, eos);
            validator = new SDCrossValidator(((CVToolParams)this.params).getLang(), this.mlParams, sdFactory, errorListener);
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        FMeasure result = validator.getFMeasure();
        System.out.println(result.toString());
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams {
    }
}

