/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.dmg.pmml.Cell;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Row;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.AbstractVisitor;
import org.w3c.dom.Element;

public class ModelVerificationCleaner
extends AbstractVisitor {
    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            Model model = (Model)parent;
            this.processModel(model);
        }
        return parent;
    }

    private void processModel(Model model) {
        ModelVerification modelVerification = model.getModelVerification();
        if (modelVerification != null) {
            LinkedHashSet<FieldName> activeFieldNames = new LinkedHashSet<FieldName>();
            LinkedHashSet<FieldName> targetFieldNames = new LinkedHashSet<FieldName>();
            final LinkedHashSet<FieldName> outputFieldNames = new LinkedHashSet<FieldName>();
            MiningSchema miningSchema = model.getMiningSchema();
            if (miningSchema != null && miningSchema.hasMiningFields()) {
                List miningFields = miningSchema.getMiningFields();
                for (MiningField miningField : miningFields) {
                    FieldName name = miningField.getName();
                    MiningField.UsageType usageType = miningField.getUsageType();
                    switch (usageType) {
                        case ACTIVE: {
                            activeFieldNames.add(name);
                            break;
                        }
                        case PREDICTED: 
                        case TARGET: {
                            targetFieldNames.add(name);
                            break;
                        }
                    }
                }
            }
            AbstractVisitor visitor = new AbstractVisitor(){

                public VisitorAction visit(OutputField outputField) {
                    FieldName name = outputField.getName();
                    outputFieldNames.add(name);
                    return super.visit(outputField);
                }
            };
            visitor.applyTo((Visitable)model);
            this.clean(modelVerification, activeFieldNames, targetFieldNames, outputFieldNames);
        }
    }

    private void clean(ModelVerification modelVerification, Set<FieldName> activeFieldNames, Set<FieldName> targetFieldNames, Set<FieldName> outputFieldNames) {
        VerificationFields verificationFields = modelVerification.getVerificationFields();
        InlineTable inlineTable = modelVerification.getInlineTable();
        if (verificationFields == null || !verificationFields.hasVerificationFields()) {
            return;
        }
        if (inlineTable == null || !inlineTable.hasRows()) {
            return;
        }
        boolean hasOutput = false;
        for (VerificationField verificationField : verificationFields) {
            FieldName name = verificationField.getField();
            hasOutput |= outputFieldNames.contains(name);
        }
        HashSet<FieldName> names = new HashSet<FieldName>();
        names.addAll(activeFieldNames);
        names.addAll(hasOutput ? outputFieldNames : targetFieldNames);
        LinkedHashSet<String> retainedColumns = new LinkedHashSet<String>();
        Iterator it = verificationFields.iterator();
        while (it.hasNext()) {
            VerificationField verificationField = (VerificationField)it.next();
            FieldName name = verificationField.getField();
            String column = verificationField.getColumn();
            if (!names.contains(name)) {
                it.remove();
                continue;
            }
            retainedColumns.add(column);
        }
        List rows = inlineTable.getRows();
        for (Row row : rows) {
            if (!row.hasContent()) continue;
            List cells = row.getContent();
            Iterator it2 = cells.iterator();
            while (it2.hasNext()) {
                String column;
                Object cell = it2.next();
                if (cell instanceof Cell) {
                    Cell pmmlCell = (Cell)cell;
                    column = ModelVerificationCleaner.formatColumn(pmmlCell.getName());
                } else if (cell instanceof JAXBElement) {
                    JAXBElement jaxbElement = (JAXBElement)cell;
                    column = ModelVerificationCleaner.formatColumn(jaxbElement.getName());
                } else {
                    if (!(cell instanceof Element)) continue;
                    Element domElement = (Element)cell;
                    column = ModelVerificationCleaner.formatColumn(domElement.getPrefix(), domElement.getLocalName());
                }
                if (retainedColumns.contains(column)) continue;
                it2.remove();
            }
        }
    }

    private static String formatColumn(QName xmlName) {
        return ModelVerificationCleaner.formatColumn(xmlName.getPrefix(), xmlName.getLocalPart());
    }

    private static String formatColumn(String prefix, String localPart) {
        if (prefix != null && !"".equals(prefix)) {
            return prefix + ":" + localPart;
        }
        return localPart;
    }
}

