/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringModel;
import org.jpmml.converter.FortranMatrixUtil;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.clustering.ClusteringModelUtil;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RStringVector;

public class KMeansConverter
extends ModelConverter<RGenericVector> {
    public KMeansConverter(RGenericVector kmeans) {
        super(kmeans);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector kmeans = (RGenericVector)this.getObject();
        RDoubleVector centers = kmeans.getDoubleElement("centers");
        RStringVector columnNames = centers.dimnames(1);
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.getValue(i);
            DataField dataField = encoder.createDataField(FieldName.create((String)columnName), OpType.CONTINUOUS, DataType.DOUBLE);
            encoder.addFeature((Field<?>)dataField);
        }
    }

    @Override
    public Model encodeModel(Schema schema) {
        RGenericVector kmeans = (RGenericVector)this.getObject();
        RDoubleVector centers = kmeans.getDoubleElement("centers");
        RIntegerVector size = kmeans.getIntegerElement("size");
        RIntegerVector centersDim = centers.dim();
        int rows = centersDim.getValue(0);
        int columns = centersDim.getValue(1);
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        RStringVector rowNames = centers.dimnames(0);
        for (int i = 0; i < rowNames.size(); ++i) {
            Cluster cluster = new Cluster(PMMLUtil.createRealArray((List)FortranMatrixUtil.getRow(centers.getValues(), (int)rows, (int)columns, (int)i))).setId(String.valueOf(i + 1)).setName(rowNames.getValue(i)).setSize(size.getValue(i));
            clusters.add(cluster);
        }
        ComparisonMeasure comparisonMeasure = new ComparisonMeasure(ComparisonMeasure.Kind.DISTANCE, (Measure)new SquaredEuclidean()).setCompareFunction(CompareFunction.ABS_DIFF);
        ClusteringModel clusteringModel = new ClusteringModel(MiningFunction.CLUSTERING, ClusteringModel.ModelClass.CENTER_BASED, Integer.valueOf(rows), ModelUtil.createMiningSchema((Label)schema.getLabel()), comparisonMeasure, ClusteringModelUtil.createClusteringFields((List)schema.getFeatures()), clusters).setOutput(ClusteringModelUtil.createOutput((FieldName)FieldName.create((String)"cluster"), (DataType)DataType.DOUBLE, clusters));
        return clusteringModel;
    }
}

