/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter;
import com.hp.hpl.jena.xmloutput.impl.Unparser;
import java.io.PrintWriter;
import java.io.Writer;

public class Abbreviated
extends BaseXMLWriter
implements RDFErrorHandler {
    private Resource[] types = new Resource[]{DAML_OIL.Ontology, OWL.Ontology, DAML_OIL.Datatype, RDFS.Datatype, DAML_OIL.Class, RDFS.Class, OWL.Class, DAML_OIL.Property, OWL.ObjectProperty, RDF.Property, DAML_OIL.ObjectProperty, OWL.DatatypeProperty, DAML_OIL.DatatypeProperty, OWL.TransitiveProperty, OWL.SymmetricProperty, OWL.FunctionalProperty, OWL.InverseFunctionalProperty, DAML_OIL.TransitiveProperty, DAML_OIL.UnambiguousProperty, DAML_OIL.UniqueProperty};
    boolean sReification;
    boolean sIdAttr;
    boolean sDamlCollection;
    boolean sParseTypeCollectionPropertyElt;
    boolean sListExpand;
    boolean sParseTypeLiteralPropertyElt;
    boolean sParseTypeResourcePropertyElt;
    boolean sPropertyAttr;
    boolean sResourcePropertyElt;

    public Abbreviated() {
        this.unblockAll();
        this.blockRule(RDFSyntax.propertyAttr);
    }

    @Override
    protected void unblockAll() {
        this.sDamlCollection = false;
        this.sReification = false;
        this.sResourcePropertyElt = false;
        this.sParseTypeLiteralPropertyElt = false;
        this.sParseTypeResourcePropertyElt = false;
        this.sParseTypeCollectionPropertyElt = false;
        this.sIdAttr = false;
        this.sPropertyAttr = false;
        this.sListExpand = false;
    }

    @Override
    protected void blockRule(Resource r) {
        if (r.equals(RDFSyntax.sectionReification)) {
            this.sReification = true;
        } else if (r.equals(RDFSyntax.sectionListExpand)) {
            this.sListExpand = true;
        } else if (r.equals(RDFSyntax.parseTypeLiteralPropertyElt)) {
            this.sParseTypeLiteralPropertyElt = true;
        } else if (r.equals(RDFSyntax.parseTypeResourcePropertyElt)) {
            this.sParseTypeResourcePropertyElt = true;
        } else if (r.equals(RDFSyntax.parseTypeCollectionPropertyElt)) {
            this.sParseTypeCollectionPropertyElt = true;
        } else if (r.equals(RDFSyntax.idAttr)) {
            this.sIdAttr = true;
            this.sReification = true;
        } else if (r.equals(RDFSyntax.propertyAttr)) {
            this.sPropertyAttr = true;
        } else if (r.equals(DAML_OIL.collection)) {
            this.sDamlCollection = true;
        } else {
            logger.warn("Cannot block rule <" + r.getURI() + ">");
        }
    }

    @Override
    Resource[] setTypes(Resource[] propValue) {
        Resource[] rslt = this.types;
        this.types = propValue;
        return rslt;
    }

    @Override
    public synchronized void write(Model baseModel, Writer out, String base) {
        if (!baseModel.getGraph().getCapabilities().findContractSafe()) {
            logger.warn("Workaround for bugs 803804 and 858163: using RDF/XML (not RDF/XML-ABBREV) writer  for unsafe graph " + baseModel.getGraph().getClass());
            baseModel.write(out, "RDF/XML", base);
        } else {
            super.write(baseModel, out, base);
        }
    }

    @Override
    protected void writeBody(Model model, PrintWriter pw, String base, boolean useXMLBase) {
        Unparser unp = new Unparser(this, base, model, pw);
        unp.setTopLevelTypes(this.types);
        if (useXMLBase) {
            unp.setXMLBase(base);
        }
        unp.write();
    }

    @Override
    public void error(Exception e) {
        this.errorHandler.error(e);
    }

    @Override
    public void warning(Exception e) {
        this.errorHandler.warning(e);
    }

    @Override
    public void fatalError(Exception e) {
        this.errorHandler.fatalError(e);
    }
}

