/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.forcefield.mmff;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

final class MmffAromaticTypeMapping {
    private final Map<String, String> hetroTypes = ImmutableMap.builder().put("S", "STHI").put("-O-", "OFUR").put("OC=C", "OFUR").put("OC=N", "OFUR").put("NCN+", "NIM+").put("NGD+", "NIM+").put("NM", "N5M").put("NC=C", "NPYL").put("NC=N", "NPYL").put("NN=N", "NPYL").put("NC=O", "NPYL").put("NC=S", "NPYL").put("NSO2", "NPYL").put("NR", "NPYL").build();
    private final Map<String, String> alphaTypes = ImmutableMap.builder().put("CNN+", "CIM+").put("CGD+", "CIM+").put("C=C", "C5A").put("C=N", "C5A").put("CGD", "C5A").put("CB", "C5A").put("C5B", "C5").put("N2OX", "N5AX").put("NCN+", "NIM+").put("NGD+", "NIM+").put("N+=C", "N5A+").put("N+=N", "N5A+").put("NPD+", "N5A+").put("N=C", "N5A").put("N=N", "N5A").build();
    private final Map<String, String> betaTypes = ImmutableMap.builder().put("CNN+", "CIM+").put("CGD+", "CIM+").put("C=C", "C5B").put("C=N", "C5B").put("CGD", "C5B").put("CB", "C5B").put("C5A", "C5").put("N2OX", "N5BX").put("NCN+", "NIM+").put("NGD+", "NIM+").put("N+=C", "N5B+").put("N+=N", "N5B+").put("NPD+", "N5B+").put("N=C", "N5B").put("N=N", "N5B").build();
    private static final String C5 = "C5";
    private static final String C5A = "C5A";
    private static final String C5B = "C5B";
    private static final String N5A = "N5A";
    private static final String N5B = "N5B";
    private static final String NPYL = "NPYL";
    private static final String NCN_PLUS = "NCN+";
    private static final String NGD_PLUS = "NGD+";
    private static final String NIM_PLUS = "NIM+";
    private static final String N5A_PLUS = "N5A+";
    private static final String N5B_PLUS = "N5B+";
    private static final String N5M = "N5M";
    private static final String N5AX = "N5AX";
    private static final String N5BX = "N5BX";
    private static final String CIM_PLUS = "CIM+";
    private static final String OFUR = "OFUR";
    private static final String STHI = "STHI";

    MmffAromaticTypeMapping() {
    }

    void assign(IAtomContainer container, String[] symbs, GraphUtil.EdgeToBondMap bonds, int[][] graph, Set<IBond> mmffArom) {
        int[][] cycles;
        int[] contribution = new int[graph.length];
        int[] doubleBonds = new int[graph.length];
        Arrays.fill(doubleBonds, -1);
        MmffAromaticTypeMapping.setupContributionAndDoubleBonds(container, bonds, graph, contribution, doubleBonds);
        for (int[] cycle : cycles = MmffAromaticTypeMapping.findAromaticRings(MmffAromaticTypeMapping.cyclesOfSizeFiveOrSix(container, graph), contribution, doubleBonds)) {
            int len = cycle.length - 1;
            if (len == 6) {
                MmffAromaticTypeMapping.updateAromaticTypesInSixMemberRing(cycle, symbs);
            }
            if (len == 5 && MmffAromaticTypeMapping.normaliseCycle(cycle, contribution)) {
                this.updateAromaticTypesInFiveMemberRing(cycle, symbs);
            }
            for (int i = 1; i < cycle.length; ++i) {
                mmffArom.add(bonds.get(cycle[i], cycle[i - 1]));
            }
        }
    }

    private static int[][] findAromaticRings(int[][] cycles, int[] contribution, int[] dbs) {
        boolean found;
        boolean[] checked = new boolean[cycles.length];
        boolean[] aromaticAtoms = new boolean[contribution.length];
        ArrayList<int[]> ringsOfSize6 = new ArrayList<int[]>();
        ArrayList<int[]> ringsOfSize5 = new ArrayList<int[]>();
        do {
            found = false;
            for (int i = 0; i < cycles.length; ++i) {
                int[] cycle = cycles[i];
                int len = cycle.length - 1;
                if (checked[i] || !MmffAromaticTypeMapping.isAromaticRing(cycle, contribution, dbs, aromaticAtoms)) continue;
                checked[i] = true;
                found |= true;
                for (int j = 0; j < len; ++j) {
                    aromaticAtoms[cycle[j]] = true;
                }
                if (len == 6) {
                    ringsOfSize6.add(cycle);
                    continue;
                }
                if (len != 5) continue;
                ringsOfSize5.add(cycle);
            }
        } while (found);
        ArrayList<int[]> rings = new ArrayList<int[]>();
        rings.addAll(ringsOfSize6);
        rings.addAll(ringsOfSize5);
        return (int[][])rings.toArray((T[])new int[rings.size()][]);
    }

    static boolean isAromaticRing(int[] cycle, int[] contribution, int[] dbs, boolean[] aromatic) {
        int len = cycle.length - 1;
        int sum = 0;
        int i = 0;
        int iPrev = len - 1;
        int iNext = 1;
        while (i < len) {
            int prev = cycle[iPrev];
            int curr = cycle[i];
            int next = cycle[iNext];
            int pElectrons = contribution[curr];
            if (pElectrons < 0) {
                return false;
            }
            if (pElectrons == 1) {
                int other = dbs[curr];
                if (other < 0) {
                    return false;
                }
                if (other != prev && other != next && !aromatic[other]) {
                    return false;
                }
            }
            iPrev = i;
            i = iNext++;
            sum += pElectrons;
        }
        return (sum - 2) % 4 == 0;
    }

    static void updateAromaticTypesInSixMemberRing(int[] cycle, String[] symbs) {
        for (int v : cycle) {
            if (NCN_PLUS.equals(symbs[v]) || "N+=C".equals(symbs[v]) || "N=+C".equals(symbs[v])) {
                symbs[v] = "NPD+";
                continue;
            }
            if ("N2OX".equals(symbs[v])) {
                symbs[v] = "NPOX";
                continue;
            }
            if ("N=C".equals(symbs[v]) || "N=N".equals(symbs[v])) {
                symbs[v] = "NPYD";
                continue;
            }
            if (!symbs[v].startsWith("C")) continue;
            symbs[v] = "CB";
        }
    }

    private void updateAromaticTypesInFiveMemberRing(int[] cycle, String[] symbs) {
        String hetro = symbs[cycle[0]];
        boolean imidazolium = NCN_PLUS.equals(hetro) || NGD_PLUS.equals(hetro);
        boolean anion = "NM".equals(hetro);
        symbs[cycle[0]] = this.hetroTypes.get(hetro);
        symbs[cycle[1]] = this.getAlphaAromaticType(symbs[cycle[1]], imidazolium, anion);
        symbs[cycle[4]] = this.getAlphaAromaticType(symbs[cycle[4]], imidazolium, anion);
        symbs[cycle[2]] = this.getBetaAromaticType(symbs[cycle[2]], imidazolium, anion);
        symbs[cycle[3]] = this.getBetaAromaticType(symbs[cycle[3]], imidazolium, anion);
    }

    private String getAlphaAromaticType(String symb, boolean imidazolium, boolean anion) {
        return MmffAromaticTypeMapping.getAromaticType(this.alphaTypes, 'A', symb, imidazolium, anion);
    }

    private String getBetaAromaticType(String symb, boolean imidazolium, boolean anion) {
        return MmffAromaticTypeMapping.getAromaticType(this.betaTypes, 'B', symb, imidazolium, anion);
    }

    static String getAromaticType(Map<String, String> map, char suffix, String symb, boolean imidazolium, boolean anion) {
        if (anion && symb.startsWith("N")) {
            symb = N5M;
        }
        if (map.containsKey(symb)) {
            symb = map.get(symb);
        }
        if ((imidazolium || anion) && symb.charAt(symb.length() - 1) == suffix) {
            symb = symb.substring(0, symb.length() - 1);
        }
        return symb;
    }

    static int indexOfHetro(int[] cycle, int[] contribution) {
        int index = -1;
        for (int i = 0; i < cycle.length - 1; ++i) {
            if (contribution[cycle[i]] != 2) continue;
            index = index == -1 ? i : -2;
        }
        return index;
    }

    static boolean normaliseCycle(int[] cycle, int[] contribution) {
        int offset = MmffAromaticTypeMapping.indexOfHetro(cycle, contribution);
        if (offset < 0) {
            return false;
        }
        if (offset == 0) {
            return true;
        }
        int[] cpy = Arrays.copyOf(cycle, cycle.length);
        int len = cycle.length - 1;
        for (int j = 0; j < len; ++j) {
            cycle[j] = cpy[(offset + j) % len];
        }
        cycle[len] = cycle[0];
        return true;
    }

    static int contribution(int elem, int x, int v) {
        switch (elem) {
            case 6: {
                if (x != 3 || v != 4) break;
                return 1;
            }
            case 7: {
                if (x == 2 && v == 3) {
                    return 1;
                }
                if (x == 3 && v == 4) {
                    return 1;
                }
                if (x == 3 && v == 3) {
                    return 2;
                }
                if (x != 2 || v != 2) break;
                return 2;
            }
            case 8: 
            case 16: {
                if (x != 2 || v != 2) break;
                return 2;
            }
        }
        return -1;
    }

    static int[][] cyclesOfSizeFiveOrSix(IAtomContainer container, int[][] graph) {
        try {
            return Cycles.all(6).find(container, graph, 6).paths();
        }
        catch (Intractable intractable) {
            return new int[0][];
        }
    }

    private static void setupContributionAndDoubleBonds(IAtomContainer molecule, GraphUtil.EdgeToBondMap bonds, int[][] graph, int[] contribution, int[] dbs) {
        for (int v = 0; v < graph.length; ++v) {
            int hyd;
            int val = hyd = molecule.getAtom(v).getImplicitHydrogenCount().intValue();
            int con = hyd + graph[v].length;
            for (int w : graph[v]) {
                IBond bond = bonds.get(v, w);
                val += bond.getOrder().numeric().intValue();
                if (bond.getOrder() != IBond.Order.DOUBLE) continue;
                dbs[v] = dbs[v] == -1 ? w : -2;
            }
            contribution[v] = MmffAromaticTypeMapping.contribution(molecule.getAtom(v).getAtomicNumber(), con, val);
        }
    }
}

