/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.StringTokenizer;
import javax.vecmath.Vector3d;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.xml.sax.Attributes;

public class PMPConvention
extends CMLCoreModule {
    public PMPConvention(IChemFile chemFile) {
        super(chemFile);
    }

    public PMPConvention(ICMLModule conv) {
        super(conv);
        this.logger.debug("New PMP Convention!");
    }

    @Override
    public void startDocument() {
        super.startDocument();
        this.currentChemModel = this.currentChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
    }

    @Override
    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        this.logger.debug("PMP element: name");
        super.startElement(xpath, uri, local, raw, atts);
    }

    @Override
    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        String s = new String(ch, start, length).trim();
        this.logger.debug("Start PMP chardata (" + this.CurrentElement + ") :" + s);
        this.logger.debug(" ElTitle: " + this.elementTitle);
        if (xpath.toString().endsWith("string/") && this.BUILTIN.equals("spacegroup")) {
            String sg = "P1";
            if ("P 21 21 21 (1)".equals(s)) {
                sg = "P 2_1 2_1 2_1";
            }
            ((ICrystal)this.currentMolecule).setSpaceGroup(sg);
        } else if (xpath.toString().endsWith("floatArray/") && (this.elementTitle.equals("a") || this.elementTitle.equals("b") || this.elementTitle.equals("c"))) {
            StringTokenizer st = new StringTokenizer(s);
            if (st.countTokens() > 2) {
                if (this.elementTitle.equals("a")) {
                    ((ICrystal)this.currentMolecule).setA(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                } else if (this.elementTitle.equals("b")) {
                    ((ICrystal)this.currentMolecule).setB(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                } else if (this.elementTitle.equals("c")) {
                    ((ICrystal)this.currentMolecule).setC(new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
                }
            } else {
                this.logger.debug("PMP Convention error: incorrect number of cell axis fractions!");
            }
        } else {
            super.characterData(xpath, ch, start, length);
        }
        this.logger.debug("End PMP chardata");
    }
}

