/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.output.spi;

import it.geosolutions.imageio.stream.output.FileImageOutputStreamExtImpl;
import it.geosolutions.imageio.utilities.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.stream.ImageOutputStream;

public class URLImageOutputStreamSpi
extends ImageOutputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.output.spi");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class outputClass = URL.class;

    public URLImageOutputStreamSpi() {
        super(vendorName, version, outputClass);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Service provider for writing to a URL";
    }

    @Override
    public ImageOutputStream createOutputStreamInstance(Object output, boolean useCache, File cacheDir) {
        block8: {
            if (!(output instanceof URL)) {
                return null;
            }
            URL outputURL = (URL)output;
            if (outputURL.getProtocol().compareToIgnoreCase("file") == 0) {
                try {
                    File tempFile = Utilities.urlToFile(outputURL);
                    return new FileImageOutputStreamExtImpl(tempFile);
                }
                catch (UnsupportedEncodingException e2) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                    }
                }
                catch (FileNotFoundException e3) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e3.getLocalizedMessage(), e3);
                    }
                }
                catch (IOException e4) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block8;
                    LOGGER.log(Level.FINE, e4.getLocalizedMessage(), e4);
                }
            }
        }
        return null;
    }
}

