/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.io.output;

import it.geosolutions.io.output.MathUtils;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BitOutputStream
extends FilterOutputStream {
    private static final byte bufferSize = 32;
    int bitbuffer;
    int count;

    public BitOutputStream(OutputStream out) {
        super(out);
    }

    public void write(byte b2, int nbits) throws IOException {
        if (nbits <= 0 || nbits > 8) {
            return;
        }
        byte remainingBits = 0;
        byte bits2Write = b2;
        if (this.count + nbits > 32) {
            remainingBits = (byte)(32 - this.count);
            bits2Write = (byte)(bits2Write >>> nbits - remainingBits);
            this.bitbuffer <<= remainingBits;
            this.bitbuffer |= bits2Write & MathUtils.bitMask[remainingBits];
            this.count += remainingBits;
            this.flush();
            bits2Write = (byte)(b2 & MathUtils.bitMask[nbits -= remainingBits]);
        }
        this.bitbuffer <<= nbits;
        this.bitbuffer |= bits2Write & MathUtils.bitMask[nbits];
        this.count += nbits;
    }

    @Override
    public void flush() throws IOException {
        byte[] byte2Write = MathUtils.bitVector2ByteVector(this.bitbuffer, this.count);
        if (byte2Write != null) {
            this.out.write(byte2Write);
        }
        this.count = 0;
        this.bitbuffer = 0;
    }

    public void write(boolean bit) throws IOException {
        byte b2 = bit ? (byte)1 : 0;
        this.write(b2, 1);
    }

    public void write(int bitVect, int length) throws IOException {
        byte[] byteVect = MathUtils.bitVector2ByteVector(bitVect, length);
        if (byteVect == null) {
            return;
        }
        if (length <= 8) {
            this.write(byteVect[0], length);
            return;
        }
        int lastOctetNumBits = length - (byte)Math.floor((double)length / 8.0) * 8;
        if (lastOctetNumBits == 0) {
            lastOctetNumBits = 8;
        }
        for (int i = 0; i < byteVect.length; ++i) {
            if (i == 0) {
                this.write(byteVect[i], lastOctetNumBits);
                continue;
            }
            this.write(byteVect[i], 8);
        }
    }

    @Override
    public void write(int b2) throws IOException {
        this.write(b2, 8);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.flush();
        this.out.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.flush();
        this.out.write(b2, off, len);
    }
}

