/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

public class AlgebraOpImage
extends PointOpImage {
    private static final Logger LOGGER = Logger.getLogger(AlgebraOpImage.class.toString());
    private final boolean hasNoData;
    private Range noData;
    private byte[] byteLookupTable;
    private boolean[] booleanLookupTable;
    private final boolean hasROI;
    private ROI roi;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private AlgebraDescriptor.Operator op;
    private final int numSrc;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;
    private byte nullValueByte;
    private short nullValueShort;
    private int nullValueInt;
    private float nullValueFloat;
    private double nullValueDouble;
    private final int numTotalSrc;

    public AlgebraOpImage(Map config, ImageLayout layout, AlgebraDescriptor.Operator op, ROI srcROI, Range noData, double destinationNoData, RenderedImage ... sources) {
        super(AlgebraOpImage.vectorize(sources), layout, config, true);
        SampleModel sm;
        int numBandsDst;
        if (op == null) {
            throw new IllegalArgumentException("Operation Not Defined");
        }
        this.op = op;
        int numSrc = sources.length;
        if (!op.supportsMultipleValues() && numSrc > 1) {
            LOGGER.warning("Multiple sources found, only the first one will be used");
            numSrc = 1;
        }
        this.numSrc = numSrc;
        this.numTotalSrc = sources.length;
        int srcDataType = sources[0].getSampleModel().getDataType();
        int dataType = this.getSampleModel().getDataType();
        if (!op.isDataTypeSupported(srcDataType)) {
            throw new IllegalArgumentException("This operation does not support DataType: " + srcDataType);
        }
        int[] numBandsSrc = new int[numSrc];
        boolean srcBandsToFill = false;
        int numBands0 = sources[0].getSampleModel().getNumBands();
        for (int i = 1; i < numSrc; ++i) {
            numBandsSrc[i] = sources[i].getSampleModel().getNumBands();
            if (numBandsSrc[i] == numBands0) continue;
            srcBandsToFill = true;
            break;
        }
        if (layout != null && layout.isValid(256) && (numBandsDst = (sm = layout.getSampleModel(null)).getNumBands()) > 1 && srcBandsToFill) {
            int minBandsNum = Integer.MAX_VALUE;
            for (int i = 0; i < numSrc; ++i) {
                int bands = numBandsSrc[i];
                if (bands >= minBandsNum) continue;
                minBandsNum = bands;
            }
            if ((numBandsDst = Math.min(minBandsNum, numBandsDst)) != this.sampleModel.getNumBands()) {
                this.sampleModel = RasterFactory.createComponentSampleModel(sm, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), numBandsDst);
                if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                    this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, config);
                }
            }
        }
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte(destinationNoData);
                this.nullValueByte = ImageUtil.clampRoundByte(op.getNullValue());
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort(destinationNoData);
                this.nullValueShort = ImageUtil.clampRoundUShort(op.getNullValue());
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort(destinationNoData);
                this.nullValueShort = ImageUtil.clampRoundShort(op.getNullValue());
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt(destinationNoData);
                this.nullValueInt = ImageUtil.clampRoundInt(op.getNullValue());
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat(destinationNoData);
                this.nullValueFloat = ImageUtil.clampFloat(op.getNullValue());
                break;
            }
            case 5: {
                this.destNoDataDouble = destinationNoData;
                this.nullValueDouble = op.getNullValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
            if (dataType == 0) {
                this.booleanLookupTable = new boolean[256];
                this.byteLookupTable = new byte[256];
                for (int i = 0; i < this.byteLookupTable.length; ++i) {
                    byte value = (byte)i;
                    this.booleanLookupTable[i] = !noData.contains(value);
                    this.byteLookupTable[i] = this.booleanLookupTable[i] ? value : this.nullValueByte;
                }
            }
        } else {
            this.hasNoData = false;
        }
        if (srcROI != null) {
            this.hasROI = true;
            this.roi = srcROI;
        } else {
            this.hasROI = false;
            this.roi = null;
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
        this.permitInPlaceOperation();
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        if (!this.hasROI || this.hasROI && this.roi.intersects(destRect)) {
            RasterFormatTag[] formatTags = this.getFormatTags();
            RasterAccessor[] rasterArray = new RasterAccessor[this.numSrc];
            for (int i = 0; i < this.numSrc; ++i) {
                rasterArray[i] = new RasterAccessor(sources[i], destRect, formatTags[i], this.getSourceImage(i).getColorModel());
            }
            RasterAccessor d2 = new RasterAccessor(dest, destRect, formatTags[this.numTotalSrc], this.getColorModel());
            switch (d2.getDataType()) {
                case 0: {
                    this.computeRectByte(rasterArray, d2);
                    break;
                }
                case 1: {
                    this.computeRectUShort(rasterArray, d2);
                    break;
                }
                case 2: {
                    this.computeRectShort(rasterArray, d2);
                    break;
                }
                case 3: {
                    this.computeRectInt(rasterArray, d2);
                    break;
                }
                case 4: {
                    this.computeRectFloat(rasterArray, d2);
                    break;
                }
                case 5: {
                    this.computeRectDouble(rasterArray, d2);
                }
            }
            if (d2.needsClamping()) {
                d2.clampDataArrays();
            }
            d2.copyDataToRaster();
        } else {
            int numBands = dest.getNumBands();
            int destDataType = dest.getSampleModel().getDataType();
            double[] destNoData = new double[numBands];
            block16: for (int i = 0; i < numBands; ++i) {
                switch (destDataType) {
                    case 0: {
                        destNoData[i] = this.destNoDataByte;
                        continue block16;
                    }
                    case 1: 
                    case 2: {
                        destNoData[i] = this.destNoDataShort;
                        continue block16;
                    }
                    case 3: {
                        destNoData[i] = this.destNoDataInt;
                        continue block16;
                    }
                    case 4: {
                        destNoData[i] = this.destNoDataFloat;
                        continue block16;
                    }
                    case 5: {
                        destNoData[i] = this.destNoDataDouble;
                    }
                }
            }
            ImageUtil.fillBackground(dest, destRect, destNoData);
        }
    }

    private void computeRectByte(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        int result = 0;
        int inputData = 0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        byte[][] srcData = new byte[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        if (this.caseA) {
            for (int b2 = 0; b2 < bands; ++b2) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getByteDataArray(b2);
                    srcLineOffset[i] = srcBandOffsets[i][b2];
                }
                byte[] d2 = dData[b2];
                int dLineOffset = dBandOffsets[b2];
                for (int h2 = 0; h2 < dheight; ++h2) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]) & 0xFF;
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]] & 0xFF;
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d2[dPixelOffset] = (byte)((result << 23 >> 31 | result) & 0xFF);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < bands; ++b3) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getByteDataArray(b3);
                    srcLineOffset[i] = srcBandOffsets[i][b3];
                }
                byte[] d3 = dData[b3];
                int dLineOffset = dBandOffsets[b3];
                for (int h3 = 0; h3 < dheight; ++h3) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roi.contains(x0, y0)) {
                            d3[dPixelOffset] = this.destNoDataByte;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]) & 0xFF;
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]] & 0xFF;
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d3[dPixelOffset] = (byte)((result << 23 >> 31 | result) & 0xFF);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            int sourceValue = 0;
            boolean isValidData = false;
            for (int b4 = 0; b4 < bands; ++b4) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getByteDataArray(b4);
                    srcLineOffset[i] = srcBandOffsets[i][b4];
                }
                byte[] d4 = dData[b4];
                int dLineOffset = dBandOffsets[b4];
                for (int h4 = 0; h4 < dheight; ++h4) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]] & 0xFF;
                        result = this.byteLookupTable[sourceValue] & 0xFF;
                        if (isValidData |= this.booleanLookupTable[sourceValue]) {
                            result = this.op.calculate(srcData[0][srcPixelOffset[0]]) & 0xFF;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]] & 0xFF;
                            isValidData |= this.booleanLookupTable[sourceValue];
                            inputData = this.byteLookupTable[sourceValue] & 0xFF;
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d4[dPixelOffset] = this.destNoDataByte;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d4[dPixelOffset] = (byte)((result << 23 >> 31 | result) & 0xFF);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            int sourceValue = 0;
            boolean isValidData = false;
            for (int b5 = 0; b5 < bands; ++b5) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getByteDataArray(b5);
                    srcLineOffset[i] = srcBandOffsets[i][b5];
                }
                byte[] d5 = dData[b5];
                int dLineOffset = dBandOffsets[b5];
                for (int h5 = 0; h5 < dheight; ++h5) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d5[dPixelOffset] = this.destNoDataByte;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]] & 0xFF;
                        result = this.byteLookupTable[sourceValue] & 0xFF;
                        if (isValidData |= this.booleanLookupTable[sourceValue]) {
                            result = this.op.calculate(srcData[0][srcPixelOffset[0]]) & 0xFF;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]] & 0xFF;
                            isValidData |= this.booleanLookupTable[sourceValue];
                            inputData = this.byteLookupTable[sourceValue] & 0xFF;
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d5[dPixelOffset] = this.destNoDataByte;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d5[dPixelOffset] = (byte)((result << 23 >> 31 | result) & 0xFF);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        int result = 0;
        int inputData = 0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        short[][] srcData = new short[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        short sourceValue = 0;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b2 = 0; b2 < bands; ++b2) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b2);
                    srcLineOffset[i] = srcBandOffsets[i][b2];
                }
                short[] d2 = dData[b2];
                int dLineOffset = dBandOffsets[b2];
                for (int h2 = 0; h2 < dheight; ++h2) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(this.op.isUshortSupported(), srcData[0][srcPixelOffset[0]]) & 0xFFFF;
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]] & 0xFFFF;
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d2[dPixelOffset] = ImageUtil.clampUShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < bands; ++b3) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b3);
                    srcLineOffset[i] = srcBandOffsets[i][b3];
                }
                short[] d3 = dData[b3];
                int dLineOffset = dBandOffsets[b3];
                for (int h3 = 0; h3 < dheight; ++h3) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roi.contains(x0, y0)) {
                            d3[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(this.op.isUshortSupported(), srcData[0][srcPixelOffset[0]]) & 0xFFFF;
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]] & 0xFFFF;
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d3[dPixelOffset] = ImageUtil.clampUShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b4 = 0; b4 < bands; ++b4) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b4);
                    srcLineOffset[i] = srcBandOffsets[i][b4];
                }
                short[] d4 = dData[b4];
                int dLineOffset = dBandOffsets[b4];
                for (int h4 = 0; h4 < dheight; ++h4) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(this.op.isUshortSupported(), srcData[0][srcPixelOffset[0]]) & 0xFFFF;
                            isValidData = true;
                        } else {
                            result = this.nullValueShort;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue & 0xFFFF;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueShort;
                            }
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d4[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d4[dPixelOffset] = ImageUtil.clampUShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < bands; ++b5) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b5);
                    srcLineOffset[i] = srcBandOffsets[i][b5];
                }
                short[] d5 = dData[b5];
                int dLineOffset = dBandOffsets[b5];
                for (int h5 = 0; h5 < dheight; ++h5) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d5[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(this.op.isUshortSupported(), srcData[0][srcPixelOffset[0]]) & 0xFFFF;
                            isValidData = true;
                        } else {
                            result = this.nullValueShort;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue & 0xFFFF;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueShort;
                            }
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d5[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d5[dPixelOffset] = ImageUtil.clampUShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        int result = 0;
        short inputData = 0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        short[][] srcData = new short[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        short sourceValue = 0;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b2 = 0; b2 < bands; ++b2) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b2);
                    srcLineOffset[i] = srcBandOffsets[i][b2];
                }
                short[] d2 = dData[b2];
                int dLineOffset = dBandOffsets[b2];
                for (int h2 = 0; h2 < dheight; ++h2) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(false, srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]];
                            result = this.op.calculate(new int[]{result, inputData});
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d2[dPixelOffset] = ImageUtil.clampShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < bands; ++b3) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b3);
                    srcLineOffset[i] = srcBandOffsets[i][b3];
                }
                short[] d3 = dData[b3];
                int dLineOffset = dBandOffsets[b3];
                for (int h3 = 0; h3 < dheight; ++h3) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roi.contains(x0, y0)) {
                            d3[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(false, srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]];
                            result = this.op.calculate(new int[]{result, inputData});
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d3[dPixelOffset] = ImageUtil.clampShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b4 = 0; b4 < bands; ++b4) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b4);
                    srcLineOffset[i] = srcBandOffsets[i][b4];
                }
                short[] d4 = dData[b4];
                int dLineOffset = dBandOffsets[b4];
                for (int h4 = 0; h4 < dheight; ++h4) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(false, sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueShort;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueShort;
                            }
                            result = this.op.calculate(new int[]{result, inputData});
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d4[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d4[dPixelOffset] = ImageUtil.clampShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < bands; ++b5) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getShortDataArray(b5);
                    srcLineOffset[i] = srcBandOffsets[i][b5];
                }
                short[] d5 = dData[b5];
                int dLineOffset = dBandOffsets[b5];
                for (int h5 = 0; h5 < dheight; ++h5) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d5[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(false, sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueShort;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueShort;
                            }
                            result = this.op.calculate(new int[]{result, inputData});
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d5[dPixelOffset] = this.destNoDataShort;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d5[dPixelOffset] = ImageUtil.clampShort(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        long result = 0L;
        int inputData = 0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        int[][] srcData = new int[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        int sourceValue = 0;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b2 = 0; b2 < bands; ++b2) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getIntDataArray(b2);
                    srcLineOffset[i] = srcBandOffsets[i][b2];
                }
                int[] d2 = dData[b2];
                int dLineOffset = dBandOffsets[b2];
                for (int h2 = 0; h2 < dheight; ++h2) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]];
                            result = this.op.calculateL(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d2[dPixelOffset] = ImageUtil.clampInt(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < bands; ++b3) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getIntDataArray(b3);
                    srcLineOffset[i] = srcBandOffsets[i][b3];
                }
                int[] d3 = dData[b3];
                int dLineOffset = dBandOffsets[b3];
                for (int h3 = 0; h3 < dheight; ++h3) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roi.contains(x0, y0)) {
                            d3[dPixelOffset] = this.destNoDataInt;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]];
                            result = this.op.calculateL(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d3[dPixelOffset] = ImageUtil.clampInt(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b4 = 0; b4 < bands; ++b4) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getIntDataArray(b4);
                    srcLineOffset[i] = srcBandOffsets[i][b4];
                }
                int[] d4 = dData[b4];
                int dLineOffset = dBandOffsets[b4];
                for (int h4 = 0; h4 < dheight; ++h4) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueInt;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueInt;
                            }
                            result = this.op.calculateL(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d4[dPixelOffset] = this.destNoDataInt;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d4[dPixelOffset] = ImageUtil.clampInt(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < bands; ++b5) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getIntDataArray(b5);
                    srcLineOffset[i] = srcBandOffsets[i][b5];
                }
                int[] d5 = dData[b5];
                int dLineOffset = dBandOffsets[b5];
                for (int h5 = 0; h5 < dheight; ++h5) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d5[dPixelOffset] = this.destNoDataInt;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueInt;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueInt;
                            }
                            result = this.op.calculateL(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d5[dPixelOffset] = this.destNoDataInt;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d5[dPixelOffset] = ImageUtil.clampInt(result);
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        float result = 0.0f;
        float inputData = 0.0f;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        float[][] srcData = new float[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        float sourceValue = 0.0f;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b2 = 0; b2 < bands; ++b2) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getFloatDataArray(b2);
                    srcLineOffset[i] = srcBandOffsets[i][b2];
                }
                float[] d2 = dData[b2];
                int dLineOffset = dBandOffsets[b2];
                for (int h2 = 0; h2 < dheight; ++h2) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]];
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d2[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < bands; ++b3) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getFloatDataArray(b3);
                    srcLineOffset[i] = srcBandOffsets[i][b3];
                }
                float[] d3 = dData[b3];
                int dLineOffset = dBandOffsets[b3];
                for (int h3 = 0; h3 < dheight; ++h3) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roi.contains(x0, y0)) {
                            d3[dPixelOffset] = this.destNoDataFloat;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]];
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d3[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b4 = 0; b4 < bands; ++b4) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getFloatDataArray(b4);
                    srcLineOffset[i] = srcBandOffsets[i][b4];
                }
                float[] d4 = dData[b4];
                int dLineOffset = dBandOffsets[b4];
                for (int h4 = 0; h4 < dheight; ++h4) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueFloat;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueFloat;
                            }
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d4[dPixelOffset] = this.destNoDataFloat;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d4[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < bands; ++b5) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getFloatDataArray(b5);
                    srcLineOffset[i] = srcBandOffsets[i][b5];
                }
                float[] d5 = dData[b5];
                int dLineOffset = dBandOffsets[b5];
                for (int h5 = 0; h5 < dheight; ++h5) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d5[dPixelOffset] = this.destNoDataFloat;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueFloat;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueFloat;
                            }
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d5[dPixelOffset] = this.destNoDataFloat;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d5[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterArray, RasterAccessor dst) {
        int[] srcLineStride = new int[this.numSrc];
        int[] srcPixelStride = new int[this.numSrc];
        int[][] srcBandOffsets = new int[this.numSrc][];
        int[] srcLineOffset = new int[this.numSrc];
        int[] srcPixelOffset = new int[this.numSrc];
        for (int i = 0; i < this.numSrc; ++i) {
            srcLineStride[i] = rasterArray[i].getScanlineStride();
            srcPixelStride[i] = rasterArray[i].getPixelStride();
            srcBandOffsets[i] = rasterArray[i].getBandOffsets();
        }
        double result = 0.0;
        double inputData = 0.0;
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int bands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        double[][] srcData = new double[this.numSrc][];
        int x0 = 0;
        int y0 = 0;
        int srcX = rasterArray[0].getX();
        int srcY = rasterArray[0].getY();
        double sourceValue = 0.0;
        boolean isValidData = false;
        if (this.caseA) {
            for (int b2 = 0; b2 < bands; ++b2) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getDoubleDataArray(b2);
                    srcLineOffset[i] = srcBandOffsets[i][b2];
                }
                double[] d2 = dData[b2];
                int dLineOffset = dBandOffsets[b2];
                for (int h2 = 0; h2 < dheight; ++h2) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]];
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d2[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b3 = 0; b3 < bands; ++b3) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getDoubleDataArray(b3);
                    srcLineOffset[i] = srcBandOffsets[i][b3];
                }
                double[] d3 = dData[b3];
                int dLineOffset = dBandOffsets[b3];
                for (int h3 = 0; h3 < dheight; ++h3) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        x0 = srcX + w;
                        y0 = srcY + h3;
                        if (!this.roi.contains(x0, y0)) {
                            d3[dPixelOffset] = this.destNoDataDouble;
                            dPixelOffset += dPixelStride;
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            continue;
                        }
                        result = this.op.calculate(srcData[0][srcPixelOffset[0]]);
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            inputData = srcData[i][srcPixelOffset[i]];
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        d3[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int b4 = 0; b4 < bands; ++b4) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getDoubleDataArray(b4);
                    srcLineOffset[i] = srcBandOffsets[i][b4];
                }
                double[] d4 = dData[b4];
                int dLineOffset = dBandOffsets[b4];
                for (int h4 = 0; h4 < dheight; ++h4) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        isValidData = false;
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueDouble;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (int i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueDouble;
                            }
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d4[dPixelOffset] = this.destNoDataDouble;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d4[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        } else {
            for (int b5 = 0; b5 < bands; ++b5) {
                for (int i = 0; i < this.numSrc; ++i) {
                    srcData[i] = rasterArray[i].getDoubleDataArray(b5);
                    srcLineOffset[i] = srcBandOffsets[i][b5];
                }
                double[] d5 = dData[b5];
                int dLineOffset = dBandOffsets[b5];
                for (int h5 = 0; h5 < dheight; ++h5) {
                    for (int i = 0; i < this.numSrc; ++i) {
                        srcPixelOffset[i] = srcLineOffset[i];
                        int n = i;
                        srcLineOffset[n] = srcLineOffset[n] + srcLineStride[i];
                    }
                    int dPixelOffset = dLineOffset;
                    dLineOffset += dLineStride;
                    for (int w = 0; w < dwidth; ++w) {
                        int i;
                        isValidData = false;
                        x0 = srcX + w;
                        y0 = srcY + h5;
                        if (!this.roi.contains(x0, y0)) {
                            for (i = 0; i < this.numSrc; ++i) {
                                int n = i;
                                srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                            }
                            d5[dPixelOffset] = this.destNoDataDouble;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        sourceValue = srcData[0][srcPixelOffset[0]];
                        if (!this.noData.contains(sourceValue)) {
                            result = this.op.calculate(sourceValue);
                            isValidData = true;
                        } else {
                            result = this.nullValueDouble;
                        }
                        srcPixelOffset[0] = srcPixelOffset[0] + srcPixelStride[0];
                        for (i = 1; i < this.numSrc; ++i) {
                            sourceValue = srcData[i][srcPixelOffset[i]];
                            if (!this.noData.contains(sourceValue)) {
                                inputData = sourceValue;
                                isValidData = true;
                            } else {
                                inputData = this.nullValueDouble;
                            }
                            result = this.op.calculate(result, inputData);
                            int n = i;
                            srcPixelOffset[n] = srcPixelOffset[n] + srcPixelStride[i];
                        }
                        if (!isValidData) {
                            d5[dPixelOffset] = this.destNoDataDouble;
                            dPixelOffset += dPixelStride;
                            continue;
                        }
                        d5[dPixelOffset] = result;
                        dPixelOffset += dPixelStride;
                    }
                }
            }
        }
    }

    private static Vector<RenderedImage> vectorize(RenderedImage[] sources) {
        Vector<RenderedImage> vec = new Vector<RenderedImage>(sources.length);
        for (RenderedImage image : sources) {
            if (image == null) continue;
            vec.add(image);
        }
        if (vec.isEmpty()) {
            return null;
        }
        return vec;
    }
}

