/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.swing.JPanel;

class ZoomableImageDisplay
extends JPanel {
    protected RenderedImage image;
    protected RenderedImage rescaledImage;
    protected double scale = 1.0;
    protected boolean tileGridVisible = true;
    protected boolean useRescaled = false;

    public ZoomableImageDisplay() {
        this.setLayout(null);
    }

    public ZoomableImageDisplay(RenderedImage image) {
        this();
        this.setImage(image);
    }

    public void setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be a positive number");
        }
        this.scale = scale;
        this.refreshComponent(this.useRescaled && this.rescaledImage != null ? this.rescaledImage : this.image);
    }

    public double getScale() {
        return this.scale;
    }

    public void setImage(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Image displayed cannot be null");
        }
        this.useRescaled = false;
        this.image = image;
        this.refreshComponent(image);
    }

    public void setRescaledImage(RenderedImage image) {
        this.useRescaled = image != null;
        this.rescaledImage = image;
        if (image != null) {
            this.refreshComponent(image);
        }
    }

    public RenderedImage getImage() {
        return this.image;
    }

    private void refreshComponent(RenderedImage image) {
        if (image != null) {
            int w = (int)Math.ceil((double)image.getWidth() * this.scale);
            int h2 = (int)Math.ceil((double)image.getHeight() * this.scale);
            int minX = (int)Math.ceil((double)image.getMinX() * this.scale);
            int minY = (int)Math.ceil((double)image.getMinY() * this.scale);
            Insets insets = this.getInsets();
            Dimension dim = new Dimension(w + insets.left + insets.right + minX, h2 + insets.top + insets.bottom + minY);
            this.setPreferredSize(dim);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public synchronized void paintComponent(Graphics g2) {
        RenderedImage image = this.image;
        if (this.useRescaled && this.rescaledImage != null) {
            image = this.rescaledImage;
        }
        if (g2 instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g2;
            Rectangle clipBounds = g2d.getClipBounds();
            g2d.setColor(this.getBackground());
            g2d.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            if (image == null) {
                return;
            }
            try {
                g2d.drawRenderedImage(image, AffineTransform.getScaleInstance(this.scale, this.scale));
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            if (this.tileGridVisible) {
                int mintx;
                g2d.setColor(Color.WHITE);
                g2d.setXORMode(Color.BLACK);
                int x = (int)Math.floor((double)image.getTileGridXOffset() * this.scale);
                int y = (int)Math.floor((double)image.getTileGridYOffset() * this.scale);
                int th = (int)Math.round((double)image.getTileHeight() * this.scale);
                int tw = (int)Math.round((double)image.getTileWidth() * this.scale);
                int xCount = image.getNumXTiles();
                int yCount = image.getNumYTiles();
                int minty = image.getMinTileY();
                for (int i = mintx = image.getMinTileX(); i < xCount + mintx + 1; ++i) {
                    g2d.drawLine(x + tw * i, y + th * minty, x + tw * i, y + th * (yCount + minty));
                }
                for (int j = minty; j < yCount + minty + 1; ++j) {
                    g2d.drawLine(x + mintx * tw, y + th * j, x + tw * (xCount + mintx), y + th * j);
                }
            }
        }
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean visible) {
        this.tileGridVisible = visible;
        this.repaint();
    }

    public boolean isUseRescaled() {
        return this.useRescaled;
    }

    public void setUseRescaled(boolean useRescaled) {
        this.useRescaled = useRescaled;
    }
}

