/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import java.awt.Point;
import java.io.IOException;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.FileBitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public abstract class BitstreamReaderAgent
implements CodedCBlkDataSrcDec {
    protected DecoderSpecs decSpec;
    protected boolean[] derived = null;
    protected int[] gb = null;
    protected StdDequantizerParams[] params = null;
    public static final char OPT_PREFIX = 'B';
    private static final String[][] pinfo = null;
    protected int[] mdl;
    protected final int nc;
    protected int targetRes;
    protected SubbandSyn[] subbTrees;
    protected final int imgW;
    protected final int imgH;
    protected final int ax;
    protected final int ay;
    protected final int px;
    protected final int py;
    protected final int[] offX;
    protected final int[] offY;
    protected final int[] culx;
    protected final int[] culy;
    protected final int ntW;
    protected final int ntH;
    protected final int ntX;
    protected final int ntY;
    protected final int nt;
    protected int ctX;
    protected int ctY;
    protected final HeaderDecoder hd;
    protected int tnbytes;
    protected int anbytes;
    protected float trate;
    protected float arate;

    protected BitstreamReaderAgent(HeaderDecoder hd, DecoderSpecs decSpec) {
        this.decSpec = decSpec;
        this.hd = hd;
        this.nc = hd.getNumComps();
        this.offX = new int[this.nc];
        this.offY = new int[this.nc];
        this.culx = new int[this.nc];
        this.culy = new int[this.nc];
        this.imgW = hd.getImgWidth();
        this.imgH = hd.getImgHeight();
        this.ax = hd.getImgULX();
        this.ay = hd.getImgULY();
        Point co = hd.getTilingOrigin(null);
        this.px = co.x;
        this.py = co.y;
        this.ntW = hd.getNomTileWidth();
        this.ntH = hd.getNomTileHeight();
        this.ntX = (this.ax + this.imgW - this.px + this.ntW - 1) / this.ntW;
        this.ntY = (this.ay + this.imgH - this.py + this.ntH - 1) / this.ntH;
        this.nt = this.ntX * this.ntY;
    }

    public final int getCbULX() {
        return this.hd.getCbULX();
    }

    public int getCbULY() {
        return this.hd.getCbULY();
    }

    public final int getNumComps() {
        return this.nc;
    }

    public final int getCompSubsX(int c2) {
        return this.hd.getCompSubsX(c2);
    }

    public int getCompSubsY(int c2) {
        return this.hd.getCompSubsY(c2);
    }

    public int getTileWidth(int rl) {
        int mindl = this.decSpec.dls.getMinInTile(this.getTileIdx());
        if (rl > mindl) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int dl = mindl - rl;
        int ctulx = this.ctX == 0 ? this.ax : this.px + this.ctX * this.ntW;
        int ntulx = this.ctX < this.ntX - 1 ? this.px + (this.ctX + 1) * this.ntW : this.ax + this.imgW;
        dl = 1 << dl;
        return (ntulx + dl - 1) / dl - (ctulx + dl - 1) / dl;
    }

    public int getTileHeight(int rl) {
        int mindl = this.decSpec.dls.getMinInTile(this.getTileIdx());
        if (rl > mindl) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int dl = mindl - rl;
        int ctuly = this.ctY == 0 ? this.ay : this.py + this.ctY * this.ntH;
        int ntuly = this.ctY < this.ntY - 1 ? this.py + (this.ctY + 1) * this.ntH : this.ay + this.imgH;
        dl = 1 << dl;
        return (ntuly + dl - 1) / dl - (ctuly + dl - 1) / dl;
    }

    public int getImgWidth(int rl) {
        int mindl = this.decSpec.dls.getMin();
        if (rl > mindl) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int dl = 1 << mindl - rl;
        return (this.ax + this.imgW + dl - 1) / dl - (this.ax + dl - 1) / dl;
    }

    public int getImgHeight(int rl) {
        int mindl = this.decSpec.dls.getMin();
        if (rl > mindl) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int dl = 1 << mindl - rl;
        return (this.ay + this.imgH + dl - 1) / dl - (this.ay + dl - 1) / dl;
    }

    public int getImgULX(int rl) {
        int mindl = this.decSpec.dls.getMin();
        if (rl > mindl) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int dl = 1 << mindl - rl;
        return (this.ax + dl - 1) / dl;
    }

    public int getImgULY(int rl) {
        int mindl = this.decSpec.dls.getMin();
        if (rl > mindl) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int dl = 1 << mindl - rl;
        return (this.ay + dl - 1) / dl;
    }

    public final int getTileCompWidth(int t, int c2, int rl) {
        int tIdx = this.getTileIdx();
        if (t != tIdx) {
            throw new Error("Asking the tile-component width of a tile different  from the current one.");
        }
        int ntulx = this.ctX < this.ntX - 1 ? this.px + (this.ctX + 1) * this.ntW : this.ax + this.imgW;
        ntulx = (ntulx + this.hd.getCompSubsX(c2) - 1) / this.hd.getCompSubsX(c2);
        int dl = 1 << this.mdl[c2] - rl;
        return (ntulx + dl - 1) / dl - (this.culx[c2] + dl - 1) / dl;
    }

    public final int getTileCompHeight(int t, int c2, int rl) {
        int tIdx = this.getTileIdx();
        if (t != tIdx) {
            throw new Error("Asking the tile-component width of a tile different  from the current one.");
        }
        int ntuly = this.ctY < this.ntY - 1 ? this.py + (this.ctY + 1) * this.ntH : this.ay + this.imgH;
        ntuly = (ntuly + this.hd.getCompSubsY(c2) - 1) / this.hd.getCompSubsY(c2);
        int dl = 1 << this.mdl[c2] - rl;
        return (ntuly + dl - 1) / dl - (this.culy[c2] + dl - 1) / dl;
    }

    public final int getCompImgWidth(int c2, int rl) {
        int sx = (this.ax + this.hd.getCompSubsX(c2) - 1) / this.hd.getCompSubsX(c2);
        int ex = (this.ax + this.imgW + this.hd.getCompSubsX(c2) - 1) / this.hd.getCompSubsX(c2);
        int dl = 1 << this.decSpec.dls.getMinInComp(c2) - rl;
        return (ex + dl - 1) / dl - (sx + dl - 1) / dl;
    }

    public final int getCompImgHeight(int c2, int rl) {
        int sy = (this.ay + this.hd.getCompSubsY(c2) - 1) / this.hd.getCompSubsY(c2);
        int ey = (this.ay + this.imgH + this.hd.getCompSubsY(c2) - 1) / this.hd.getCompSubsY(c2);
        int dl = 1 << this.decSpec.dls.getMinInComp(c2) - rl;
        return (ey + dl - 1) / dl - (sy + dl - 1) / dl;
    }

    public abstract void setTile(int var1, int var2);

    public abstract void nextTile();

    public final Point getTile(Point co) {
        if (co != null) {
            co.x = this.ctX;
            co.y = this.ctY;
            return co;
        }
        return new Point(this.ctX, this.ctY);
    }

    public final int getTileIdx() {
        return this.ctY * this.ntX + this.ctX;
    }

    public final int getResULX(int c2, int rl) {
        int dl = this.mdl[c2] - rl;
        if (dl < 0) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int tx0 = Math.max(this.px + this.ctX * this.ntW, this.ax);
        int tcx0 = (int)Math.ceil((double)tx0 / (double)this.getCompSubsX(c2));
        return (int)Math.ceil((double)tcx0 / (double)(1 << dl));
    }

    public final int getResULY(int c2, int rl) {
        int dl = this.mdl[c2] - rl;
        if (dl < 0) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int ty0 = Math.max(this.py + this.ctY * this.ntH, this.ay);
        int tcy0 = (int)Math.ceil((double)ty0 / (double)this.getCompSubsY(c2));
        return (int)Math.ceil((double)tcy0 / (double)(1 << dl));
    }

    public final Point getNumTiles(Point co) {
        if (co != null) {
            co.x = this.ntX;
            co.y = this.ntY;
            return co;
        }
        return new Point(this.ntX, this.ntY);
    }

    public final int getNumTiles() {
        return this.ntX * this.ntY;
    }

    public final SubbandSyn getSynSubbandTree(int t, int c2) {
        if (t != this.getTileIdx()) {
            throw new IllegalArgumentException("Can not request subband tree of a different tile than the current one");
        }
        if (c2 < 0 || c2 >= this.nc) {
            throw new IllegalArgumentException("Component index out of range");
        }
        return this.subbTrees[c2];
    }

    public static BitstreamReaderAgent createInstance(RandomAccessIO in, HeaderDecoder hd, J2KImageReadParamJava j2krparam, DecoderSpecs decSpec, boolean cdstrInfo, HeaderInfo hi) throws IOException {
        return new FileBitstreamReaderAgent(hd, in, decSpec, j2krparam, cdstrInfo, hi);
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public final int getPPX(int t, int c2, int rl) {
        return this.decSpec.pss.getPPX(t, c2, rl);
    }

    public final int getPPY(int t, int c2, int rl) {
        return this.decSpec.pss.getPPY(t, c2, rl);
    }

    protected void initSubbandsFields(int c2, SubbandSyn sb) {
        int t = this.getTileIdx();
        int rl = sb.resLvl;
        int cbw = this.decSpec.cblks.getCBlkWidth((byte)3, t, c2);
        int cbh = this.decSpec.cblks.getCBlkHeight((byte)3, t, c2);
        if (!sb.isNode) {
            if (this.hd.precinctPartitionUsed()) {
                int ppxExp = MathUtil.log2(this.getPPX(t, c2, rl));
                int ppyExp = MathUtil.log2(this.getPPY(t, c2, rl));
                int cbwExp = MathUtil.log2(cbw);
                int cbhExp = MathUtil.log2(cbh);
                switch (sb.resLvl) {
                    case 0: {
                        sb.nomCBlkW = cbwExp < ppxExp ? 1 << cbwExp : 1 << ppxExp;
                        sb.nomCBlkH = cbhExp < ppyExp ? 1 << cbhExp : 1 << ppyExp;
                        break;
                    }
                    default: {
                        sb.nomCBlkW = cbwExp < ppxExp - 1 ? 1 << cbwExp : 1 << ppxExp - 1;
                        sb.nomCBlkH = cbhExp < ppyExp - 1 ? 1 << cbhExp : 1 << ppyExp - 1;
                        break;
                    }
                }
            } else {
                sb.nomCBlkW = cbw;
                sb.nomCBlkH = cbh;
            }
            if (sb.numCb == null) {
                sb.numCb = new Point();
            }
            if (sb.w == 0 || sb.h == 0) {
                sb.numCb.x = 0;
                sb.numCb.y = 0;
            } else {
                int cb0x = this.getCbULX();
                int cb0y = this.getCbULY();
                int acb0x = cb0x;
                int acb0y = cb0y;
                switch (sb.sbandIdx) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        acb0x = 0;
                        break;
                    }
                    case 2: {
                        acb0y = 0;
                        break;
                    }
                    case 3: {
                        acb0x = 0;
                        acb0y = 0;
                        break;
                    }
                    default: {
                        throw new Error("Internal JJ2000 error");
                    }
                }
                if (sb.ulcx - acb0x < 0 || sb.ulcy - acb0y < 0) {
                    throw new IllegalArgumentException("Invalid code-blocks partition origin or image offset in the reference grid.");
                }
                int tmp = sb.ulcx - acb0x + sb.nomCBlkW;
                sb.numCb.x = (tmp + sb.w - 1) / sb.nomCBlkW - (tmp / sb.nomCBlkW - 1);
                tmp = sb.ulcy - acb0y + sb.nomCBlkH;
                sb.numCb.y = (tmp + sb.h - 1) / sb.nomCBlkH - (tmp / sb.nomCBlkH - 1);
            }
            sb.magbits = this.derived[c2] ? this.gb[c2] + (this.params[c2].exp[0][0] - (this.mdl[c2] - sb.level)) - 1 : this.gb[c2] + this.params[c2].exp[sb.resLvl][sb.sbandIdx] - 1;
        } else {
            this.initSubbandsFields(c2, (SubbandSyn)sb.getLL());
            this.initSubbandsFields(c2, (SubbandSyn)sb.getHL());
            this.initSubbandsFields(c2, (SubbandSyn)sb.getLH());
            this.initSubbandsFields(c2, (SubbandSyn)sb.getHH());
        }
    }

    public int getImgRes() {
        return this.targetRes;
    }

    public float getTargetRate() {
        return this.trate;
    }

    public float getActualRate() {
        this.arate = (float)this.anbytes * 8.0f / (float)this.hd.getMaxCompImgWidth() / (float)this.hd.getMaxCompImgHeight();
        return this.arate;
    }

    public int getTargetNbytes() {
        return this.tnbytes;
    }

    public int getActualNbytes() {
        return this.anbytes;
    }

    public int getTilePartULX() {
        return this.hd.getTilingOrigin(null).x;
    }

    public int getTilePartULY() {
        return this.hd.getTilingOrigin(null).y;
    }

    public int getNomTileWidth() {
        return this.hd.getNomTileWidth();
    }

    public int getNomTileHeight() {
        return this.hd.getNomTileHeight();
    }
}

