/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.ReificationConstraint;
import org.chocosolver.solver.constraints.reification.Opposite;
import org.chocosolver.solver.constraints.reification.PropImplied;
import org.chocosolver.solver.constraints.reification.PropImplies;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class Constraint {
    protected final Propagator<?>[] propagators;
    protected BoolVar boolReif;
    private Constraint opposite;
    private Status mStatus;
    private int cidx;
    private String name;
    private boolean enabled = true;

    public Constraint(String name, Propagator<?> ... propagators) {
        if (propagators == null || propagators.length == 0) {
            throw new UnsupportedOperationException("cannot create a constraint without propagators ");
        }
        this.name = name;
        this.propagators = propagators;
        this.mStatus = Status.FREE;
        this.cidx = -1;
        for (Propagator<?> propagator : propagators) {
            propagator.defineIn(this);
        }
        Model model = propagators[0].getModel();
        if (model.getSettings().checkDeclaredConstraints()) {
            HashSet<Constraint> instances = (HashSet<Constraint>)model.getHook("cinstances");
            if (instances == null) {
                instances = new HashSet<Constraint>();
                model.addHook("cinstances", instances);
            }
            instances.add(this);
        }
    }

    public Propagator[] getPropagators() {
        return this.propagators;
    }

    public Propagator<?> getPropagator(int i) {
        return this.propagators[i];
    }

    public ESat isSatisfied() {
        int sat = 0;
        for (Propagator<?> propagator : this.propagators) {
            ESat entail = propagator.isEntailed();
            if (entail.equals((Object)ESat.FALSE)) {
                return entail;
            }
            if (!entail.equals((Object)ESat.TRUE)) continue;
            ++sat;
        }
        if (sat == this.propagators.length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public String toString() {
        return this.name + " (" + Arrays.toString(this.propagators) + ")";
    }

    public final boolean isReified() {
        return this.boolReif != null;
    }

    public void reifyWith(BoolVar bool) {
        Model s2 = this.propagators[0].getModel();
        this.getOpposite();
        if (this.boolReif == null) {
            this.boolReif = bool;
            assert (this.opposite.boolReif == null);
            this.opposite.boolReif = this.boolReif.not();
            if (this.boolReif.isInstantiatedTo(1)) {
                this.post();
            } else if (this.boolReif.isInstantiatedTo(0)) {
                this.opposite.post();
            } else {
                new ReificationConstraint(this.boolReif, this, this.opposite).post();
            }
        } else if (bool != this.boolReif) {
            s2.arithm((IntVar)bool, "=", this.boolReif).post();
        }
    }

    public final BoolVar reify() {
        if (this.boolReif == null) {
            Model model = this.propagators[0].getModel();
            this.reifyWith(model.boolVar(model.generateName("REIF_")));
        }
        return this.boolReif;
    }

    public final void implies(BoolVar r) {
        new Constraint("IMPLYCONSTRAINT", new PropImplies(this, r)).post();
    }

    public final void impliedBy(BoolVar r) {
        if (r.isInstantiatedTo(1)) {
            this.post();
        } else {
            new Constraint("IMPLIEDCONSTRAINT", new PropImplied(r, this)).post();
        }
    }

    public final void post() {
        this.propagators[0].getModel().post(this);
    }

    public final void ignore() {
        assert (this.mStatus == Status.FREE) : "Cannot ignore a posted or reified constraint";
        Model model = this.propagators[0].getModel();
        if (model.getSettings().checkDeclaredConstraints()) {
            HashSet instances = (HashSet)model.getHook("cinstances");
            if (instances == null) {
                instances = new HashSet();
                model.addHook("cinstances", instances);
            }
            instances.remove(this);
        }
    }

    public final void declareAs(Status aStatus, int idx) throws SolverException {
        this.checkNewStatus(aStatus);
        this.mStatus = aStatus;
        this.cidx = idx;
        Model model = this.propagators[0].getModel();
        if (model.getSettings().checkDeclaredConstraints()) {
            HashSet<Constraint> instances = (HashSet<Constraint>)model.getHook("cinstances");
            if (instances == null) {
                instances = new HashSet<Constraint>();
                model.addHook("cinstances", instances);
            }
            if (this.mStatus != Status.FREE) {
                instances.remove(this);
            } else {
                instances.add(this);
            }
        }
    }

    public final void checkNewStatus(Status aStatus) throws SolverException {
        switch (this.mStatus) {
            default: {
                if (aStatus != Status.FREE) break;
                throw new SolverException("Try to remove a constraint which is not known from the model.");
            }
            case POSTED: {
                switch (aStatus) {
                    case POSTED: {
                        throw new SolverException("Try to post a constraint which is already posted in the model.");
                    }
                    case REIFIED: {
                        throw new SolverException("Try to post a constraint which is already reified in the model.");
                    }
                }
                break;
            }
            case REIFIED: {
                switch (aStatus) {
                    case POSTED: {
                        throw new SolverException("Try to reify a constraint which is already posted in the model.");
                    }
                    case REIFIED: {
                        throw new SolverException("Try to reify a constraint which is already reified in the model.");
                    }
                }
            }
        }
    }

    public final Status getStatus() {
        return this.mStatus == Status.FREE && this.opposite != null ? this.opposite.mStatus : this.mStatus;
    }

    public int getCidxInModel() {
        return this.cidx;
    }

    public Constraint getOpposite() {
        if (this.opposite == null) {
            this.setOpposite(this.makeOpposite());
        }
        return this.opposite;
    }

    protected void setOpposite(Constraint opp) {
        this.opposite = opp;
        this.opposite.opposite = this;
    }

    protected Constraint makeOpposite() {
        return new Opposite(this);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public PropagatorPriority computeMaxPriority() {
        int priority = 1;
        for (Propagator<?> p : this.propagators) {
            priority = Math.max(priority, p.getPriority().getValue());
        }
        return PropagatorPriority.get(priority);
    }

    public static Constraint merge(String name, Constraint ... toMerge) {
        ArrayList props = new ArrayList();
        for (Constraint c2 : toMerge) {
            c2.ignore();
            Collections.addAll(props, c2.getPropagators());
        }
        return new Constraint(name, props.toArray(new Propagator[0]));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.propagators[0].getModel().getSolver().isSolving()) {
            throw new SolverException("A constraint enabling state can't be changed during search");
        }
        if (this.enabled != enabled) {
            this.enabled = enabled;
            for (Propagator<?> p : this.propagators) {
                if (p == null) continue;
                p.setEnabled(enabled);
            }
        }
    }

    public static enum Status {
        POSTED,
        REIFIED,
        FREE;

    }
}

