/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.conditions;

import org.chocosolver.solver.constraints.nary.alldifferent.PropAllDiffInst;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class PropCondAllDiffInst
extends PropAllDiffInst {
    private final Condition condition;
    private final boolean mode;

    public PropCondAllDiffInst(IntVar[] variables, Condition c2, boolean mode) {
        super(variables);
        this.condition = c2;
        this.mode = mode;
    }

    @Override
    protected void fixpoint() throws ContradictionException {
        while (this.toCheck.size() > 0) {
            int vidx = this.toCheck.pop();
            if (!this.condition.holdOnVar(((IntVar[])this.vars)[vidx])) continue;
            int val = ((IntVar[])this.vars)[vidx].getValue();
            for (int i = 0; i < this.n; ++i) {
                if (i == vidx || !this.mode && !this.condition.holdOnVar(((IntVar[])this.vars)[i]) || !((IntVar[])this.vars)[i].removeValue(val, this) || !((IntVar[])this.vars)[i].isInstantiated()) continue;
                this.toCheck.push(i);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int nbInst = 0;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbInst;
            if (!this.condition.holdOnVar(((IntVar[])this.vars)[i])) continue;
            for (int j = i + 1; j < ((IntVar[])this.vars).length; ++j) {
                if (!this.condition.holdOnVar(((IntVar[])this.vars)[j]) || !((IntVar[])this.vars)[j].isInstantiated() || ((IntVar[])this.vars)[i].getValue() != ((IntVar[])this.vars)[j].getValue()) continue;
                return ESat.FALSE;
            }
        }
        if (nbInst == ((IntVar[])this.vars).length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

