/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sat;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.List;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.search.loop.monitors.NogoodFromRestarts;
import org.chocosolver.solver.variables.Variable;

public class NogoodStealer {
    public static final NogoodStealer NONE = new NogoodStealer(){

        @Override
        public void add(Model model) {
        }

        @Override
        public synchronized void nogoodStealing(Model model, NogoodFromRestarts caller) {
        }

        @Override
        public <V extends Variable> V getById(V var, Model model) {
            return var;
        }
    };
    private final List<Model> models = new ArrayList<Model>();
    private final TIntIntHashMap id2pos = new TIntIntHashMap(10, 0.5f, -1, -1);

    public void add(Model model) {
        assert (this.valid(model)) : "Cannot share nogoods between non equivalent models";
        this.models.add(model);
    }

    private boolean valid(Model model) {
        if (this.models.size() > 0) {
            Variable[] vars1;
            Variable[] vars0 = this.models.get(0).getVars();
            if (vars0.length == (vars1 = model.getVars()).length) {
                for (int i = 0; i < vars0.length; ++i) {
                    if (vars0[i].getId() == vars1[i].getId() && vars0[i].getName().equals(vars1[i].getName()) && vars0[i].getNbProps() == vars1[i].getNbProps()) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public synchronized void nogoodStealing(Model model, NogoodFromRestarts caller) {
        for (Model m3 : this.models) {
            if (m3 == model) continue;
            caller.extractNogoodFromPath(m3.getSolver().getDecisionPath());
        }
    }

    public <V extends Variable> V getById(V var, Model model) {
        int p = this.id2pos.get(var.getId());
        if (p == -1) {
            p = NogoodStealer.binarySearch(model, var.getId());
        }
        return (V)model.getVar(p);
    }

    private static <T> int binarySearch(Model model, int key) {
        int low = 0;
        int high = model.getNbVars();
        while (low <= high) {
            int mid = low + high >>> 1;
            Variable midVal = model.getVar(mid);
            int cmp = midVal.getId() - key;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

