/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.relational;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import org.chocosolver.sat.Literalizer;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.expression.discrete.arithmetic.BiArExpression;
import org.chocosolver.solver.expression.discrete.arithmetic.NaArExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class UnCReExpression
implements ReExpression {
    private static final EnumSet<ArExpression.Operator> ALLOWED = EnumSet.of(ArExpression.Operator.ADD, ArExpression.Operator.SUB, ArExpression.Operator.NOP);
    Model model;
    BoolVar me = null;
    ReExpression.Operator op;
    private final ArExpression e1;
    private final int e2;

    public UnCReExpression(ReExpression.Operator op, ArExpression e1, int e2) {
        this.model = e1.getModel();
        this.op = op;
        this.e1 = e1;
        this.e2 = e2;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public BoolVar boolVar() {
        if (this.me == null) {
            IntVar v1 = this.e1.intVar();
            switch (this.op) {
                case LT: {
                    this.me = this.model.intLeView(v1, this.e2 - 1);
                    break;
                }
                case LE: {
                    this.me = this.model.intLeView(v1, this.e2);
                    break;
                }
                case GE: {
                    this.me = this.model.intGeView(v1, this.e2);
                    break;
                }
                case GT: {
                    this.me = this.model.intGeView(v1, this.e2 + 1);
                    break;
                }
                case NE: {
                    this.me = this.model.intNeView(v1, this.e2);
                    break;
                }
                case EQ: {
                    this.me = this.model.intEqView(v1, this.e2);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public void extractVar(HashSet<IntVar> variables) {
        this.e1.extractVar(variables);
        variables.add(this.model.intVar(this.e2));
    }

    private static ArExpression.Operator detectOperator(ArExpression e2) {
        int nochild = e2.getNoChild();
        if (nochild == 1) {
            return ArExpression.Operator.NOP;
        }
        ArExpression.Operator o = null;
        ArExpression[] child = e2.getExpressionChild();
        boolean madeOfLeaves = true;
        for (int i = 0; madeOfLeaves && i < nochild; ++i) {
            madeOfLeaves = child[i].isExpressionLeaf();
        }
        if (madeOfLeaves) {
            if (nochild == 2 && e2 instanceof BiArExpression) {
                o = ((BiArExpression)e2).getOp();
            } else if (e2 instanceof NaArExpression) {
                o = ((NaArExpression)e2).getOp();
            }
        }
        return o;
    }

    @Override
    public Constraint decompose() {
        ArExpression.Operator o1 = UnCReExpression.detectOperator(this.e1);
        if (ALLOWED.contains((Object)o1)) {
            Operator ope;
            IntVar[] vars = new IntVar[this.e1.getNoChild()];
            int[] coefs = new int[this.e1.getNoChild()];
            UnCReExpression.fill(vars, coefs, this.e1, o1, 0, 1);
            Model model = vars[0].getModel();
            switch (this.op) {
                case LT: {
                    ope = Operator.LT;
                    break;
                }
                case LE: {
                    ope = Operator.LE;
                    break;
                }
                case GE: {
                    ope = Operator.GE;
                    break;
                }
                case GT: {
                    ope = Operator.GT;
                    break;
                }
                case NE: {
                    ope = Operator.NQ;
                    break;
                }
                case EQ: {
                    ope = Operator.EQ;
                    break;
                }
                default: {
                    throw new SolverException("Unknown operator: " + (Object)((Object)this.op));
                }
            }
            return model.scalar(vars, coefs, ope.toString(), this.e2);
        }
        IntVar v1 = this.e1.intVar();
        Model model = v1.getModel();
        switch (this.op) {
            case LT: {
                return model.arithm(v1, "<", this.e2);
            }
            case LE: {
                return model.arithm(v1, "<=", this.e2);
            }
            case GE: {
                return model.arithm(v1, ">=", this.e2);
            }
            case GT: {
                return model.arithm(v1, ">", this.e2);
            }
            case NE: {
                return model.arithm(v1, "!=", this.e2);
            }
            case EQ: {
                return model.arithm(v1, "=", this.e2);
            }
        }
        throw new SolverException("Unexpected case");
    }

    private static void fill(IntVar[] vars, int[] coefs, ArExpression e2, ArExpression.Operator o1, int o, int m3) {
        ArExpression[] child = e2.getExpressionChild();
        vars[o] = e2.isExpressionLeaf() || child.length == 1 ? e2.intVar() : child[0].intVar();
        coefs[o] = m3;
        for (int i = 1; i < child.length; ++i) {
            vars[o + i] = child[i].intVar();
            assert (ALLOWED.contains((Object)o1));
            coefs[o + i] = (o1 == ArExpression.Operator.ADD ? 1 : -1) * m3;
        }
    }

    @Override
    public boolean beval(int[] values, Map<IntVar, Integer> map) {
        return this.op.eval(this.e1.ieval(values, map), this.e2);
    }

    public String toString() {
        return this.op.name() + "(" + this.e1.toString() + "," + this.e2 + ")";
    }

    public int satVar() {
        IntVar v1 = this.e1.intVar();
        switch (this.op) {
            case LT: {
                return this.model.satVar(v1, new Literalizer.IntLeLit(v1, this.e2 - 1));
            }
            case LE: {
                return this.model.satVar(v1, new Literalizer.IntLeLit(v1, this.e2));
            }
            case EQ: {
                return this.model.satVar(v1, new Literalizer.IntEqLit(v1, this.e2));
            }
        }
        throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
    }
}

