/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.fixed;

import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;

public class CommonOps_DDF3 {
    public static void add(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = a2.a11 + b2.a11;
        c2.a12 = a2.a12 + b2.a12;
        c2.a13 = a2.a13 + b2.a13;
        c2.a21 = a2.a21 + b2.a21;
        c2.a22 = a2.a22 + b2.a22;
        c2.a23 = a2.a23 + b2.a23;
        c2.a31 = a2.a31 + b2.a31;
        c2.a32 = a2.a32 + b2.a32;
        c2.a33 = a2.a33 + b2.a33;
    }

    public static void add(DMatrix3 a2, DMatrix3 b2, DMatrix3 c2) {
        c2.a1 = a2.a1 + b2.a1;
        c2.a2 = a2.a2 + b2.a2;
        c2.a3 = a2.a3 + b2.a3;
    }

    public static void addEquals(DMatrix3x3 a2, DMatrix3x3 b2) {
        a2.a11 += b2.a11;
        a2.a12 += b2.a12;
        a2.a13 += b2.a13;
        a2.a21 += b2.a21;
        a2.a22 += b2.a22;
        a2.a23 += b2.a23;
        a2.a31 += b2.a31;
        a2.a32 += b2.a32;
        a2.a33 += b2.a33;
    }

    public static void addEquals(DMatrix3 a2, DMatrix3 b2) {
        a2.a1 += b2.a1;
        a2.a2 += b2.a2;
        a2.a3 += b2.a3;
    }

    public static void subtract(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = a2.a11 - b2.a11;
        c2.a12 = a2.a12 - b2.a12;
        c2.a13 = a2.a13 - b2.a13;
        c2.a21 = a2.a21 - b2.a21;
        c2.a22 = a2.a22 - b2.a22;
        c2.a23 = a2.a23 - b2.a23;
        c2.a31 = a2.a31 - b2.a31;
        c2.a32 = a2.a32 - b2.a32;
        c2.a33 = a2.a33 - b2.a33;
    }

    public static void subtract(DMatrix3 a2, DMatrix3 b2, DMatrix3 c2) {
        c2.a1 = a2.a1 - b2.a1;
        c2.a2 = a2.a2 - b2.a2;
        c2.a3 = a2.a3 - b2.a3;
    }

    public static void subtractEquals(DMatrix3x3 a2, DMatrix3x3 b2) {
        a2.a11 -= b2.a11;
        a2.a12 -= b2.a12;
        a2.a13 -= b2.a13;
        a2.a21 -= b2.a21;
        a2.a22 -= b2.a22;
        a2.a23 -= b2.a23;
        a2.a31 -= b2.a31;
        a2.a32 -= b2.a32;
        a2.a33 -= b2.a33;
    }

    public static void subtractEquals(DMatrix3 a2, DMatrix3 b2) {
        a2.a1 -= b2.a1;
        a2.a2 -= b2.a2;
        a2.a3 -= b2.a3;
    }

    public static void transpose(DMatrix3x3 m3) {
        double tmp = m3.a12;
        m3.a12 = m3.a21;
        m3.a21 = tmp;
        tmp = m3.a13;
        m3.a13 = m3.a31;
        m3.a31 = tmp;
        tmp = m3.a23;
        m3.a23 = m3.a32;
        m3.a32 = tmp;
    }

    public static DMatrix3x3 transpose(DMatrix3x3 input, DMatrix3x3 output) {
        if (input == null) {
            input = new DMatrix3x3();
        }
        output.a11 = input.a11;
        output.a12 = input.a21;
        output.a13 = input.a31;
        output.a21 = input.a12;
        output.a22 = input.a22;
        output.a23 = input.a32;
        output.a31 = input.a13;
        output.a32 = input.a23;
        output.a33 = input.a33;
        return output;
    }

    public static void mult(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = a2.a11 * b2.a11 + a2.a12 * b2.a21 + a2.a13 * b2.a31;
        c2.a12 = a2.a11 * b2.a12 + a2.a12 * b2.a22 + a2.a13 * b2.a32;
        c2.a13 = a2.a11 * b2.a13 + a2.a12 * b2.a23 + a2.a13 * b2.a33;
        c2.a21 = a2.a21 * b2.a11 + a2.a22 * b2.a21 + a2.a23 * b2.a31;
        c2.a22 = a2.a21 * b2.a12 + a2.a22 * b2.a22 + a2.a23 * b2.a32;
        c2.a23 = a2.a21 * b2.a13 + a2.a22 * b2.a23 + a2.a23 * b2.a33;
        c2.a31 = a2.a31 * b2.a11 + a2.a32 * b2.a21 + a2.a33 * b2.a31;
        c2.a32 = a2.a31 * b2.a12 + a2.a32 * b2.a22 + a2.a33 * b2.a32;
        c2.a33 = a2.a31 * b2.a13 + a2.a32 * b2.a23 + a2.a33 * b2.a33;
    }

    public static void mult(double alpha, DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = alpha * (a2.a11 * b2.a11 + a2.a12 * b2.a21 + a2.a13 * b2.a31);
        c2.a12 = alpha * (a2.a11 * b2.a12 + a2.a12 * b2.a22 + a2.a13 * b2.a32);
        c2.a13 = alpha * (a2.a11 * b2.a13 + a2.a12 * b2.a23 + a2.a13 * b2.a33);
        c2.a21 = alpha * (a2.a21 * b2.a11 + a2.a22 * b2.a21 + a2.a23 * b2.a31);
        c2.a22 = alpha * (a2.a21 * b2.a12 + a2.a22 * b2.a22 + a2.a23 * b2.a32);
        c2.a23 = alpha * (a2.a21 * b2.a13 + a2.a22 * b2.a23 + a2.a23 * b2.a33);
        c2.a31 = alpha * (a2.a31 * b2.a11 + a2.a32 * b2.a21 + a2.a33 * b2.a31);
        c2.a32 = alpha * (a2.a31 * b2.a12 + a2.a32 * b2.a22 + a2.a33 * b2.a32);
        c2.a33 = alpha * (a2.a31 * b2.a13 + a2.a32 * b2.a23 + a2.a33 * b2.a33);
    }

    public static void multTransA(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = a2.a11 * b2.a11 + a2.a21 * b2.a21 + a2.a31 * b2.a31;
        c2.a12 = a2.a11 * b2.a12 + a2.a21 * b2.a22 + a2.a31 * b2.a32;
        c2.a13 = a2.a11 * b2.a13 + a2.a21 * b2.a23 + a2.a31 * b2.a33;
        c2.a21 = a2.a12 * b2.a11 + a2.a22 * b2.a21 + a2.a32 * b2.a31;
        c2.a22 = a2.a12 * b2.a12 + a2.a22 * b2.a22 + a2.a32 * b2.a32;
        c2.a23 = a2.a12 * b2.a13 + a2.a22 * b2.a23 + a2.a32 * b2.a33;
        c2.a31 = a2.a13 * b2.a11 + a2.a23 * b2.a21 + a2.a33 * b2.a31;
        c2.a32 = a2.a13 * b2.a12 + a2.a23 * b2.a22 + a2.a33 * b2.a32;
        c2.a33 = a2.a13 * b2.a13 + a2.a23 * b2.a23 + a2.a33 * b2.a33;
    }

    public static void multTransA(double alpha, DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = alpha * (a2.a11 * b2.a11 + a2.a21 * b2.a21 + a2.a31 * b2.a31);
        c2.a12 = alpha * (a2.a11 * b2.a12 + a2.a21 * b2.a22 + a2.a31 * b2.a32);
        c2.a13 = alpha * (a2.a11 * b2.a13 + a2.a21 * b2.a23 + a2.a31 * b2.a33);
        c2.a21 = alpha * (a2.a12 * b2.a11 + a2.a22 * b2.a21 + a2.a32 * b2.a31);
        c2.a22 = alpha * (a2.a12 * b2.a12 + a2.a22 * b2.a22 + a2.a32 * b2.a32);
        c2.a23 = alpha * (a2.a12 * b2.a13 + a2.a22 * b2.a23 + a2.a32 * b2.a33);
        c2.a31 = alpha * (a2.a13 * b2.a11 + a2.a23 * b2.a21 + a2.a33 * b2.a31);
        c2.a32 = alpha * (a2.a13 * b2.a12 + a2.a23 * b2.a22 + a2.a33 * b2.a32);
        c2.a33 = alpha * (a2.a13 * b2.a13 + a2.a23 * b2.a23 + a2.a33 * b2.a33);
    }

    public static void multTransAB(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = a2.a11 * b2.a11 + a2.a21 * b2.a12 + a2.a31 * b2.a13;
        c2.a12 = a2.a11 * b2.a21 + a2.a21 * b2.a22 + a2.a31 * b2.a23;
        c2.a13 = a2.a11 * b2.a31 + a2.a21 * b2.a32 + a2.a31 * b2.a33;
        c2.a21 = a2.a12 * b2.a11 + a2.a22 * b2.a12 + a2.a32 * b2.a13;
        c2.a22 = a2.a12 * b2.a21 + a2.a22 * b2.a22 + a2.a32 * b2.a23;
        c2.a23 = a2.a12 * b2.a31 + a2.a22 * b2.a32 + a2.a32 * b2.a33;
        c2.a31 = a2.a13 * b2.a11 + a2.a23 * b2.a12 + a2.a33 * b2.a13;
        c2.a32 = a2.a13 * b2.a21 + a2.a23 * b2.a22 + a2.a33 * b2.a23;
        c2.a33 = a2.a13 * b2.a31 + a2.a23 * b2.a32 + a2.a33 * b2.a33;
    }

    public static void multTransAB(double alpha, DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = alpha * (a2.a11 * b2.a11 + a2.a21 * b2.a12 + a2.a31 * b2.a13);
        c2.a12 = alpha * (a2.a11 * b2.a21 + a2.a21 * b2.a22 + a2.a31 * b2.a23);
        c2.a13 = alpha * (a2.a11 * b2.a31 + a2.a21 * b2.a32 + a2.a31 * b2.a33);
        c2.a21 = alpha * (a2.a12 * b2.a11 + a2.a22 * b2.a12 + a2.a32 * b2.a13);
        c2.a22 = alpha * (a2.a12 * b2.a21 + a2.a22 * b2.a22 + a2.a32 * b2.a23);
        c2.a23 = alpha * (a2.a12 * b2.a31 + a2.a22 * b2.a32 + a2.a32 * b2.a33);
        c2.a31 = alpha * (a2.a13 * b2.a11 + a2.a23 * b2.a12 + a2.a33 * b2.a13);
        c2.a32 = alpha * (a2.a13 * b2.a21 + a2.a23 * b2.a22 + a2.a33 * b2.a23);
        c2.a33 = alpha * (a2.a13 * b2.a31 + a2.a23 * b2.a32 + a2.a33 * b2.a33);
    }

    public static void multTransB(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = a2.a11 * b2.a11 + a2.a12 * b2.a12 + a2.a13 * b2.a13;
        c2.a12 = a2.a11 * b2.a21 + a2.a12 * b2.a22 + a2.a13 * b2.a23;
        c2.a13 = a2.a11 * b2.a31 + a2.a12 * b2.a32 + a2.a13 * b2.a33;
        c2.a21 = a2.a21 * b2.a11 + a2.a22 * b2.a12 + a2.a23 * b2.a13;
        c2.a22 = a2.a21 * b2.a21 + a2.a22 * b2.a22 + a2.a23 * b2.a23;
        c2.a23 = a2.a21 * b2.a31 + a2.a22 * b2.a32 + a2.a23 * b2.a33;
        c2.a31 = a2.a31 * b2.a11 + a2.a32 * b2.a12 + a2.a33 * b2.a13;
        c2.a32 = a2.a31 * b2.a21 + a2.a32 * b2.a22 + a2.a33 * b2.a23;
        c2.a33 = a2.a31 * b2.a31 + a2.a32 * b2.a32 + a2.a33 * b2.a33;
    }

    public static void multTransB(double alpha, DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = alpha * (a2.a11 * b2.a11 + a2.a12 * b2.a12 + a2.a13 * b2.a13);
        c2.a12 = alpha * (a2.a11 * b2.a21 + a2.a12 * b2.a22 + a2.a13 * b2.a23);
        c2.a13 = alpha * (a2.a11 * b2.a31 + a2.a12 * b2.a32 + a2.a13 * b2.a33);
        c2.a21 = alpha * (a2.a21 * b2.a11 + a2.a22 * b2.a12 + a2.a23 * b2.a13);
        c2.a22 = alpha * (a2.a21 * b2.a21 + a2.a22 * b2.a22 + a2.a23 * b2.a23);
        c2.a23 = alpha * (a2.a21 * b2.a31 + a2.a22 * b2.a32 + a2.a23 * b2.a33);
        c2.a31 = alpha * (a2.a31 * b2.a11 + a2.a32 * b2.a12 + a2.a33 * b2.a13);
        c2.a32 = alpha * (a2.a31 * b2.a21 + a2.a32 * b2.a22 + a2.a33 * b2.a23);
        c2.a33 = alpha * (a2.a31 * b2.a31 + a2.a32 * b2.a32 + a2.a33 * b2.a33);
    }

    public static void multAdd(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 += a2.a11 * b2.a11 + a2.a12 * b2.a21 + a2.a13 * b2.a31;
        c2.a12 += a2.a11 * b2.a12 + a2.a12 * b2.a22 + a2.a13 * b2.a32;
        c2.a13 += a2.a11 * b2.a13 + a2.a12 * b2.a23 + a2.a13 * b2.a33;
        c2.a21 += a2.a21 * b2.a11 + a2.a22 * b2.a21 + a2.a23 * b2.a31;
        c2.a22 += a2.a21 * b2.a12 + a2.a22 * b2.a22 + a2.a23 * b2.a32;
        c2.a23 += a2.a21 * b2.a13 + a2.a22 * b2.a23 + a2.a23 * b2.a33;
        c2.a31 += a2.a31 * b2.a11 + a2.a32 * b2.a21 + a2.a33 * b2.a31;
        c2.a32 += a2.a31 * b2.a12 + a2.a32 * b2.a22 + a2.a33 * b2.a32;
        c2.a33 += a2.a31 * b2.a13 + a2.a32 * b2.a23 + a2.a33 * b2.a33;
    }

    public static void multAdd(double alpha, DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 += alpha * (a2.a11 * b2.a11 + a2.a12 * b2.a21 + a2.a13 * b2.a31);
        c2.a12 += alpha * (a2.a11 * b2.a12 + a2.a12 * b2.a22 + a2.a13 * b2.a32);
        c2.a13 += alpha * (a2.a11 * b2.a13 + a2.a12 * b2.a23 + a2.a13 * b2.a33);
        c2.a21 += alpha * (a2.a21 * b2.a11 + a2.a22 * b2.a21 + a2.a23 * b2.a31);
        c2.a22 += alpha * (a2.a21 * b2.a12 + a2.a22 * b2.a22 + a2.a23 * b2.a32);
        c2.a23 += alpha * (a2.a21 * b2.a13 + a2.a22 * b2.a23 + a2.a23 * b2.a33);
        c2.a31 += alpha * (a2.a31 * b2.a11 + a2.a32 * b2.a21 + a2.a33 * b2.a31);
        c2.a32 += alpha * (a2.a31 * b2.a12 + a2.a32 * b2.a22 + a2.a33 * b2.a32);
        c2.a33 += alpha * (a2.a31 * b2.a13 + a2.a32 * b2.a23 + a2.a33 * b2.a33);
    }

    public static void multAddTransA(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 += a2.a11 * b2.a11 + a2.a21 * b2.a21 + a2.a31 * b2.a31;
        c2.a12 += a2.a11 * b2.a12 + a2.a21 * b2.a22 + a2.a31 * b2.a32;
        c2.a13 += a2.a11 * b2.a13 + a2.a21 * b2.a23 + a2.a31 * b2.a33;
        c2.a21 += a2.a12 * b2.a11 + a2.a22 * b2.a21 + a2.a32 * b2.a31;
        c2.a22 += a2.a12 * b2.a12 + a2.a22 * b2.a22 + a2.a32 * b2.a32;
        c2.a23 += a2.a12 * b2.a13 + a2.a22 * b2.a23 + a2.a32 * b2.a33;
        c2.a31 += a2.a13 * b2.a11 + a2.a23 * b2.a21 + a2.a33 * b2.a31;
        c2.a32 += a2.a13 * b2.a12 + a2.a23 * b2.a22 + a2.a33 * b2.a32;
        c2.a33 += a2.a13 * b2.a13 + a2.a23 * b2.a23 + a2.a33 * b2.a33;
    }

    public static void multAddTransA(double alpha, DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 += alpha * (a2.a11 * b2.a11 + a2.a21 * b2.a21 + a2.a31 * b2.a31);
        c2.a12 += alpha * (a2.a11 * b2.a12 + a2.a21 * b2.a22 + a2.a31 * b2.a32);
        c2.a13 += alpha * (a2.a11 * b2.a13 + a2.a21 * b2.a23 + a2.a31 * b2.a33);
        c2.a21 += alpha * (a2.a12 * b2.a11 + a2.a22 * b2.a21 + a2.a32 * b2.a31);
        c2.a22 += alpha * (a2.a12 * b2.a12 + a2.a22 * b2.a22 + a2.a32 * b2.a32);
        c2.a23 += alpha * (a2.a12 * b2.a13 + a2.a22 * b2.a23 + a2.a32 * b2.a33);
        c2.a31 += alpha * (a2.a13 * b2.a11 + a2.a23 * b2.a21 + a2.a33 * b2.a31);
        c2.a32 += alpha * (a2.a13 * b2.a12 + a2.a23 * b2.a22 + a2.a33 * b2.a32);
        c2.a33 += alpha * (a2.a13 * b2.a13 + a2.a23 * b2.a23 + a2.a33 * b2.a33);
    }

    public static void multAddTransAB(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 += a2.a11 * b2.a11 + a2.a21 * b2.a12 + a2.a31 * b2.a13;
        c2.a12 += a2.a11 * b2.a21 + a2.a21 * b2.a22 + a2.a31 * b2.a23;
        c2.a13 += a2.a11 * b2.a31 + a2.a21 * b2.a32 + a2.a31 * b2.a33;
        c2.a21 += a2.a12 * b2.a11 + a2.a22 * b2.a12 + a2.a32 * b2.a13;
        c2.a22 += a2.a12 * b2.a21 + a2.a22 * b2.a22 + a2.a32 * b2.a23;
        c2.a23 += a2.a12 * b2.a31 + a2.a22 * b2.a32 + a2.a32 * b2.a33;
        c2.a31 += a2.a13 * b2.a11 + a2.a23 * b2.a12 + a2.a33 * b2.a13;
        c2.a32 += a2.a13 * b2.a21 + a2.a23 * b2.a22 + a2.a33 * b2.a23;
        c2.a33 += a2.a13 * b2.a31 + a2.a23 * b2.a32 + a2.a33 * b2.a33;
    }

    public static void multAddTransAB(double alpha, DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 += alpha * (a2.a11 * b2.a11 + a2.a21 * b2.a12 + a2.a31 * b2.a13);
        c2.a12 += alpha * (a2.a11 * b2.a21 + a2.a21 * b2.a22 + a2.a31 * b2.a23);
        c2.a13 += alpha * (a2.a11 * b2.a31 + a2.a21 * b2.a32 + a2.a31 * b2.a33);
        c2.a21 += alpha * (a2.a12 * b2.a11 + a2.a22 * b2.a12 + a2.a32 * b2.a13);
        c2.a22 += alpha * (a2.a12 * b2.a21 + a2.a22 * b2.a22 + a2.a32 * b2.a23);
        c2.a23 += alpha * (a2.a12 * b2.a31 + a2.a22 * b2.a32 + a2.a32 * b2.a33);
        c2.a31 += alpha * (a2.a13 * b2.a11 + a2.a23 * b2.a12 + a2.a33 * b2.a13);
        c2.a32 += alpha * (a2.a13 * b2.a21 + a2.a23 * b2.a22 + a2.a33 * b2.a23);
        c2.a33 += alpha * (a2.a13 * b2.a31 + a2.a23 * b2.a32 + a2.a33 * b2.a33);
    }

    public static void multAddTransB(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 += a2.a11 * b2.a11 + a2.a12 * b2.a12 + a2.a13 * b2.a13;
        c2.a12 += a2.a11 * b2.a21 + a2.a12 * b2.a22 + a2.a13 * b2.a23;
        c2.a13 += a2.a11 * b2.a31 + a2.a12 * b2.a32 + a2.a13 * b2.a33;
        c2.a21 += a2.a21 * b2.a11 + a2.a22 * b2.a12 + a2.a23 * b2.a13;
        c2.a22 += a2.a21 * b2.a21 + a2.a22 * b2.a22 + a2.a23 * b2.a23;
        c2.a23 += a2.a21 * b2.a31 + a2.a22 * b2.a32 + a2.a23 * b2.a33;
        c2.a31 += a2.a31 * b2.a11 + a2.a32 * b2.a12 + a2.a33 * b2.a13;
        c2.a32 += a2.a31 * b2.a21 + a2.a32 * b2.a22 + a2.a33 * b2.a23;
        c2.a33 += a2.a31 * b2.a31 + a2.a32 * b2.a32 + a2.a33 * b2.a33;
    }

    public static void multAddTransB(double alpha, DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 += alpha * (a2.a11 * b2.a11 + a2.a12 * b2.a12 + a2.a13 * b2.a13);
        c2.a12 += alpha * (a2.a11 * b2.a21 + a2.a12 * b2.a22 + a2.a13 * b2.a23);
        c2.a13 += alpha * (a2.a11 * b2.a31 + a2.a12 * b2.a32 + a2.a13 * b2.a33);
        c2.a21 += alpha * (a2.a21 * b2.a11 + a2.a22 * b2.a12 + a2.a23 * b2.a13);
        c2.a22 += alpha * (a2.a21 * b2.a21 + a2.a22 * b2.a22 + a2.a23 * b2.a23);
        c2.a23 += alpha * (a2.a21 * b2.a31 + a2.a22 * b2.a32 + a2.a23 * b2.a33);
        c2.a31 += alpha * (a2.a31 * b2.a11 + a2.a32 * b2.a12 + a2.a33 * b2.a13);
        c2.a32 += alpha * (a2.a31 * b2.a21 + a2.a32 * b2.a22 + a2.a33 * b2.a23);
        c2.a33 += alpha * (a2.a31 * b2.a31 + a2.a32 * b2.a32 + a2.a33 * b2.a33);
    }

    public static void mult(DMatrix3x3 a2, DMatrix3 b2, DMatrix3 c2) {
        c2.a1 = a2.a11 * b2.a1 + a2.a12 * b2.a2 + a2.a13 * b2.a3;
        c2.a2 = a2.a21 * b2.a1 + a2.a22 * b2.a2 + a2.a23 * b2.a3;
        c2.a3 = a2.a31 * b2.a1 + a2.a32 * b2.a2 + a2.a33 * b2.a3;
    }

    public static void mult(DMatrix3 a2, DMatrix3x3 b2, DMatrix3 c2) {
        c2.a1 = a2.a1 * b2.a11 + a2.a2 * b2.a21 + a2.a3 * b2.a31;
        c2.a2 = a2.a1 * b2.a12 + a2.a2 * b2.a22 + a2.a3 * b2.a32;
        c2.a3 = a2.a1 * b2.a13 + a2.a2 * b2.a23 + a2.a3 * b2.a33;
    }

    public static double dot(DMatrix3 a2, DMatrix3 b2) {
        return a2.a1 * b2.a1 + a2.a2 * b2.a2 + a2.a3 * b2.a3;
    }

    public static void setIdentity(DMatrix3x3 a2) {
        a2.a11 = 1.0;
        a2.a21 = 0.0;
        a2.a31 = 0.0;
        a2.a12 = 0.0;
        a2.a22 = 1.0;
        a2.a32 = 0.0;
        a2.a13 = 0.0;
        a2.a23 = 0.0;
        a2.a33 = 1.0;
    }

    public static boolean invert(DMatrix3x3 a2, DMatrix3x3 inv) {
        double scale = 1.0 / CommonOps_DDF3.elementMaxAbs(a2);
        double a11 = a2.a11 * scale;
        double a12 = a2.a12 * scale;
        double a13 = a2.a13 * scale;
        double a21 = a2.a21 * scale;
        double a22 = a2.a22 * scale;
        double a23 = a2.a23 * scale;
        double a31 = a2.a31 * scale;
        double a32 = a2.a32 * scale;
        double a33 = a2.a33 * scale;
        double m11 = a22 * a33 - a23 * a32;
        double m12 = -(a21 * a33 - a23 * a31);
        double m13 = a21 * a32 - a22 * a31;
        double m21 = -(a12 * a33 - a13 * a32);
        double m22 = a11 * a33 - a13 * a31;
        double m23 = -(a11 * a32 - a12 * a31);
        double m31 = a12 * a23 - a13 * a22;
        double m32 = -(a11 * a23 - a13 * a21);
        double m33 = a11 * a22 - a12 * a21;
        double det = (a11 * m11 + a12 * m12 + a13 * m13) / scale;
        inv.a11 = m11 / det;
        inv.a12 = m21 / det;
        inv.a13 = m31 / det;
        inv.a21 = m12 / det;
        inv.a22 = m22 / det;
        inv.a23 = m32 / det;
        inv.a31 = m13 / det;
        inv.a32 = m23 / det;
        inv.a33 = m33 / det;
        return !Double.isNaN(det) && !Double.isInfinite(det);
    }

    public static double det(DMatrix3x3 mat) {
        double a2 = mat.a11 * (mat.a22 * mat.a33 - mat.a23 * mat.a32);
        double b2 = mat.a12 * (mat.a21 * mat.a33 - mat.a23 * mat.a31);
        double c2 = mat.a13 * (mat.a21 * mat.a32 - mat.a31 * mat.a22);
        return a2 - b2 + c2;
    }

    public static double trace(DMatrix3x3 a2) {
        return a2.a11 + a2.a22 + a2.a33;
    }

    public static void diag(DMatrix3x3 input, DMatrix3 out) {
        out.a1 = input.a11;
        out.a2 = input.a22;
        out.a3 = input.a33;
    }

    public static double elementMax(DMatrix3x3 a2) {
        double max = a2.a11;
        if (a2.a12 > max) {
            max = a2.a12;
        }
        if (a2.a13 > max) {
            max = a2.a13;
        }
        if (a2.a21 > max) {
            max = a2.a21;
        }
        if (a2.a22 > max) {
            max = a2.a22;
        }
        if (a2.a23 > max) {
            max = a2.a23;
        }
        if (a2.a31 > max) {
            max = a2.a31;
        }
        if (a2.a32 > max) {
            max = a2.a32;
        }
        if (a2.a33 > max) {
            max = a2.a33;
        }
        return max;
    }

    public static double elementMax(DMatrix3 a2) {
        double max = a2.a1;
        if (a2.a2 > max) {
            max = a2.a2;
        }
        if (a2.a3 > max) {
            max = a2.a3;
        }
        return max;
    }

    public static double elementMaxAbs(DMatrix3x3 a2) {
        double max = Math.abs(a2.a11);
        double tmp = Math.abs(a2.a12);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a13)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a21)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a22)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a23)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a31)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a32)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a33)) > max) {
            max = tmp;
        }
        return max;
    }

    public static double elementMaxAbs(DMatrix3 a2) {
        double max = Math.abs(a2.a1);
        double tmp = Math.abs(a2.a2);
        if (tmp > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a2)) > max) {
            max = tmp;
        }
        if ((tmp = Math.abs(a2.a3)) > max) {
            max = tmp;
        }
        return max;
    }

    public static double elementMin(DMatrix3x3 a2) {
        double min2 = a2.a11;
        if (a2.a12 < min2) {
            min2 = a2.a12;
        }
        if (a2.a13 < min2) {
            min2 = a2.a13;
        }
        if (a2.a21 < min2) {
            min2 = a2.a21;
        }
        if (a2.a22 < min2) {
            min2 = a2.a22;
        }
        if (a2.a23 < min2) {
            min2 = a2.a23;
        }
        if (a2.a31 < min2) {
            min2 = a2.a31;
        }
        if (a2.a32 < min2) {
            min2 = a2.a32;
        }
        if (a2.a33 < min2) {
            min2 = a2.a33;
        }
        return min2;
    }

    public static double elementMin(DMatrix3 a2) {
        double min2 = a2.a1;
        if (a2.a2 < min2) {
            min2 = a2.a2;
        }
        if (a2.a3 < min2) {
            min2 = a2.a3;
        }
        return min2;
    }

    public static double elementMinAbs(DMatrix3x3 a2) {
        double min2 = Math.abs(a2.a11);
        double tmp = Math.abs(a2.a12);
        if (tmp < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a13)) < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a21)) < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a22)) < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a23)) < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a31)) < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a32)) < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a33)) < min2) {
            min2 = tmp;
        }
        return min2;
    }

    public static double elementMinAbs(DMatrix3 a2) {
        double min2 = Math.abs(a2.a1);
        double tmp = Math.abs(a2.a1);
        if (tmp < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a2)) < min2) {
            min2 = tmp;
        }
        if ((tmp = Math.abs(a2.a3)) < min2) {
            min2 = tmp;
        }
        return min2;
    }

    public static void elementMult(DMatrix3x3 a2, DMatrix3x3 b2) {
        a2.a11 *= b2.a11;
        a2.a12 *= b2.a12;
        a2.a13 *= b2.a13;
        a2.a21 *= b2.a21;
        a2.a22 *= b2.a22;
        a2.a23 *= b2.a23;
        a2.a31 *= b2.a31;
        a2.a32 *= b2.a32;
        a2.a33 *= b2.a33;
    }

    public static void elementMult(DMatrix3 a2, DMatrix3 b2) {
        a2.a1 *= b2.a1;
        a2.a2 *= b2.a2;
        a2.a3 *= b2.a3;
    }

    public static void elementMult(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = a2.a11 * b2.a11;
        c2.a12 = a2.a12 * b2.a12;
        c2.a13 = a2.a13 * b2.a13;
        c2.a21 = a2.a21 * b2.a21;
        c2.a22 = a2.a22 * b2.a22;
        c2.a23 = a2.a23 * b2.a23;
        c2.a31 = a2.a31 * b2.a31;
        c2.a32 = a2.a32 * b2.a32;
        c2.a33 = a2.a33 * b2.a33;
    }

    public static void elementMult(DMatrix3 a2, DMatrix3 b2, DMatrix3 c2) {
        c2.a1 = a2.a1 * b2.a1;
        c2.a2 = a2.a2 * b2.a2;
        c2.a3 = a2.a3 * b2.a3;
    }

    public static void elementDiv(DMatrix3x3 a2, DMatrix3x3 b2) {
        a2.a11 /= b2.a11;
        a2.a12 /= b2.a12;
        a2.a13 /= b2.a13;
        a2.a21 /= b2.a21;
        a2.a22 /= b2.a22;
        a2.a23 /= b2.a23;
        a2.a31 /= b2.a31;
        a2.a32 /= b2.a32;
        a2.a33 /= b2.a33;
    }

    public static void elementDiv(DMatrix3 a2, DMatrix3 b2) {
        a2.a1 /= b2.a1;
        a2.a2 /= b2.a2;
        a2.a3 /= b2.a3;
    }

    public static void elementDiv(DMatrix3x3 a2, DMatrix3x3 b2, DMatrix3x3 c2) {
        c2.a11 = a2.a11 / b2.a11;
        c2.a12 = a2.a12 / b2.a12;
        c2.a13 = a2.a13 / b2.a13;
        c2.a21 = a2.a21 / b2.a21;
        c2.a22 = a2.a22 / b2.a22;
        c2.a23 = a2.a23 / b2.a23;
        c2.a31 = a2.a31 / b2.a31;
        c2.a32 = a2.a32 / b2.a32;
        c2.a33 = a2.a33 / b2.a33;
    }

    public static void elementDiv(DMatrix3 a2, DMatrix3 b2, DMatrix3 c2) {
        c2.a1 = a2.a1 / b2.a1;
        c2.a2 = a2.a2 / b2.a2;
        c2.a3 = a2.a3 / b2.a3;
    }

    public static void scale(double alpha, DMatrix3x3 a2) {
        a2.a11 *= alpha;
        a2.a12 *= alpha;
        a2.a13 *= alpha;
        a2.a21 *= alpha;
        a2.a22 *= alpha;
        a2.a23 *= alpha;
        a2.a31 *= alpha;
        a2.a32 *= alpha;
        a2.a33 *= alpha;
    }

    public static void scale(double alpha, DMatrix3 a2) {
        a2.a1 *= alpha;
        a2.a2 *= alpha;
        a2.a3 *= alpha;
    }

    public static void scale(double alpha, DMatrix3x3 a2, DMatrix3x3 b2) {
        b2.a11 = a2.a11 * alpha;
        b2.a12 = a2.a12 * alpha;
        b2.a13 = a2.a13 * alpha;
        b2.a21 = a2.a21 * alpha;
        b2.a22 = a2.a22 * alpha;
        b2.a23 = a2.a23 * alpha;
        b2.a31 = a2.a31 * alpha;
        b2.a32 = a2.a32 * alpha;
        b2.a33 = a2.a33 * alpha;
    }

    public static void scale(double alpha, DMatrix3 a2, DMatrix3 b2) {
        b2.a1 = a2.a1 * alpha;
        b2.a2 = a2.a2 * alpha;
        b2.a3 = a2.a3 * alpha;
    }

    public static void divide(DMatrix3x3 a2, double alpha) {
        a2.a11 /= alpha;
        a2.a12 /= alpha;
        a2.a13 /= alpha;
        a2.a21 /= alpha;
        a2.a22 /= alpha;
        a2.a23 /= alpha;
        a2.a31 /= alpha;
        a2.a32 /= alpha;
        a2.a33 /= alpha;
    }

    public static void divide(DMatrix3 a2, double alpha) {
        a2.a1 /= alpha;
        a2.a2 /= alpha;
        a2.a3 /= alpha;
    }

    public static void divide(DMatrix3x3 a2, double alpha, DMatrix3x3 b2) {
        b2.a11 = a2.a11 / alpha;
        b2.a12 = a2.a12 / alpha;
        b2.a13 = a2.a13 / alpha;
        b2.a21 = a2.a21 / alpha;
        b2.a22 = a2.a22 / alpha;
        b2.a23 = a2.a23 / alpha;
        b2.a31 = a2.a31 / alpha;
        b2.a32 = a2.a32 / alpha;
        b2.a33 = a2.a33 / alpha;
    }

    public static void divide(DMatrix3 a2, double alpha, DMatrix3 b2) {
        b2.a1 = a2.a1 / alpha;
        b2.a2 = a2.a2 / alpha;
        b2.a3 = a2.a3 / alpha;
    }

    public static void changeSign(DMatrix3x3 a2) {
        a2.a11 = -a2.a11;
        a2.a12 = -a2.a12;
        a2.a13 = -a2.a13;
        a2.a21 = -a2.a21;
        a2.a22 = -a2.a22;
        a2.a23 = -a2.a23;
        a2.a31 = -a2.a31;
        a2.a32 = -a2.a32;
        a2.a33 = -a2.a33;
    }

    public static void changeSign(DMatrix3 a2) {
        a2.a1 = -a2.a1;
        a2.a2 = -a2.a2;
        a2.a3 = -a2.a3;
    }

    public static void fill(DMatrix3x3 a2, double v) {
        a2.a11 = v;
        a2.a12 = v;
        a2.a13 = v;
        a2.a21 = v;
        a2.a22 = v;
        a2.a23 = v;
        a2.a31 = v;
        a2.a32 = v;
        a2.a33 = v;
    }

    public static void fill(DMatrix3 a2, double v) {
        a2.a1 = v;
        a2.a2 = v;
        a2.a3 = v;
    }

    public static DMatrix3 extractRow(DMatrix3x3 a2, int row, DMatrix3 out) {
        if (out == null) {
            out = new DMatrix3();
        }
        switch (row) {
            case 0: {
                out.a1 = a2.a11;
                out.a2 = a2.a12;
                out.a3 = a2.a13;
                break;
            }
            case 1: {
                out.a1 = a2.a21;
                out.a2 = a2.a22;
                out.a3 = a2.a23;
                break;
            }
            case 2: {
                out.a1 = a2.a31;
                out.a2 = a2.a32;
                out.a3 = a2.a33;
                break;
            }
            default: {
                throw new IllegalArgumentException("Out of bounds row.  row = " + row);
            }
        }
        return out;
    }

    public static DMatrix3 extractColumn(DMatrix3x3 a2, int column, DMatrix3 out) {
        if (out == null) {
            out = new DMatrix3();
        }
        switch (column) {
            case 0: {
                out.a1 = a2.a11;
                out.a2 = a2.a21;
                out.a3 = a2.a31;
                break;
            }
            case 1: {
                out.a1 = a2.a12;
                out.a2 = a2.a22;
                out.a3 = a2.a32;
                break;
            }
            case 2: {
                out.a1 = a2.a13;
                out.a2 = a2.a23;
                out.a3 = a2.a33;
                break;
            }
            default: {
                throw new IllegalArgumentException("Out of bounds column.  column = " + column);
            }
        }
        return out;
    }
}

