/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.data.ComplexPolar_F32;
import org.ejml.data.Complex_F32;

public class ComplexMath_F32 {
    public static void conj(Complex_F32 input, Complex_F32 conj) {
        conj.real = input.real;
        conj.imaginary = -input.imaginary;
    }

    public static void plus(Complex_F32 a2, Complex_F32 b2, Complex_F32 result) {
        result.real = a2.real + b2.real;
        result.imaginary = a2.imaginary + b2.imaginary;
    }

    public static void minus(Complex_F32 a2, Complex_F32 b2, Complex_F32 result) {
        result.real = a2.real - b2.real;
        result.imaginary = a2.imaginary - b2.imaginary;
    }

    public static void multiply(Complex_F32 a2, Complex_F32 b2, Complex_F32 result) {
        result.real = a2.real * b2.real - a2.imaginary * b2.imaginary;
        result.imaginary = a2.real * b2.imaginary + a2.imaginary * b2.real;
    }

    public static void divide(Complex_F32 a2, Complex_F32 b2, Complex_F32 result) {
        float norm = b2.getMagnitude2();
        result.real = (a2.real * b2.real + a2.imaginary * b2.imaginary) / norm;
        result.imaginary = (a2.imaginary * b2.real - a2.real * b2.imaginary) / norm;
    }

    public static void convert(Complex_F32 input, ComplexPolar_F32 output) {
        output.r = input.getMagnitude();
        output.theta = (float)Math.atan2(input.imaginary, input.real);
    }

    public static void convert(ComplexPolar_F32 input, Complex_F32 output) {
        output.real = input.r * (float)Math.cos(input.theta);
        output.imaginary = input.r * (float)Math.sin(input.theta);
    }

    public static void multiply(ComplexPolar_F32 a2, ComplexPolar_F32 b2, ComplexPolar_F32 result) {
        result.r = a2.r * b2.r;
        result.theta = a2.theta + b2.theta;
    }

    public static void divide(ComplexPolar_F32 a2, ComplexPolar_F32 b2, ComplexPolar_F32 result) {
        result.r = a2.r / b2.r;
        result.theta = a2.theta - b2.theta;
    }

    public static void pow(ComplexPolar_F32 a2, int N, ComplexPolar_F32 result) {
        result.r = (float)Math.pow(a2.r, N);
        result.theta = (float)N * a2.theta;
    }

    public static void root(ComplexPolar_F32 a2, int N, int k, ComplexPolar_F32 result) {
        result.r = (float)Math.pow(a2.r, 1.0f / (float)N);
        result.theta = (a2.theta + 2.0f * (float)k * UtilEjml.F_PI) / (float)N;
    }

    public static void root(Complex_F32 a2, int N, int k, Complex_F32 result) {
        float r = a2.getMagnitude();
        float theta = (float)Math.atan2(a2.imaginary, a2.real);
        r = (float)Math.pow(r, 1.0f / (float)N);
        theta = (theta + 2.0f * (float)k * UtilEjml.F_PI) / (float)N;
        result.real = r * (float)Math.cos(theta);
        result.imaginary = r * (float)Math.sin(theta);
    }

    public static void sqrt(Complex_F32 input, Complex_F32 root) {
        float r = input.getMagnitude();
        float a2 = input.real;
        root.real = (float)Math.sqrt((r + a2) / 2.0f);
        root.imaginary = (float)Math.sqrt((r - a2) / 2.0f);
        if (input.imaginary < 0.0f) {
            root.imaginary = -root.imaginary;
        }
    }
}

