/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.geotools.geometry.jts.AbstractLiteIterator;
import org.geotools.geometry.jts.EmptyIterator;
import org.geotools.geometry.jts.LineIterator;
import org.geotools.geometry.jts.PointIterator;
import org.geotools.geometry.jts.PolygonIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public final class GeomCollectionIterator
extends AbstractLiteIterator {
    private AffineTransform at;
    private GeometryCollection gc;
    private int currentGeom;
    private PathIterator currentIterator;
    private boolean done = false;
    private boolean generalize = false;
    private double maxDistance = 1.0;

    public GeomCollectionIterator() {
    }

    public void init(GeometryCollection gc, AffineTransform at, boolean generalize, double maxDistance) {
        this.gc = gc;
        this.at = at == null ? new AffineTransform() : at;
        this.generalize = generalize;
        this.maxDistance = maxDistance;
        this.currentGeom = 0;
        this.done = false;
        this.currentIterator = gc.isEmpty() ? EmptyIterator.INSTANCE : this.getIterator(gc.getGeometryN(0));
    }

    public GeomCollectionIterator(GeometryCollection gc, AffineTransform at, boolean generalize, double maxDistance) {
        this.init(gc, at, generalize, maxDistance);
    }

    public void setMaxDistance(double distance) {
        this.maxDistance = distance;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    private AbstractLiteIterator getIterator(Geometry g2) {
        AbstractLiteIterator pi = null;
        if (g2.isEmpty()) {
            return EmptyIterator.INSTANCE;
        }
        if (g2 instanceof Polygon) {
            Polygon p = (Polygon)g2;
            pi = new PolygonIterator(p, this.at, this.generalize, this.maxDistance);
        } else if (g2 instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g2;
            pi = new GeomCollectionIterator(gc, this.at, this.generalize, this.maxDistance);
        } else if (g2 instanceof LineString || g2 instanceof LinearRing) {
            LineString ls = (LineString)g2;
            pi = new LineIterator(ls, this.at, this.generalize, (float)this.maxDistance);
        } else if (g2 instanceof Point) {
            Point p = (Point)g2;
            pi = new PointIterator(p, this.at);
        }
        return pi;
    }

    @Override
    public int currentSegment(double[] coords) {
        return this.currentIterator.currentSegment(coords);
    }

    @Override
    public int currentSegment(float[] coords) {
        return this.currentIterator.currentSegment(coords);
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        if (!this.currentIterator.isDone()) {
            this.currentIterator.next();
        }
        while (this.currentIterator.isDone() && !this.done) {
            if (this.currentGeom < this.gc.getNumGeometries() - 1) {
                ++this.currentGeom;
                this.currentIterator = this.getIterator(this.gc.getGeometryN(this.currentGeom));
                continue;
            }
            this.done = true;
        }
    }
}

