/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import org.geotools.geometry.jts.coordinatesequence.CSBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;

public class DefaultCSBuilder
implements CSBuilder {
    private Coordinate[] coordinateArray;
    private CoordinateSequenceFactory factory = CoordinateArraySequenceFactory.instance();

    @Override
    public void start(int size, int dimensions) {
        this.coordinateArray = new Coordinate[size];
        for (int i = 0; i < size; ++i) {
            this.coordinateArray[i] = new Coordinate();
        }
    }

    @Override
    public CoordinateSequence end() {
        CoordinateSequence cs = this.factory.create(this.coordinateArray);
        this.coordinateArray = null;
        return cs;
    }

    @Override
    public void setOrdinate(double value, int ordinateIndex, int coordinateIndex) {
        Coordinate c2 = this.coordinateArray[coordinateIndex];
        switch (ordinateIndex) {
            case 0: {
                c2.x = value;
                break;
            }
            case 1: {
                c2.y = value;
                break;
            }
            case 2: {
                c2.setZ(value);
            }
        }
    }

    @Override
    public double getOrdinate(int ordinateIndex, int coordinateIndex) {
        Coordinate c2 = this.coordinateArray[coordinateIndex];
        switch (ordinateIndex) {
            case 0: {
                return c2.x;
            }
            case 1: {
                return c2.y;
            }
            case 2: {
                return c2.getZ();
            }
        }
        return 0.0;
    }

    @Override
    public int getSize() {
        if (this.coordinateArray != null) {
            return this.coordinateArray.length;
        }
        return -1;
    }

    @Override
    public int getDimension() {
        if (this.coordinateArray != null) {
            return 2;
        }
        return -1;
    }

    @Override
    public void setOrdinate(CoordinateSequence sequence, double value, int ordinateIndex, int coordinateIndex) {
        Coordinate c2 = sequence.getCoordinate(coordinateIndex);
        switch (ordinateIndex) {
            case 0: {
                c2.x = value;
                break;
            }
            case 1: {
                c2.y = value;
                break;
            }
            case 2: {
                c2.setZ(value);
            }
        }
    }
}

