/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.Iterator;
import java.util.TreeSet;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.EdgeIntersectionList;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.operation.valid.ConnectedInteriorTester;
import org.locationtech.jts.operation.valid.ConsistentAreaTester;
import org.locationtech.jts.operation.valid.IndexedNestedRingTester;
import org.locationtech.jts.operation.valid.TopologyValidationError;
import org.locationtech.jts.util.Assert;

public class IsValidOp {
    private Geometry parentGeometry;
    private boolean isSelfTouchingRingFormingHoleValid = false;
    private TopologyValidationError validErr;

    public static boolean isValid(Geometry geom) {
        IsValidOp isValidOp = new IsValidOp(geom);
        return isValidOp.isValid();
    }

    public static boolean isValid(Coordinate coord) {
        if (Double.isNaN(coord.x)) {
            return false;
        }
        if (Double.isInfinite(coord.x)) {
            return false;
        }
        if (Double.isNaN(coord.y)) {
            return false;
        }
        return !Double.isInfinite(coord.y);
    }

    public static Coordinate findPtNotNode(Coordinate[] testCoords, LinearRing searchRing, GeometryGraph graph) {
        Edge searchEdge = graph.findEdge(searchRing);
        EdgeIntersectionList eiList = searchEdge.getEdgeIntersectionList();
        for (int i = 0; i < testCoords.length; ++i) {
            Coordinate pt = testCoords[i];
            if (eiList.isIntersection(pt)) continue;
            return pt;
        }
        return null;
    }

    public IsValidOp(Geometry parentGeometry) {
        this.parentGeometry = parentGeometry;
    }

    public void setSelfTouchingRingFormingHoleValid(boolean isValid) {
        this.isSelfTouchingRingFormingHoleValid = isValid;
    }

    public boolean isValid() {
        this.checkValid(this.parentGeometry);
        return this.validErr == null;
    }

    public TopologyValidationError getValidationError() {
        this.checkValid(this.parentGeometry);
        return this.validErr;
    }

    private void checkValid(Geometry g2) {
        this.validErr = null;
        if (g2.isEmpty()) {
            return;
        }
        if (g2 instanceof Point) {
            this.checkValid((Point)g2);
        } else if (g2 instanceof MultiPoint) {
            this.checkValid((MultiPoint)g2);
        } else if (g2 instanceof LinearRing) {
            this.checkValid((LinearRing)g2);
        } else if (g2 instanceof LineString) {
            this.checkValid((LineString)g2);
        } else if (g2 instanceof Polygon) {
            this.checkValid((Polygon)g2);
        } else if (g2 instanceof MultiPolygon) {
            this.checkValid((MultiPolygon)g2);
        } else if (g2 instanceof GeometryCollection) {
            this.checkValid((GeometryCollection)g2);
        } else {
            throw new UnsupportedOperationException(g2.getClass().getName());
        }
    }

    private void checkValid(Point g2) {
        this.checkInvalidCoordinates(g2.getCoordinates());
    }

    private void checkValid(MultiPoint g2) {
        this.checkInvalidCoordinates(g2.getCoordinates());
    }

    private void checkValid(LineString g2) {
        this.checkInvalidCoordinates(g2.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g2);
        this.checkTooFewPoints(graph);
    }

    private void checkValid(LinearRing g2) {
        this.checkInvalidCoordinates(g2.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRing(g2);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g2);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        RobustLineIntersector li = new RobustLineIntersector();
        graph.computeSelfNodes(li, true, true);
        this.checkNoSelfIntersectingRings(graph);
    }

    private void checkValid(Polygon g2) {
        this.checkInvalidCoordinates(g2);
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRings(g2);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g2);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(graph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(graph);
            if (this.validErr != null) {
                return;
            }
        }
        this.checkHolesInShell(g2, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkHolesNotNested(g2, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(graph);
    }

    private void checkValid(MultiPolygon g2) {
        Polygon p;
        int i;
        for (int i2 = 0; i2 < g2.getNumGeometries(); ++i2) {
            Polygon p2 = (Polygon)g2.getGeometryN(i2);
            this.checkInvalidCoordinates(p2);
            if (this.validErr != null) {
                return;
            }
            this.checkClosedRings(p2);
            if (this.validErr == null) continue;
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g2);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(graph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(graph);
            if (this.validErr != null) {
                return;
            }
        }
        for (i = 0; i < g2.getNumGeometries(); ++i) {
            p = (Polygon)g2.getGeometryN(i);
            this.checkHolesInShell(p, graph);
            if (this.validErr == null) continue;
            return;
        }
        for (i = 0; i < g2.getNumGeometries(); ++i) {
            p = (Polygon)g2.getGeometryN(i);
            this.checkHolesNotNested(p, graph);
            if (this.validErr == null) continue;
            return;
        }
        this.checkShellsNotNested(g2, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(graph);
    }

    private void checkValid(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g2 = gc.getGeometryN(i);
            this.checkValid(g2);
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkInvalidCoordinates(Coordinate[] coords) {
        for (int i = 0; i < coords.length; ++i) {
            if (IsValidOp.isValid(coords[i])) continue;
            this.validErr = new TopologyValidationError(10, coords[i]);
            return;
        }
    }

    private void checkInvalidCoordinates(Polygon poly) {
        this.checkInvalidCoordinates(poly.getExteriorRing().getCoordinates());
        if (this.validErr != null) {
            return;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.checkInvalidCoordinates(poly.getInteriorRingN(i).getCoordinates());
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkClosedRings(Polygon poly) {
        this.checkClosedRing(poly.getExteriorRing());
        if (this.validErr != null) {
            return;
        }
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.checkClosedRing(poly.getInteriorRingN(i));
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkClosedRing(LinearRing ring) {
        if (ring.isEmpty()) {
            return;
        }
        if (!ring.isClosed()) {
            Coordinate pt = null;
            if (ring.getNumPoints() >= 1) {
                pt = ring.getCoordinateN(0);
            }
            this.validErr = new TopologyValidationError(11, pt);
        }
    }

    private void checkTooFewPoints(GeometryGraph graph) {
        if (graph.hasTooFewPoints()) {
            this.validErr = new TopologyValidationError(9, graph.getInvalidPoint());
            return;
        }
    }

    private void checkConsistentArea(GeometryGraph graph) {
        ConsistentAreaTester cat = new ConsistentAreaTester(graph);
        boolean isValidArea = cat.isNodeConsistentArea();
        if (!isValidArea) {
            this.validErr = new TopologyValidationError(5, cat.getInvalidPoint());
            return;
        }
        if (cat.hasDuplicateRings()) {
            this.validErr = new TopologyValidationError(8, cat.getInvalidPoint());
        }
    }

    private void checkNoSelfIntersectingRings(GeometryGraph graph) {
        Iterator i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Edge e2 = (Edge)i.next();
            this.checkNoSelfIntersectingRing(e2.getEdgeIntersectionList());
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkNoSelfIntersectingRing(EdgeIntersectionList eiList) {
        TreeSet<Coordinate> nodeSet = new TreeSet<Coordinate>();
        boolean isFirst = true;
        Iterator i = eiList.iterator();
        while (i.hasNext()) {
            EdgeIntersection ei = (EdgeIntersection)i.next();
            if (isFirst) {
                isFirst = false;
                continue;
            }
            if (nodeSet.contains(ei.coord)) {
                this.validErr = new TopologyValidationError(6, ei.coord);
                return;
            }
            nodeSet.add(ei.coord);
        }
    }

    private void checkHolesInShell(Polygon p, GeometryGraph graph) {
        if (p.getNumInteriorRing() <= 0) {
            return;
        }
        LinearRing shell = p.getExteriorRing();
        boolean isShellEmpty = shell.isEmpty();
        IndexedPointInAreaLocator pir = new IndexedPointInAreaLocator(shell);
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            boolean outside;
            LinearRing hole = p.getInteriorRingN(i);
            Coordinate holePt = null;
            if (hole.isEmpty()) continue;
            holePt = IsValidOp.findPtNotNode(hole.getCoordinates(), shell, graph);
            if (holePt == null) {
                return;
            }
            boolean bl = outside = isShellEmpty || 2 == pir.locate(holePt);
            if (!outside) continue;
            this.validErr = new TopologyValidationError(2, holePt);
            return;
        }
    }

    private void checkHolesNotNested(Polygon p, GeometryGraph graph) {
        if (p.getNumInteriorRing() <= 0) {
            return;
        }
        IndexedNestedRingTester nestedTester = new IndexedNestedRingTester(graph);
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing innerHole = p.getInteriorRingN(i);
            if (innerHole.isEmpty()) continue;
            nestedTester.add(innerHole);
        }
        boolean isNonNested = nestedTester.isNonNested();
        if (!isNonNested) {
            this.validErr = new TopologyValidationError(3, nestedTester.getNestedPoint());
        }
    }

    private void checkShellsNotNested(MultiPolygon mp, GeometryGraph graph) {
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            Polygon p = (Polygon)mp.getGeometryN(i);
            LinearRing shell = p.getExteriorRing();
            for (int j = 0; j < mp.getNumGeometries(); ++j) {
                if (i == j) continue;
                Polygon p2 = (Polygon)mp.getGeometryN(j);
                this.checkShellNotNested(shell, p2, graph);
                if (this.validErr == null) continue;
                return;
            }
        }
    }

    private void checkShellNotNested(LinearRing shell, Polygon p, GeometryGraph graph) {
        Coordinate[] shellPts = shell.getCoordinates();
        LinearRing polyShell = p.getExteriorRing();
        if (polyShell.isEmpty()) {
            return;
        }
        Coordinate[] polyPts = polyShell.getCoordinates();
        Coordinate shellPt = IsValidOp.findPtNotNode(shellPts, polyShell, graph);
        if (shellPt == null) {
            return;
        }
        boolean insidePolyShell = PointLocation.isInRing(shellPt, polyPts);
        if (!insidePolyShell) {
            return;
        }
        if (p.getNumInteriorRing() <= 0) {
            this.validErr = new TopologyValidationError(7, shellPt);
            return;
        }
        Coordinate badNestedPt = null;
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            badNestedPt = this.checkShellInsideHole(shell, hole, graph);
            if (badNestedPt != null) continue;
            return;
        }
        this.validErr = new TopologyValidationError(7, badNestedPt);
    }

    private Coordinate checkShellInsideHole(LinearRing shell, LinearRing hole, GeometryGraph graph) {
        boolean insideHole;
        Coordinate[] shellPts = shell.getCoordinates();
        Coordinate[] holePts = hole.getCoordinates();
        Coordinate shellPt = IsValidOp.findPtNotNode(shellPts, hole, graph);
        if (shellPt != null && !(insideHole = PointLocation.isInRing(shellPt, holePts))) {
            return shellPt;
        }
        Coordinate holePt = IsValidOp.findPtNotNode(holePts, shell, graph);
        if (holePt != null) {
            boolean insideShell = PointLocation.isInRing(holePt, shellPts);
            if (insideShell) {
                return holePt;
            }
            return null;
        }
        Assert.shouldNeverReachHere("points in shell and hole appear to be equal");
        return null;
    }

    private void checkConnectedInteriors(GeometryGraph graph) {
        ConnectedInteriorTester cit = new ConnectedInteriorTester(graph);
        if (!cit.isInteriorsConnected()) {
            this.validErr = new TopologyValidationError(4, cit.getCoordinate());
        }
    }
}

