/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.spi;

import java.time.Instant;
import javax.measure.Quantity;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.spi.Measurement;
import tech.uom.lib.common.util.NumberComparator;

abstract class AbstractMeasurement<Q extends Quantity<Q>>
implements Measurement<Q>,
Comparable<Measurement<Q>> {
    private static final long serialVersionUID = 2417644773551236879L;
    private final Quantity<Q> quantity;
    private final Instant instant;

    protected AbstractMeasurement(Quantity<Q> q, Instant i) {
        this.quantity = q;
        this.instant = i;
    }

    protected AbstractMeasurement(Quantity<Q> q, long t) {
        this(q, Instant.ofEpochMilli(t));
    }

    protected AbstractMeasurement(Quantity<Q> q) {
        this(q, System.currentTimeMillis());
    }

    @Override
    public Quantity<Q> getQuantity() {
        return this.quantity;
    }

    @Override
    public final Instant getInstant() {
        return this.instant;
    }

    @Override
    public final long getTimestamp() {
        return this.instant.toEpochMilli();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMeasurement that = (AbstractMeasurement)o;
        return this.quantity.equals(that.quantity) && this.instant.equals(that.instant);
    }

    public int hashCode() {
        int result = this.quantity.hashCode();
        result = 31 * result + this.instant.hashCode();
        return result;
    }

    public String toString() {
        return "Measurement{quantity=" + this.quantity + ", instant=" + this.instant + '}';
    }

    static final class DefaultComparable<Q extends Quantity<Q>>
    extends AbstractMeasurement<Q> {
        private static final long serialVersionUID = -175450754835481596L;

        protected DefaultComparable(ComparableQuantity q, Instant i) {
            super(q, i);
        }

        protected DefaultComparable(ComparableQuantity q, long t) {
            super(q, t);
        }

        protected DefaultComparable(ComparableQuantity q) {
            super(q);
        }

        @Override
        public ComparableQuantity<Q> getQuantity() {
            return (ComparableQuantity)super.getQuantity();
        }

        @Override
        public int compareTo(Measurement<Q> m3) {
            if (m3 instanceof DefaultComparable) {
                return this.getQuantity().compareTo(m3.getQuantity()) + this.getInstant().compareTo(m3.getInstant());
            }
            return 0;
        }
    }

    static final class Default<Q extends Quantity<Q>>
    extends AbstractMeasurement<Q> {
        private static final long serialVersionUID = 823899472806334856L;

        protected Default(Quantity q, Instant i) {
            super(q, i);
        }

        protected Default(Quantity q, long t) {
            super(q, t);
        }

        protected Default(Quantity q) {
            super(q);
        }

        @Override
        public int compareTo(Measurement<Q> m3) {
            if (this.getQuantity().getUnit() instanceof AbstractUnit) {
                return ((AbstractUnit)this.getQuantity().getUnit()).compareTo(m3.getQuantity().getUnit()) + NumberComparator.getInstance().compare(this.getQuantity().getValue(), m3.getQuantity().getValue()) + this.getInstant().compareTo(m3.getInstant());
            }
            return NumberComparator.getInstance().compare(this.getQuantity().getValue(), m3.getQuantity().getValue()) + this.getInstant().compareTo(m3.getInstant());
        }
    }
}

