/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Taxon;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.StrictClockBranchRates;
import dr.evomodel.continuous.FullyConjugateMultivariateTraitLikelihood;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.continuous.NonPhylogeneticMultivariateTraitLikelihood;
import dr.evomodel.continuous.RestrictedPartials;
import dr.evomodel.continuous.SampledMultivariateTraitLikelihood;
import dr.evomodel.continuous.SemiConjugateMultivariateTraitLikelihood;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodelxml.treelikelihood.TreeTraitParserUtilities;
import dr.inference.distribution.MultivariateDistributionLikelihood;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.MultivariateDistribution;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.stats.DiscreteStatistics;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractMultivariateTraitLikelihood
extends AbstractModelLikelihood
implements TreeTraitProvider,
Citable {
    public static final String TRAIT_LIKELIHOOD = "multivariateTraitLikelihood";
    public static final String CONJUGATE_ROOT_PRIOR = "conjugateRootPrior";
    public static final String MODEL = "diffusionModel";
    public static final String TREE = "tree";
    public static final String CACHE_BRANCHES = "cacheBranches";
    public static final String REPORT_MULTIVARIATE = "reportAsMultivariate";
    public static final String CHECK = "check";
    public static final String USE_TREE_LENGTH = "useTreeLength";
    public static final String SCALE_BY_TIME = "scaleByTime";
    public static final String SUBSTITUTIONS = "substitutions";
    public static final String SAMPLING_DENSITY = "samplingDensity";
    public static final String INTEGRATE = "integrateInternalTraits";
    public static final String STANDARDIZE_TRAITS = "standardizeTraits";
    public static final String RECIPROCAL_RATES = "reciprocalRates";
    public static final String PRIOR_SAMPLE_SIZE = "priorSampleSize";
    public static final String PRIOR_PRECISION = "priorPrecision";
    public static final String RANDOM_SAMPLE = "randomSample";
    public static final String IGNORE_PHYLOGENY = "ignorePhylogeny";
    public static final String ASCERTAINMENT = "ascertainedTaxon";
    public static final String EXCHANGEABLE_TIPS = "exchangeableTips";
    public static final String DRIFT_MODELS = "driftModels";
    private BranchRateModel branchRateModel;
    public static final String STRENGTH_OF_SELECTION = "strengthOfSelection";
    public static final String OPTIMAL_TRAITS = "optimalTraits";
    private TreeTrait[] treeTraits = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("traitName", "The name of the trait for which a likelihood should be calculated"), new ElementRule("traitParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("delta", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true), AttributeRule.newBooleanRule("integrateInternalTraits", true), new ElementRule(MultivariateDistributionLikelihood.class, true), new ElementRule("conjugateRootPrior", new XMLSyntaxRule[]{new ElementRule("meanParameter", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("priorSampleSize", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})}, true), new ElementRule("ascertainedTaxon", new XMLSyntaxRule[]{new ElementRule(Taxon.class)}, true), new ElementRule(MultivariateDiffusionModel.class), new ElementRule(MutableTreeModel.class), new ElementRule(BranchRateModel.class, true), AttributeRule.newDoubleArrayRule("cut", true), AttributeRule.newBooleanRule("reportAsMultivariate", true), AttributeRule.newBooleanRule("useTreeLength", true), AttributeRule.newBooleanRule("scaleByTime", true), AttributeRule.newBooleanRule("reciprocalRates", true), AttributeRule.newBooleanRule("cacheBranches", true), AttributeRule.newIntegerRule("randomSample", true), AttributeRule.newBooleanRule("ignorePhylogeny", true), AttributeRule.newBooleanRule("exchangeableTips", true), AttributeRule.newBooleanRule("sampleMissingTraits", true), new ElementRule(Parameter.class, true), TreeTraitParserUtilities.randomizeRules((boolean)true), TreeTraitParserUtilities.jitterRules((boolean)true), new ElementRule("check", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true), new ElementRule("driftModels", new XMLSyntaxRule[]{new ElementRule(BranchRateModel.class, 1, Integer.MAX_VALUE)}, true), new ElementRule(RestrictedPartials.class, 0, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return AbstractMultivariateTraitLikelihood.TRAIT_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl;
            AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood;
            Object object;
            Object object2;
            Object object3;
            XMLObject xMLObject2;
            MultivariateDiffusionModel multivariateDiffusionModel = (MultivariateDiffusionModel)xMLObject.getChild(MultivariateDiffusionModel.class);
            MutableTreeModel mutableTreeModel = (MutableTreeModel)xMLObject.getChild(MutableTreeModel.class);
            boolean bl2 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.CACHE_BRANCHES, true);
            boolean bl3 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.INTEGRATE, false);
            boolean bl4 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.USE_TREE_LENGTH, false);
            boolean bl5 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.SCALE_BY_TIME, false);
            boolean bl6 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.RECIPROCAL_RATES, false);
            boolean bl7 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.REPORT_MULTIVARIATE, true);
            boolean bl8 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.STANDARDIZE_TRAITS, false);
            BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(BranchRateModel.class);
            List<BranchRateModel> list = AbstractMultivariateTraitLikelihood.parseDriftModels(xMLObject, multivariateDiffusionModel);
            List<BranchRateModel> list2 = AbstractMultivariateTraitLikelihood.parseOptimalValuesModels(xMLObject, multivariateDiffusionModel);
            BranchRateModel branchRateModel2 = null;
            if (xMLObject.hasChildNamed(AbstractMultivariateTraitLikelihood.STRENGTH_OF_SELECTION)) {
                xMLObject2 = xMLObject.getChild(AbstractMultivariateTraitLikelihood.STRENGTH_OF_SELECTION);
                branchRateModel2 = (BranchRateModel)xMLObject2.getChild(BranchRateModel.class);
            }
            xMLObject2 = new TreeTraitParserUtilities();
            TreeTraitParserUtilities.TraitsAndMissingIndices traitsAndMissingIndices = xMLObject2.parseTraitsFromTaxonAttributes(xMLObject, mutableTreeModel, bl3);
            CompoundParameter compoundParameter = traitsAndMissingIndices.traitParameter;
            List list3 = traitsAndMissingIndices.getMissingIndices();
            String string = traitsAndMissingIndices.traitName;
            Model model = null;
            if (xMLObject.hasChildNamed(AbstractMultivariateTraitLikelihood.SAMPLING_DENSITY)) {
                object3 = xMLObject.getChild(AbstractMultivariateTraitLikelihood.SAMPLING_DENSITY);
                model = (Model)((XMLObject)object3).getChild(Model.class);
            }
            object3 = null;
            if (xMLObject.hasChildNamed("delta")) {
                object2 = xMLObject.getChild("delta");
                object3 = (Parameter)((XMLObject)object2).getChild(Parameter.class);
            }
            if (bl8) {
                int n = compoundParameter.getParameter(0).getDimension();
                int n2 = compoundParameter.getParameterCount();
                object = new StringBuilder();
                ((StringBuilder)object).append("Traits have been standardized.  Use following to transform values back to original scale.\n");
                for (int i = 0; i < n; ++i) {
                    double[] dArray = new double[n2];
                    for (int j = 0; j < n2; ++j) {
                        dArray[j] = compoundParameter.getParameter(j).getParameterValue(i);
                    }
                    double d = DiscreteStatistics.mean(dArray);
                    double d2 = Math.sqrt(DiscreteStatistics.variance(dArray, d));
                    ((StringBuilder)object).append("\tDimension " + (i + 1) + ": multiply by " + d2 + " then add " + d + "\n");
                    for (int j = 0; j < n2; ++j) {
                        compoundParameter.getParameter(j).setParameterValue(i, (dArray[j] - d) / d2);
                    }
                }
                Logger.getLogger("dr.evomodel").info(((StringBuilder)object).toString());
            }
            object2 = AbstractMultivariateTraitLikelihood.parseRestrictedPartials(xMLObject, bl3);
            if (bl3) {
                Object object4;
                object = (MultivariateDistributionLikelihood)xMLObject.getChild(MultivariateDistributionLikelihood.class);
                if (object != null) {
                    if (!(((MultivariateDistributionLikelihood)object).getDistribution() instanceof MultivariateDistribution)) {
                        throw new XMLParseException("Only multivariate normal priors allowed for Gibbs sampling the root trait");
                    }
                    object4 = (MultivariateNormalDistribution)((MultivariateDistributionLikelihood)object).getDistribution();
                    abstractMultivariateTraitLikelihood = new SemiConjugateMultivariateTraitLikelihood(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, list3, bl2, bl5, bl4, branchRateModel, model, bl7, (MultivariateNormalDistribution)object4, bl6, (List<RestrictedPartials>)object2);
                } else {
                    object4 = xMLObject.getChild(AbstractMultivariateTraitLikelihood.CONJUGATE_ROOT_PRIOR);
                    if (object4 == null) {
                        throw new XMLParseException("Must specify a conjugate or multivariate normal root prior");
                    }
                    boolean bl9 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.IGNORE_PHYLOGENY, false);
                    Parameter parameter = (Parameter)((XMLObject)object4).getChild("meanParameter").getChild(Parameter.class);
                    if (parameter.getDimension() != multivariateDiffusionModel.getPrecisionmatrix().length) {
                        throw new XMLParseException("Root prior mean dimension does not match trait diffusion dimension");
                    }
                    Parameter parameter2 = (Parameter)((XMLObject)object4).getChild(AbstractMultivariateTraitLikelihood.PRIOR_SAMPLE_SIZE).getChild(Parameter.class);
                    double[] dArray = parameter.getParameterValues();
                    double d = parameter2.getParameterValue(0);
                    if (bl9) {
                        boolean bl10 = xMLObject.getAttribute(AbstractMultivariateTraitLikelihood.EXCHANGEABLE_TIPS, true);
                        abstractMultivariateTraitLikelihood = new NonPhylogeneticMultivariateTraitLikelihood(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, (Parameter)object3, (List<Integer>)list3, bl2, bl5, bl4, branchRateModel, model, bl7, dArray, d, (List<RestrictedPartials>)object2, bl6, bl10);
                    } else {
                        abstractMultivariateTraitLikelihood = list == null ? (branchRateModel2 == null ? new FullyConjugateMultivariateTraitLikelihood(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, (Parameter)object3, list3, bl2, bl5, bl4, branchRateModel, null, null, null, model, bl7, dArray, (List<RestrictedPartials>)object2, d, bl6) : new FullyConjugateMultivariateTraitLikelihood(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, (Parameter)object3, list3, bl2, bl5, bl4, branchRateModel, null, list2, branchRateModel2, model, bl7, dArray, (List<RestrictedPartials>)object2, d, bl6)) : new FullyConjugateMultivariateTraitLikelihood(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, (Parameter)object3, list3, bl2, bl5, bl4, branchRateModel, list, null, null, model, bl7, dArray, (List<RestrictedPartials>)object2, d, bl6);
                    }
                }
            } else {
                abstractMultivariateTraitLikelihood = new SampledMultivariateTraitLikelihood(string, mutableTreeModel, multivariateDiffusionModel, compoundParameter, list3, bl2, bl5, bl4, branchRateModel, model, bl7, bl6);
            }
            if (!bl3 && xMLObject.hasChildNamed("randomize")) {
                xMLObject2.randomize(xMLObject);
            }
            if (xMLObject.hasChildNamed("jitter")) {
                xMLObject2.jitter(xMLObject, multivariateDiffusionModel.getPrecisionmatrix().length, list3, compoundParameter.getDimension());
            }
            if (xMLObject.hasChildNamed(AbstractMultivariateTraitLikelihood.CHECK)) {
                object = xMLObject.getChild(AbstractMultivariateTraitLikelihood.CHECK);
                Parameter parameter = (Parameter)((XMLObject)object).getChild(Parameter.class);
                abstractMultivariateTraitLikelihood.check(parameter);
            }
            boolean bl11 = bl = branchRateModel != null && !(branchRateModel instanceof StrictClockBranchRates);
            if (!xMLObject.hasAttribute("allowIdentical") && bl && xMLObject2.hasIdenticalTraits(compoundParameter, list3, multivariateDiffusionModel.getPrecisionmatrix().length)) {
                throw new XMLParseException("For multivariate trait analyses, all trait values should be unique.\nCheck data or add random noise using 'jitter' option.");
            }
            if (xMLObject.hasChildNamed(AbstractMultivariateTraitLikelihood.ASCERTAINMENT)) {
                XMLObject xMLObject3 = xMLObject.getChild(AbstractMultivariateTraitLikelihood.ASCERTAINMENT);
                Taxon taxon = (Taxon)xMLObject3.getChild(Taxon.class);
                if (!bl3) {
                    throw new XMLParseException("Ascertainment correction is currently only implemented for integrated multivariate trait likelihood models");
                }
                abstractMultivariateTraitLikelihood.setAscertainedTaxon(taxon);
            }
            return abstractMultivariateTraitLikelihood;
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a continuous trait evolving on a tree by a given diffusion model.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return AbstractMultivariateTraitLikelihood.class;
        }
    };
    MutableTreeModel treeModel = null;
    MultivariateDiffusionModel diffusionModel = null;
    String traitName = null;
    CompoundParameter traitParameter;
    List<Integer> missingIndices;
    protected double logLikelihood;
    protected double maxLogLikelihood = Double.NEGATIVE_INFINITY;
    private double storedLogLikelihood;
    protected boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;
    protected List<BranchRateModel> driftModels = null;
    protected List<BranchRateModel> optimalValues = null;
    protected BranchRateModel strengthOfSelection = null;
    private boolean hasBranchRateModel = false;
    private double treeLength;
    private double storedTreeLength;
    private final boolean reportAsMultivariate;
    private final boolean scaleByTime;
    private final boolean useTreeLength;
    private final boolean reciprocalRates;
    protected boolean cacheBranches;
    protected double[] cachedLogLikelihoods;
    protected double[] storedCachedLogLikelihood;
    protected boolean[] validLogLikelihoods;
    protected boolean[] storedValidLogLikelihoods;
    private final Parameter deltaParameter;
    private boolean doAscertainmentCorrect = false;
    private int ascertainedTaxonIndex;
    protected int numData;
    protected int dimTrait;
    protected int dim;
    protected boolean updateRestrictedNodePartials = true;
    protected boolean savedUpdateRestrictedNodePartials;

    public AbstractMultivariateTraitLikelihood(String string, MutableTreeModel mutableTreeModel, MultivariateDiffusionModel multivariateDiffusionModel, CompoundParameter compoundParameter, Parameter parameter, List<Integer> list, boolean bl, boolean bl2, boolean bl3, BranchRateModel branchRateModel, List<BranchRateModel> list2, List<BranchRateModel> list3, BranchRateModel branchRateModel2, Model model, boolean bl4, boolean bl5) {
        super(TRAIT_LIKELIHOOD);
        this.traitName = string;
        this.treeModel = mutableTreeModel;
        this.branchRateModel = branchRateModel;
        this.driftModels = list2;
        this.optimalValues = list3;
        this.strengthOfSelection = branchRateModel2;
        this.diffusionModel = multivariateDiffusionModel;
        this.traitParameter = compoundParameter;
        this.missingIndices = list;
        this.addModel(mutableTreeModel);
        this.addModel(multivariateDiffusionModel);
        this.deltaParameter = parameter;
        if (parameter != null) {
            this.addVariable(parameter);
        }
        if (branchRateModel != null) {
            this.hasBranchRateModel = true;
            this.addModel(branchRateModel);
        }
        if (list2 != null) {
            for (BranchRateModel branchRateModel3 : list2) {
                this.addModel(branchRateModel3);
            }
        }
        if (list3 != null) {
            for (BranchRateModel branchRateModel3 : list3) {
                this.addModel(branchRateModel3);
            }
        }
        if (branchRateModel2 != null) {
            this.addModel(branchRateModel2);
        }
        if (model != null) {
            this.addModel(model);
        }
        if (compoundParameter != null) {
            this.addVariable(compoundParameter);
        }
        this.reportAsMultivariate = bl4;
        this.cacheBranches = bl;
        if (bl) {
            this.cachedLogLikelihoods = new double[mutableTreeModel.getNodeCount()];
            this.storedCachedLogLikelihood = new double[mutableTreeModel.getNodeCount()];
            this.validLogLikelihoods = new boolean[mutableTreeModel.getNodeCount()];
            this.storedValidLogLikelihoods = new boolean[mutableTreeModel.getNodeCount()];
        }
        this.scaleByTime = bl2;
        this.useTreeLength = bl3;
        this.reciprocalRates = bl5;
        this.dimTrait = multivariateDiffusionModel.getPrecisionmatrix().length;
        this.dim = compoundParameter != null ? compoundParameter.getParameter(0).getDimension() : 0;
        this.numData = this.dim / this.dimTrait;
        if (this.dim % this.dimTrait != 0) {
            throw new RuntimeException("dim is not divisible by dimTrait");
        }
        this.recalculateTreeLength();
        this.printInformtion();
    }

    protected void printInformtion() {
        StringBuffer stringBuffer = new StringBuffer("Creating multivariate diffusion model:\n");
        stringBuffer.append("\tTrait: ").append(this.traitName).append("\n");
        stringBuffer.append("\tDiffusion process: ").append(this.diffusionModel.getId()).append("\n");
        stringBuffer.append("\tHeterogenity model: ").append(this.branchRateModel != null ? this.branchRateModel.getId() : "homogeneous").append("\n");
        stringBuffer.append("\tTree normalization: ").append(this.scaleByTime ? (this.useTreeLength ? "length" : "height") : "off").append("\n");
        stringBuffer.append("\tUsing reciprocal (precision) rates: ").append(this.reciprocalRates).append("\n");
        if (this.scaleByTime) {
            this.recalculateTreeLength();
            if (this.useTreeLength) {
                stringBuffer.append("\tInitial tree length: ").append(this.treeLength).append("\n");
            } else {
                stringBuffer.append("\tInitial tree height: ").append(this.treeLength).append("\n");
            }
        }
        stringBuffer.append(this.extraInfo());
        stringBuffer.append("\tPlease cite:\n");
        stringBuffer.append(Citable.Utils.getCitationString(this));
        stringBuffer.append("\n\tDiffusion dimension   : ").append(this.dimTrait).append("\n");
        stringBuffer.append("\tNumber of observations: ").append(this.numData).append("\n");
        Logger.getLogger("dr.evomodel").info(stringBuffer.toString());
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Multivariate Diffusion model";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        arrayList.add(CommonCitations.LEMEY_2010_PHYLOGEOGRAPHY);
        if (this.doAscertainmentCorrect) {
            arrayList.add(new Citation(new Author[]{new Author("MA", "Suchard"), new Author("J", "Novembre"), new Author("B", "von Holdt"), new Author("G", "Cybis")}, Citation.Status.IN_PREPARATION));
        }
        return arrayList;
    }

    protected abstract String extraInfo();

    public CompoundParameter getTraitParameter() {
        return this.traitParameter;
    }

    public void setAscertainedTaxon(Taxon taxon) {
        this.ascertainedTaxonIndex = this.treeModel.getTaxonIndex(taxon);
        if (this.ascertainedTaxonIndex == -1) {
            throw new RuntimeException("Taxon " + taxon.getId() + " is not in tree " + this.treeModel.getId());
        }
        this.doAscertainmentCorrect = true;
        StringBuilder stringBuilder = new StringBuilder("Enabling ascertainment correction for multivariate trait model: ");
        stringBuilder.append(this.getId()).append("\n");
        stringBuilder.append("\tTaxon: ").append(taxon.getId()).append("\n");
        Logger.getLogger("dr.evomodel").info(stringBuilder.toString());
    }

    public double[] getShiftForBranchLength(NodeRef nodeRef) {
        if (this.driftModels != null) {
            int n = this.driftModels.size();
            double[] dArray = new double[n];
            double d = this.treeModel.getBranchLength(nodeRef);
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.driftModels.get(i).getBranchRate(this.treeModel, nodeRef) * d;
            }
            return dArray;
        }
        throw new RuntimeException("getShiftForBranchLength should not be called.");
    }

    public double[] getOptimalValue(NodeRef nodeRef) {
        if (this.optimalValues != null) {
            int n = this.optimalValues.size();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.optimalValues.get(i).getBranchRate(this.treeModel, nodeRef);
            }
            return dArray;
        }
        throw new RuntimeException("getOptimalValue should not be called.");
    }

    public double getTimeScaledSelection(NodeRef nodeRef) {
        if (this.strengthOfSelection != null) {
            double d = this.treeModel.getBranchLength(nodeRef);
            double d2 = this.strengthOfSelection.getBranchRate(this.treeModel, nodeRef) * d;
            return d2;
        }
        throw new RuntimeException("getTimeScaledSelection should not be called.");
    }

    protected double rescaleLength(double d) {
        if (this.scaleByTime) {
            d /= this.treeLength;
        }
        return d;
    }

    public double getRescaledBranchLengthForPrecision(NodeRef nodeRef) {
        double d = this.treeModel.getBranchLength(nodeRef);
        if (this.hasBranchRateModel) {
            d = this.reciprocalRates ? (d /= this.branchRateModel.getBranchRate(this.treeModel, nodeRef)) : (d *= this.branchRateModel.getBranchRate(this.treeModel, nodeRef));
        }
        d = this.rescaleLength(d);
        if (this.deltaParameter != null && this.treeModel.isExternal(nodeRef)) {
            d += this.deltaParameter.getParameterValue(0);
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (!this.cacheBranches) {
            this.likelihoodKnown = false;
            this.updateRestrictedNodePartials = true;
            if (model != this.treeModel) return;
            this.recalculateTreeLength();
            return;
        }
        if (model == this.diffusionModel) {
            this.updateAllNodes();
            return;
        }
        if (model == this.treeModel) {
            if (!(object instanceof TreeChangedEvent)) {
                if (!(object instanceof Parameter)) throw new RuntimeException("Unexpected object throwing events in AbstractMultivariateTraitLikelihood");
                return;
            }
            TreeChangedEvent treeChangedEvent = (TreeChangedEvent)object;
            if (treeChangedEvent.isTreeChanged()) {
                this.recalculateTreeLength();
                this.updateAllNodes();
                this.updateRestrictedNodePartials = true;
                return;
            }
            if (treeChangedEvent.isHeightChanged()) {
                this.recalculateTreeLength();
                if (this.useTreeLength || this.scaleByTime && this.treeModel.isRoot(treeChangedEvent.getNode())) {
                    this.updateAllNodes();
                    return;
                }
                this.updateNodeAndChildren(treeChangedEvent.getNode());
                return;
            }
            if (treeChangedEvent.isNodeParameterChanged()) {
                this.updateNodeAndChildren(treeChangedEvent.getNode());
                return;
            }
            if (!treeChangedEvent.isNodeChanged()) throw new RuntimeException("Unexpected TreeModel TreeChangedEvent occurring in AbstractMultivariateTraitLikelihood");
            this.recalculateTreeLength();
            if (this.useTreeLength || this.scaleByTime && this.treeModel.isRoot(treeChangedEvent.getNode())) {
                this.updateAllNodes();
            } else {
                this.updateNodeAndChildren(treeChangedEvent.getNode());
            }
            this.updateRestrictedNodePartials = true;
            return;
        }
        if (model != this.branchRateModel) {
            if (!(model instanceof RestrictedPartials)) throw new RuntimeException("Unknown componentChangedEvent");
            this.updateAllNodes();
            this.updateRestrictedNodePartials = true;
            return;
        }
        if (n == -1) {
            this.updateAllNodes();
            return;
        }
        if (object != null && ((Parameter)object).getDimension() != 2 * (this.treeModel.getNodeCount() - 1)) {
            this.updateAllNodes();
            return;
        }
        this.updateNode(this.treeModel.getNode(n));
    }

    protected void updateAllNodes() {
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            this.validLogLikelihoods[i] = false;
        }
        this.likelihoodKnown = false;
    }

    private void updateNode(NodeRef nodeRef) {
        this.validLogLikelihoods[nodeRef.getNumber()] = false;
        this.likelihoodKnown = false;
    }

    private void updateNodeAndChildren(NodeRef nodeRef) {
        this.validLogLikelihoods[nodeRef.getNumber()] = false;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            this.validLogLikelihoods[this.treeModel.getChild((NodeRef)nodeRef, (int)i).getNumber()] = false;
        }
        this.likelihoodKnown = false;
    }

    protected double getTreeLength() {
        double d = 0.0;
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getNode(i);
            if (this.treeModel.isRoot(nodeRef)) continue;
            d += this.treeModel.getBranchLength(nodeRef);
        }
        return d;
    }

    public void recalculateTreeLength() {
        if (!this.scaleByTime) {
            return;
        }
        this.treeLength = this.useTreeLength ? this.getTreeLength() : this.treeModel.getNodeHeight(this.treeModel.getRoot());
    }

    public BranchRateModel getBranchRateModel() {
        return this.branchRateModel;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.deltaParameter) {
            this.likelihoodKnown = false;
        }
        if (variable == this.traitParameter) {
            this.likelihoodKnown = false;
        }
        if (!this.cacheBranches) {
            this.likelihoodKnown = false;
        }
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
        this.storedTreeLength = this.treeLength;
        if (this.cacheBranches) {
            System.arraycopy(this.cachedLogLikelihoods, 0, this.storedCachedLogLikelihood, 0, this.treeModel.getNodeCount());
            System.arraycopy(this.validLogLikelihoods, 0, this.storedValidLogLikelihoods, 0, this.treeModel.getNodeCount());
        }
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        this.treeLength = this.storedTreeLength;
        if (this.cacheBranches) {
            double[] dArray = this.storedCachedLogLikelihood;
            this.storedCachedLogLikelihood = this.cachedLogLikelihoods;
            this.cachedLogLikelihoods = dArray;
            boolean[] blArray = this.storedValidLogLikelihoods;
            this.storedValidLogLikelihoods = this.validLogLikelihoods;
            this.validLogLikelihoods = blArray;
        }
        this.updateRestrictedNodePartials = true;
    }

    @Override
    protected void acceptState() {
    }

    public MutableTreeModel getTreeModel() {
        return this.treeModel;
    }

    public String getTraitName() {
        return this.traitName;
    }

    public MultivariateDiffusionModel getDiffusionModel() {
        return this.diffusionModel;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            if (this.doAscertainmentCorrect) {
                double d = this.calculateAscertainmentCorrection(this.ascertainedTaxonIndex);
                this.logLikelihood -= d;
            }
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    protected abstract double calculateAscertainmentCorrection(int var1);

    public abstract double getLogDataLikelihood();

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        if (this.cacheBranches) {
            this.updateAllNodes();
        }
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new AbstractModelLikelihood.LikelihoodColumn(this, this.getId() + ".joint"), new NumberColumn(this.getId() + ".data"){

            @Override
            public double getDoubleValue() {
                return AbstractMultivariateTraitLikelihood.this.getLogDataLikelihood();
            }
        }};
    }

    public abstract double calculateLogLikelihood();

    @Override
    public TreeTrait[] getTreeTraits() {
        if (this.treeTraits == null) {
            double[] dArray = this.getRootNodeTrait();
            if (dArray.length == 1 || this.reportAsMultivariate) {
                this.treeTraits = new TreeTrait[]{new TreeTrait.DA(){

                    @Override
                    public String getTraitName() {
                        return AbstractMultivariateTraitLikelihood.this.traitName;
                    }

                    @Override
                    public TreeTrait.Intent getIntent() {
                        return TreeTrait.Intent.NODE;
                    }

                    @Override
                    public Class getTraitClass() {
                        return Double.class;
                    }

                    @Override
                    public double[] getTrait(Tree tree, NodeRef nodeRef) {
                        return AbstractMultivariateTraitLikelihood.this.getTraitForNode(tree, nodeRef, AbstractMultivariateTraitLikelihood.this.traitName);
                    }
                }};
            } else {
                throw new RuntimeException("Reporting of traits is only supported as multivariate");
            }
        }
        return this.treeTraits;
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        TreeTrait[] treeTraitArray;
        for (TreeTrait treeTrait : treeTraitArray = this.getTreeTraits()) {
            if (!treeTrait.getTraitName().equals(string)) continue;
            return treeTrait;
        }
        return null;
    }

    public final int getNumData() {
        return this.numData;
    }

    public final int getDimTrait() {
        return this.dimTrait;
    }

    protected double[] getRootNodeTrait() {
        return this.treeModel.getMultivariateNodeTrait(this.treeModel.getRoot(), this.traitName);
    }

    public abstract double[] getTraitForNode(Tree var1, NodeRef var2, String var3);

    public void check(Parameter parameter) throws XMLParseException {
        this.diffusionModel.check(parameter);
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    public static List<BranchRateModel> parseDriftModels(XMLObject xMLObject, MultivariateDiffusionModel multivariateDiffusionModel) throws XMLParseException {
        ArrayList<BranchRateModel> arrayList = null;
        if (xMLObject.hasChildNamed(DRIFT_MODELS)) {
            arrayList = new ArrayList<BranchRateModel>();
            XMLObject xMLObject2 = xMLObject.getChild(DRIFT_MODELS);
            int n = xMLObject2.getChildCount();
            if (n != multivariateDiffusionModel.getPrecisionmatrix().length) {
                throw new XMLParseException("Wrong number of drift models (" + n + ") for a trait of dimension " + multivariateDiffusionModel.getPrecisionmatrix().length + " in " + xMLObject.getId());
            }
            for (int i = 0; i < n; ++i) {
                arrayList.add((BranchRateModel)xMLObject2.getChild(i));
            }
        }
        return arrayList;
    }

    public static List<BranchRateModel> parseOptimalValuesModels(XMLObject xMLObject, MultivariateDiffusionModel multivariateDiffusionModel) throws XMLParseException {
        ArrayList<BranchRateModel> arrayList = null;
        if (xMLObject.hasChildNamed(OPTIMAL_TRAITS)) {
            arrayList = new ArrayList<BranchRateModel>();
            XMLObject xMLObject2 = xMLObject.getChild(OPTIMAL_TRAITS);
            int n = xMLObject2.getChildCount();
            if (n != multivariateDiffusionModel.getPrecisionmatrix().length) {
                throw new XMLParseException("Wrong number of optimal trait models (" + n + ") for a trait of dimension " + multivariateDiffusionModel.getPrecisionmatrix().length + " in " + xMLObject.getId());
            }
            for (int i = 0; i < n; ++i) {
                arrayList.add((BranchRateModel)xMLObject2.getChild(i));
            }
        }
        return arrayList;
    }

    public static List<RestrictedPartials> parseRestrictedPartials(XMLObject xMLObject, boolean bl) throws XMLParseException {
        ArrayList<RestrictedPartials> arrayList = null;
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Object object = xMLObject.getChild(i);
            if (!(object instanceof RestrictedPartials)) continue;
            if (!bl) {
                throw new XMLParseException("Restricted partials are currently only implementsfor integrated multivariate trait likelihood models");
            }
            if (arrayList == null) {
                arrayList = new ArrayList<RestrictedPartials>();
            }
            arrayList.add((RestrictedPartials)object);
        }
        return arrayList;
    }

    protected void addRestrictedPartials(RestrictedPartials restrictedPartials) {
        throw new IllegalArgumentException("Not implemented for this model type");
    }
}

