/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LogicalTransactionId;
import oracle.jdbc.driver.NTFLTXIDEvent;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.ReplayContext;
import oracle.jdbc.driver.StateSignatures;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIkvarr;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.T4CTTIqcinv;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
abstract class T4CTTIfun
extends T4CTTIMsg {
    static final short OOPEN = 2;
    static final short OFETCH = 5;
    static final short OCLOSE = 8;
    static final short OLOGOFF = 9;
    static final short OCOMON = 12;
    static final short OCOMOFF = 13;
    static final short OCOMMIT = 14;
    static final short OROLLBACK = 15;
    static final short OCANCEL = 20;
    static final short ODSCRARR = 43;
    static final short OVERSION = 59;
    static final short OK2RPC = 67;
    static final short OALL7 = 71;
    static final short OSQL7 = 74;
    static final short OEXFEN = 78;
    static final short O3LOGON = 81;
    static final short O3LOGA = 82;
    static final short OKOD = 92;
    static final short OALL8 = 94;
    static final short OLOBOPS = 96;
    static final short ODNY = 98;
    static final short OTXSE = 103;
    static final short OTXEN = 104;
    static final short OCCA = 105;
    static final short O80SES = 107;
    static final short ODSY = 119;
    static final short OAUTH = 115;
    static final short OSESSKEY = 118;
    static final short OCANA = 120;
    static final short OKPN = 125;
    static final short OOTCM = 127;
    static final short OSCID = 135;
    static final short OSPFPPUT = 138;
    static final short OKPFC = 139;
    static final short OPING = 147;
    static final short OKEYVAL = 154;
    static final short OXSSCS = 155;
    static final short OXSSRO = 156;
    static final short OXSSPO = 157;
    static final short OAQEQ = 121;
    static final short OAQDQ = 122;
    static final short OAQGPS = 132;
    static final short OAQLS = 126;
    static final short OAQXQ = 145;
    static final short OSESSGET = 162;
    static final short OSESSRLS = 163;
    static final short OQCSTA = 167;
    static final short OQCID = 168;
    static final short OXSNSO = 172;
    static final short OXSNS = 178;
    static final short OXSSYNC = 176;
    static final short OXSATT = 180;
    static final short OXSCRE = 179;
    static final short OXSDET = 181;
    static final short OXSDES = 182;
    static final short OXSSET = 183;
    static final short OSESSSTATE = 176;
    static final short OAPPCONTREPLAY = 177;
    static final short OAQENQ = 184;
    static final short OAQDEQ = 185;
    static final short OAQEMNDEQ = 186;
    static final short OAQNFY = 187;
    static final short OCHUNKINFO = 190;
    private short funCode;
    protected final T4CTTIoer11 oer;
    int receiveState = 0;
    static final int IDLE_RECEIVE_STATE = 0;
    static final int ACTIVE_RECEIVE_STATE = 1;
    static final int READROW_RECEIVE_STATE = 2;
    static final int STREAM_RECEIVE_STATE = 3;
    boolean rpaProcessed = false;
    boolean rxhProcessed = false;
    boolean iovProcessed = false;
    private final short[] ttiList;
    private int ttiListEnd = 0;
    ReplayContext replayContext = null;
    StateSignatures stateSignatures = null;

    T4CTTIfun(T4CConnection t4CConnection, byte by) {
        super(t4CConnection, by);
        this.oer = t4CConnection.getT4CTTIoer();
        this.ttiList = t4CConnection.ttiList;
    }

    final void setFunCode(short s2) {
        this.funCode = s2;
    }

    final short getFunCode() {
        return this.funCode;
    }

    private final void marshalFunHeader() throws IOException {
        this.connection.setExecutingRPCFunctionCode(this.funCode);
        this.marshalTTCcode();
        this.meg.marshalUB1(this.funCode);
        this.meg.marshalUB1(this.connection.getNextSeqNumber());
    }

    abstract void marshal() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void doRPC() throws IOException, SQLException {
        if (this.getTTCCode() == 17) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        if (this.connection.isResultSetCacheActive()) {
            this.connection.enterMarshalling();
            this.meg.marshalUB1((short)24);
            this.connection.kpdqidcscn.setSCN(this.connection.getResultSetCacheVisibleSCN());
            this.connection.kpdqidcscn.marshal();
            this.connection.exitMarshalling();
        }
        this.connection.sendPiggyBackedMessages();
        for (int i2 = 0; i2 < 5; ++i2) {
            this.init();
            this.connection.enterMarshalling();
            this.marshalFunHeader();
            try {
                this.connection.pipeState = 1;
                this.marshal();
                this.connection.pipeState = 2;
                this.receive();
                this.connection.exitMarshalling();
                return;
            }
            catch (SQLException sQLException) {
                Object object = this.connection.cancelInProgressLockForThin;
                synchronized (object) {
                    block13: {
                        this.redoCursorClose();
                        if (!this.canReplay(sQLException)) break block13;
                        continue;
                    }
                    throw sQLException;
                }
            }
            finally {
                this.connection.pipeState = -1;
                this.connection.lastPiggyBackCursorCloseSeqNumber = 0;
            }
        }
    }

    final void doPigRPC() throws IOException {
        this.init();
        this.connection.enterMarshalling();
        this.marshalFunHeader();
        this.marshal();
        this.connection.exitMarshalling();
    }

    final void doOneWayRPC() throws IOException, SQLException {
        this.connection.sendPiggyBackedMessages();
        this.init();
        this.connection.enterMarshalling();
        this.marshalFunHeader();
        this.marshal();
        this.meg.flush();
        this.connection.exitMarshalling();
    }

    private void init() {
        this.rpaProcessed = false;
        this.rxhProcessed = false;
        this.iovProcessed = false;
        this.ttiListEnd = 0;
    }

    void resumeReceive() throws SQLException, IOException {
        this.receive();
    }

    private final String ttiListString() {
        String string = "[ ";
        for (int i2 = 0; i2 < this.ttiListEnd; ++i2) {
            string = string + this.ttiList[i2] + ", ";
        }
        string = string + "]";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void receive() throws SQLException, IOException {
        this.receiveState = 1;
        this.replayContext = null;
        this.stateSignatures = null;
        try {
            var1_1 = null;
            block37: while (true) lbl-1000:
            // 19 sources

            {
                try {
                    var2_5 = this.meg.unmarshalUB1();
                    if (this.ttiListEnd < this.ttiList.length) {
                        this.ttiList[this.ttiListEnd++] = var2_5;
                    }
                    switch (var2_5) {
                        case 8: {
                            if (this.rpaProcessed) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
                            }
                            this.readRPA();
                            try {
                                this.processRPA();
                            }
                            catch (SQLException var3_7) {
                                var1_1 = var3_7;
                            }
                            this.rpaProcessed = true;
                            ** break;
                        }
                        case 21: {
                            this.readBVC();
                            ** break;
                        }
                        case 11: {
                            this.readIOV();
                            this.iovProcessed = true;
                            ** break;
                        }
                        case 6: {
                            this.readRXH();
                            this.rxhProcessed = true;
                            ** break;
                        }
                        case 12: {
                            this.processSLG();
                            ** break;
                        }
                        case 7: {
                            this.receiveState = 2;
                            if (this.readRXD()) {
                                this.receiveState = 3;
                                return;
                            }
                            this.receiveState = 1;
                            ** break;
                        }
                        case 16: {
                            this.readDCB();
                            ** break;
                        }
                        case 14: {
                            this.readLOBD();
                            ** break;
                        }
                        case 25: {
                            this.readRSH();
                            ** break;
                        }
                        case 23: {
                            this.readSPF();
                            ** break;
                        }
                        case 19: {
                            this.meg.marshalUB1((short)19);
                            ** break;
                        }
                        case 27: {
                            this.readIMPLRES();
                            ** break;
                        }
                        case 15: {
                            this.oer.init();
                            this.oer.unmarshalWarning();
                            try {
                                this.oer.processWarning();
                            }
                            catch (SQLWarning var3_8) {
                                this.connection.setWarnings(DatabaseError.addSqlWarning(this.connection.getWarnings(), var3_8));
                            }
                            continue block37;
                        }
                        case 9: {
                            this.processEOCS();
                            if (this.connection.getTTCVersion() >= 3) {
                                this.connection.endToEndECIDSequenceNumber = var3_9 = (short)this.meg.unmarshalUB2();
                            }
                            break block37;
                        }
                        case 13: {
                            this.readOAC();
                            ** break;
                        }
                        case 4: {
                            this.processEOCS();
                            this.oer.init();
                            this.oer.unmarshal();
                            try {
                                if (this.oer.callNumber == this.connection.currentTTCSeqNumber) {
                                    this.processError();
                                    break block37;
                                }
                                this.oer.processError(true);
                            }
                            catch (SQLException var3_10) {
                                var1_1 = var3_10;
                            }
                            break block37;
                        }
                        case 28: {
                            this.connection.reNegotiateTTCProDty();
                            ** break;
                        }
                        default: {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttiListString()).fillInStackTrace();
                        }
                    }
                }
                catch (BreakNetException var3_11) {
                    continue;
                }
                finally {
                    this.connection.sentCancel = false;
                    continue;
                }
                break;
            }
            this.receiveState = 0;
            if (var1_1 != null) {
                throw var1_1;
            }
        }
        catch (SQLRecoverableException var1_2) {
            throw var1_2;
        }
        catch (IOException var1_3) {
            if (this.replayContext != null) {
                this.handleReplayContext(this.replayContext);
            }
            if (this.stateSignatures != null) {
                this.handleStateSignatures(this.stateSignatures);
            }
            throw var1_3;
        }
        catch (SQLException var1_4) {
            if (this.replayContext != null) {
                this.handleReplayContext(this.replayContext);
            }
            if (this.stateSignatures != null) {
                this.handleStateSignatures(this.stateSignatures);
            }
            this.connection.setExecutingRPCFunctionCode((short)0);
            this.connection.setExecutingRPCSQL(null);
            throw var1_4;
        }
        if (this.replayContext != null) {
            this.handleReplayContext(this.replayContext);
        }
        if (this.stateSignatures != null) {
            this.handleStateSignatures(this.stateSignatures);
        }
        this.connection.setExecutingRPCFunctionCode((short)0);
        this.connection.setExecutingRPCSQL(null);
    }

    private final void handleReplayContext(ReplayContext replayContext) {
        if (this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.NONREQUEST)) {
            return;
        }
        assert ((replayContext.flags_kpdxcAppContCtl & 4L) != 0L || replayContext.errcode_kpdxcAppContCtl != 41406L || !this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) : "Server disabled replay with error " + replayContext.errcode_kpdxcAppContCtl + " but our replayModes=" + this.connection.replayModes;
        assert (replayContext.replayctx_kpdxcAppContCtl == null || replayContext.replayctx_kpdxcAppContCtl.length <= 0 || this.connection.getExecutingRPCFunctionCode() == 115 || this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) : "Server is sending a non-null replay context but our replayModes=" + this.connection.replayModes;
        if (this.connection.thinACReplayContextReceived.length == this.connection.thinACReplayContextReceivedCurrent) {
            ReplayContext[] replayContextArray = new ReplayContext[this.connection.thinACReplayContextReceived.length * 2];
            System.arraycopy(this.connection.thinACReplayContextReceived, 0, replayContextArray, 0, this.connection.thinACReplayContextReceived.length);
            this.connection.thinACReplayContextReceived = replayContextArray;
        }
        this.connection.thinACReplayContextReceived[this.connection.thinACReplayContextReceivedCurrent++] = replayContext;
        if ((replayContext.flags_kpdxcAppContCtl & 4L) == 0L && this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED)) {
            this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_REPLAY_ENABLED);
            this.connection.replayModes.remove((Object)T4CConnection.ReplayMode.RUNTIME_OR_REPLAYING_STATIC);
        }
        if (!(replayContext.replayctx_kpdxcAppContCtl == null || replayContext.replayctx_kpdxcAppContCtl.length <= 0 || this.connection.getExecutingRPCFunctionCode() == 115 && this.connection.ignoreReplayContextFromAuthentication)) {
            this.connection.thinACLastReplayContextReceived = replayContext;
        }
    }

    private final void handleStateSignatures(StateSignatures stateSignatures) {
        this.connection.setStateSignatures(stateSignatures);
    }

    private final void processEOCS() throws SQLException, IOException {
        if (this.connection.hasServerCompileTimeCapability(15, 1)) {
            int n2;
            this.connection.eocs = n2 = (int)this.meg.unmarshalUB4();
            if ((n2 & 8) != 0) {
                long l2 = this.meg.unmarshalSB8();
            }
            if ((n2 & 0x800) != 0) {
                this.connection.setNeedsToBeClosed(true);
            }
        }
    }

    void processRPA() throws SQLException {
    }

    void readOAC() throws SQLException, IOException {
    }

    void readRSH() throws IOException, SQLException {
    }

    void readRPA() throws IOException, SQLException {
    }

    void readBVC() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readLOBD() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readIOV() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readRXH() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    boolean readRXD() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readIMPLRES() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void readDCB() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    void processSLG() throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
    }

    private final void readSPF() throws IOException, SQLException {
        byte by = (byte)this.meg.unmarshalUB1();
        switch (by) {
            case 1: {
                int n2 = this.meg.unmarshalUB2();
                byte by2 = (byte)this.meg.unmarshalUB1();
                for (int i2 = 0; i2 < n2; ++i2) {
                    T4CTTIqcinv[] t4CTTIqcinvArray;
                    int n3;
                    T4CTTIqcinv[] t4CTTIqcinvArray2;
                    int n4;
                    this.connection.kpdqidcscn.unmarshal();
                    int n5 = this.meg.unmarshalSWORD();
                    if (n5 > 0) {
                        n4 = this.meg.unmarshalUB1();
                        t4CTTIqcinvArray2 = new T4CTTIqcinv[n5];
                        for (n3 = 0; n3 < n5; ++n3) {
                            t4CTTIqcinvArray2[n3] = new T4CTTIqcinv(this.connection);
                            t4CTTIqcinvArray2[n3].unmarshal();
                            this.connection.getResultSetCacheInternal().processCommittedInvalidation(t4CTTIqcinvArray2[n3]);
                        }
                    } else {
                        t4CTTIqcinvArray2 = null;
                    }
                    this.connection.getResultSetCacheLocalInvalidations().clear();
                    n4 = this.meg.unmarshalSWORD();
                    if (n4 > 0) {
                        n3 = (byte)this.meg.unmarshalUB1();
                        t4CTTIqcinvArray = new T4CTTIqcinv[n4];
                        for (int i3 = 0; i3 < n4; ++i3) {
                            t4CTTIqcinvArray[i3] = new T4CTTIqcinv(this.connection);
                            t4CTTIqcinvArray[i3].unmarshal();
                            this.connection.getResultSetCacheLocalInvalidations().add(t4CTTIqcinvArray[i3].kpdqcqid);
                        }
                    } else {
                        t4CTTIqcinvArray = null;
                    }
                    long l2 = this.meg.unmarshalUB4();
                    this.connection.setResultSetCacheVisibleSCN(this.connection.kpdqidcscn.getSCN());
                }
                break;
            }
            case 2: {
                int n6 = this.meg.unmarshalUB2();
                byte by3 = (byte)this.meg.unmarshalUB1();
                byte[] byArray = this.meg.unmarshalNBytes(n6);
                break;
            }
            case 4: {
                this.connection.ocsessret.receive();
                break;
            }
            case 5: {
                int n7 = this.meg.unmarshalUB2();
                byte by4 = (byte)this.meg.unmarshalUB1();
                T4CTTIkvarr t4CTTIkvarr = new T4CTTIkvarr(this.connection);
                t4CTTIkvarr.unmarshal();
                break;
            }
            case 7: {
                LogicalTransactionId logicalTransactionId;
                byte[] byArray = this.meg.unmarshalDALC();
                int n8 = Arrays.hashCode(byArray);
                if (this.connection.thinACLastLtxidHash == n8) break;
                this.connection.thinACCurrentLTXID = logicalTransactionId = new LogicalTransactionId(byArray);
                NTFLTXIDEvent nTFLTXIDEvent = new NTFLTXIDEvent(this.connection, logicalTransactionId);
                this.connection.notify(nTFLTXIDEvent);
                this.connection.thinACLastLtxidHash = n8;
                break;
            }
            case 9: {
                int n9 = this.meg.unmarshalUB2();
                byte by5 = (byte)this.meg.unmarshalUB1();
                for (int i4 = 0; i4 < n9; ++i4) {
                    NTFXSEvent nTFXSEvent = new NTFXSEvent(this.connection);
                    this.connection.notify(nTFXSEvent);
                }
                break;
            }
            case 8: {
                int n10 = this.meg.unmarshalUB2();
                byte by6 = (byte)this.meg.unmarshalUB1();
                long l3 = this.meg.unmarshalUB4();
                long l4 = this.meg.unmarshalUB4();
                short s2 = this.meg.unmarshalUB1();
                byte[] byArray = this.meg.unmarshalDALC();
                this.replayContext = new ReplayContext(l3, s2, byArray, l4);
                break;
            }
            case 10: {
                int n11 = this.meg.unmarshalUB2();
                byte by7 = (byte)this.meg.unmarshalUB1();
                long l5 = this.meg.unmarshalSB8();
                long l6 = this.meg.unmarshalSB8();
                long l7 = this.meg.unmarshalSB8();
                this.stateSignatures = new StateSignatures(l5, l6, l7);
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401, this.ttiListString()).fillInStackTrace();
            }
        }
    }

    void processError() throws SQLException {
        this.oer.processError();
    }

    final long getErrorCode() throws SQLException {
        return this.oer.retCode;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private void redoCursorClose() {
        if (this.connection.lastPiggyBackCursorCloseSeqNumber != 0 && this.oer.callNumber != this.connection.currentTTCSeqNumber) {
            short s2;
            short s3 = s2 = this.oer.callNumber == 127 ? (short)1 : (short)(this.oer.callNumber + 1);
            while (s2 != this.connection.currentTTCSeqNumber) {
                if (this.connection.lastPiggyBackCursorCloseSeqNumber == s2) {
                    this.connection.redoCursorClose();
                    break;
                }
                if (s2 == 127) {
                    s2 = 1;
                    continue;
                }
                s2 = (short)(s2 + 1);
            }
        }
    }

    private boolean canReplay(SQLException sQLException) {
        boolean bl = false;
        if (sQLException.getErrorCode() == 1013 || this.connection.cancelInProgressFlag && sQLException.getMessage() != null && sQLException.getMessage().contains("ORA-01013")) {
            this.connection.cancelInProgressFlag = false;
            if (this.funCode == 15 || this.funCode == 12 || this.funCode == 13 || this.funCode == 14 || this.funCode == 59) {
                if (this.oer.callNumber != this.connection.currentTTCSeqNumber || this.connection.statementCancel) {
                    bl = true;
                }
            } else if (this.connection.statementCancel && (this.connection.currentTTCSeqNumber > this.oer.callNumber || this.connection.currentTTCSeqNumber < this.oer.callNumber && this.oer.callNumber + 5 > 127)) {
                bl = true;
            }
        }
        return bl;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

