/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class UniformDist
extends ContinuousDistribution {
    private double a;
    private double b;

    public UniformDist() {
        this.setParams(0.0, 1.0);
    }

    public UniformDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return UniformDist.density(this.a, this.b, d);
    }

    public double cdf(double d) {
        return UniformDist.cdf(this.a, this.b, d);
    }

    public double barF(double d) {
        return UniformDist.barF(this.a, this.b, d);
    }

    public double inverseF(double d) {
        return UniformDist.inverseF(this.a, this.b, d);
    }

    public double getMean() {
        return UniformDist.getMean(this.a, this.b);
    }

    public double getVariance() {
        return UniformDist.getVariance(this.a, this.b);
    }

    public double getStandardDeviation() {
        return UniformDist.getStandardDeviation(this.a, this.b);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= d) {
            throw new IllegalArgumentException("b <= a");
        }
        if (d3 <= d || d3 >= d2) {
            return 0.0;
        }
        return 1.0 / (d2 - d);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= d) {
            throw new IllegalArgumentException("b <= a");
        }
        if (d3 <= d) {
            return 0.0;
        }
        if (d3 >= d2) {
            return 1.0;
        }
        return (d3 - d) / (d2 - d);
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= d) {
            throw new IllegalArgumentException("b <= a");
        }
        if (d3 <= d) {
            return 1.0;
        }
        if (d3 >= d2) {
            return 0.0;
        }
        return (d2 - d3) / (d2 - d);
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d2 <= d) {
            throw new IllegalArgumentException("b <= a");
        }
        if (d3 > 1.0 || d3 < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (d3 <= 0.0) {
            return d;
        }
        if (d3 >= 1.0) {
            return d2;
        }
        return d + (d2 - d) * d3;
    }

    public static double[] getMLE(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray2 = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < n; ++i) {
            if (dArray[i] < dArray2[0]) {
                dArray2[0] = dArray[i];
            }
            if (!(dArray[i] > dArray2[1])) continue;
            dArray2[1] = dArray[i];
        }
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return UniformDist.getMLE(dArray, n);
    }

    public static UniformDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = UniformDist.getMaximumLikelihoodEstimate(dArray, n);
        return new UniformDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d2 <= d) {
            throw new IllegalArgumentException("b <= a");
        }
        return (d + d2) / 2.0;
    }

    public static double getVariance(double d, double d2) {
        if (d2 <= d) {
            throw new IllegalArgumentException("b <= a");
        }
        return (d2 - d) * (d2 - d) / 12.0;
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(UniformDist.getVariance(d, d2));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public void setParams(double d, double d2) {
        if (d2 <= d) {
            throw new IllegalArgumentException("b <= a");
        }
        this.a = d;
        this.b = d2;
        this.supportA = d;
        this.supportB = d2;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.a, this.b};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : a = " + this.a + ", b = " + this.b;
    }
}

