/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.benchmarking.SaBenchmarkingResults;
import ec.satoolkit.diagnostics.StationaryVarianceDecomposition;
import ec.satoolkit.x11.X11Results;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.algorithm.SingleTsData;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class GenericSaResults
implements IProcResults {
    private final PreprocessingModel regarima;
    private final ISaResults decomposition;
    private final ISeriesDecomposition finals;
    private StationaryVarianceDecomposition varDecomposition;
    public static final String METHOD = "method";
    public static final String VARIANCE = "variancedecomposition";
    public static final String CYCLE = "cycle";
    public static final String SEASONAL = "seasonality";
    public static final String IRREGULAR = "irregular";
    public static final String TD = "tdh";
    public static final String OTHERS = "others";
    public static final String TOTAL = "total";
    private static final InformationMapping<GenericSaResults> MAPPING = new InformationMapping<GenericSaResults>(GenericSaResults.class);

    public static SingleTsData getInput(CompositeResults rslts) {
        if (rslts == null) {
            return null;
        }
        return rslts.get("input", SingleTsData.class);
    }

    public static ISeriesDecomposition getFinalDecomposition(CompositeResults rslts) {
        if (rslts == null) {
            return null;
        }
        return rslts.get("final", ISeriesDecomposition.class);
    }

    public static PreprocessingModel getPreprocessingModel(CompositeResults rslts) {
        if (rslts == null) {
            return null;
        }
        return rslts.get("preprocessing", PreprocessingModel.class);
    }

    public static <S extends ISaResults> S getDecomposition(CompositeResults rslts, Class<S> sclass) {
        if (rslts == null) {
            return null;
        }
        return (S)((ISaResults)rslts.get("decomposition", sclass));
    }

    public static SaBenchmarkingResults getBenchmarking(CompositeResults rslts) {
        if (rslts == null) {
            return null;
        }
        return rslts.get("benchmarking", SaBenchmarkingResults.class);
    }

    public static GenericSaResults of(PreprocessingModel regarima, ISaResults decomposition, ISeriesDecomposition finals) {
        if (decomposition == null || finals == null) {
            return null;
        }
        return new GenericSaResults(regarima, decomposition, finals);
    }

    private GenericSaResults(PreprocessingModel regarima, ISaResults decomposition, ISeriesDecomposition finals) {
        this.regarima = regarima;
        this.decomposition = decomposition;
        this.finals = finals;
    }

    public StationaryVarianceDecomposition varDecomposition() {
        if (this.varDecomposition == null) {
            TsData O = this.regarima == null ? this.regarima.getData("yc", TsData.class) : this.finals.getData("y", TsData.class);
            TsData T2 = this.decomposition.getData("t_cmp", TsData.class);
            TsData S = this.decomposition.getData("s_cmp", TsData.class);
            TsData I = this.decomposition.getData("i_cmp", TsData.class);
            TsData Cal = this.regarima == null ? null : this.regarima.getData("cal", TsData.class);
            TsData D = this.regarima == null ? null : this.regarima.getData("det", TsData.class);
            DecompositionMode m = this.finals.getData("mode", DecompositionMode.class);
            boolean mul = m != null ? m != DecompositionMode.Additive : false;
            TsData P = mul ? TsData.divide(D, Cal) : TsData.subtract(D, Cal);
            this.varDecomposition = new StationaryVarianceDecomposition();
            this.varDecomposition.process(O, T2, S, I, Cal, P, mul);
        }
        return this.varDecomposition;
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        GenericSaResults.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }

    public static InformationMapping<GenericSaResults> getMapping() {
        return MAPPING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void setMapping(String name, Class<T> tclass, Function<GenericSaResults, T> extractor) {
        InformationMapping<GenericSaResults> informationMapping = MAPPING;
        synchronized (informationMapping) {
            MAPPING.set(name, tclass, extractor);
        }
    }

    static {
        MAPPING.set(METHOD, String.class, source -> source.decomposition instanceof X11Results ? "x13" : "tramoseats");
        MAPPING.set(InformationSet.concatenate(VARIANCE, CYCLE), Double.class, source -> source.varDecomposition().getVarC());
        MAPPING.set(InformationSet.concatenate(VARIANCE, SEASONAL), Double.class, source -> source.varDecomposition().getVarS());
        MAPPING.set(InformationSet.concatenate(VARIANCE, IRREGULAR), Double.class, source -> source.varDecomposition().getVarI());
        MAPPING.set(InformationSet.concatenate(VARIANCE, TD), Double.class, source -> source.varDecomposition().getVarTD());
        MAPPING.set(InformationSet.concatenate(VARIANCE, OTHERS), Double.class, source -> source.varDecomposition().getVarP());
        MAPPING.set(InformationSet.concatenate(VARIANCE, TOTAL), Double.class, source -> source.varDecomposition().getVarTotal());
    }
}

