/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DeterministicComponent;
import ec.tstoolkit.modelling.UserVariable;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.timeseries.regression.AbstractTsVariableBox;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.RegressionUtilities;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PreadjustmentVariable {
    private final ITsVariable variable;
    private final ComponentType type;
    private final double[] coefficients;

    public static PreadjustmentVariable calendarVariable(ICalendarVariable s, double[] c) {
        return new PreadjustmentVariable(s, ComponentType.CalendarEffect, c);
    }

    public static PreadjustmentVariable tdVariable(ITsVariable s, double[] c) {
        return new PreadjustmentVariable(AbstractTsVariableBox.tradingDays(s), ComponentType.CalendarEffect, c);
    }

    public static PreadjustmentVariable lpVariable(ITsVariable s, double c) {
        return new PreadjustmentVariable(AbstractTsVariableBox.leapYear(s), ComponentType.CalendarEffect, new double[]{c});
    }

    public static PreadjustmentVariable movingHolidayVariable(IMovingHolidayVariable s, double[] c) {
        return new PreadjustmentVariable(s, ComponentType.CalendarEffect, c);
    }

    public static PreadjustmentVariable movingHolidayVariable(ITsVariable s, double[] c) {
        return new PreadjustmentVariable(AbstractTsVariableBox.movingHoliday(s), ComponentType.CalendarEffect, c);
    }

    public static PreadjustmentVariable userVariable(IUserTsVariable s, ComponentType cmp, double[] c) {
        return new PreadjustmentVariable(s, cmp, c);
    }

    public static PreadjustmentVariable userVariable(ITsVariable s, ComponentType cmp, double[] c) {
        UserVariable user = new UserVariable(s, cmp);
        return new PreadjustmentVariable(user, cmp, c);
    }

    public static PreadjustmentVariable outlier(IOutlierVariable o, double[] c) {
        return new PreadjustmentVariable(o, DeterministicComponent.getType(o), c);
    }

    public static PreadjustmentVariable fix(Variable var, double[] c) {
        return new PreadjustmentVariable(var.getVariable(), var.type, c);
    }

    private PreadjustmentVariable(ITsVariable var, ComponentType cmp, double[] coeff) {
        this.variable = var;
        this.type = cmp;
        this.coefficients = coeff;
    }

    public ITsVariable getVariable() {
        return this.variable;
    }

    public ITsVariable getRootVariable() {
        return TsVariableList.getRoot(this.variable);
    }

    public <T extends ITsVariable> boolean isCompatible(Class<T> tclass) {
        return tclass.isAssignableFrom(TsVariableList.getRoot(this.variable).getClass());
    }

    public boolean isUser() {
        return this.variable instanceof IUserTsVariable;
    }

    public boolean isCalendar() {
        return this.variable instanceof ICalendarVariable;
    }

    public boolean isMovingHoliday() {
        return this.variable instanceof IMovingHolidayVariable;
    }

    public boolean isOutlier() {
        return this.variable instanceof IOutlierVariable;
    }

    public void addEffect(DataBlock cumulator, TsDomain domain) {
        Matrix m = RegressionUtilities.matrix(this.variable, domain);
        for (int i = 0; i < this.coefficients.length; ++i) {
            cumulator.addAY(this.coefficients[i], m.column(i));
        }
    }

    public static DataBlock regressionEffect(Stream<PreadjustmentVariable> regs, TsDomain domain, Predicate<PreadjustmentVariable> pred) {
        DataBlock z = new DataBlock(domain.getLength());
        regs.filter(reg -> pred.test((PreadjustmentVariable)reg)).forEach(reg -> {
            Matrix m = RegressionUtilities.matrix(reg.getVariable(), domain);
            for (int i = 0; i < reg.coefficients.length; ++i) {
                z.addAY(reg.coefficients[i], m.column(i));
            }
        });
        return z;
    }

    public static int countRegressors(Stream<PreadjustmentVariable> regs, Predicate<PreadjustmentVariable> pred) {
        return regs.filter(pred).mapToInt(var -> var.getVariable().getDim()).sum();
    }

    public static int countVariables(Stream<PreadjustmentVariable> regs, Predicate<PreadjustmentVariable> pred) {
        return (int)regs.filter(pred).count();
    }

    public static DataBlock regressionEffect(Stream<PreadjustmentVariable> regs, TsDomain domain, ComponentType type) {
        return PreadjustmentVariable.regressionEffect(regs, domain, (PreadjustmentVariable reg) -> reg.getType() == type);
    }

    public static DataBlock regressionEffect(Stream<PreadjustmentVariable> regs, TsDomain domain) {
        return PreadjustmentVariable.regressionEffect(regs, domain, (PreadjustmentVariable reg) -> true);
    }

    public static <T extends ITsVariable> DataBlock regressionEffect(Stream<PreadjustmentVariable> regs, TsDomain domain, Class<T> tclass) {
        return PreadjustmentVariable.regressionEffect(regs, domain, (PreadjustmentVariable reg) -> tclass.isInstance(reg.variable));
    }

    public ComponentType getType() {
        return this.type;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }
}

